/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import tech.powerjob.common.enums.DispatchStrategy;
import tech.powerjob.common.enums.ExecuteType;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.model.AlarmConfig;
import tech.powerjob.common.model.LifeCycle;
import tech.powerjob.common.model.LogConfig;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;

public class JobInfoVO {
    private Long id;
    private String jobName;
    private String jobDescription;
    private Long appId;
    private String jobParams;
    private String timeExpressionType;
    private String timeExpression;
    private String executeType;
    private String processorType;
    private String processorInfo;
    private Integer maxInstanceNum;
    private Integer concurrency;
    private Long instanceTimeLimit;
    private Integer instanceRetryNum;
    private Integer taskRetryNum;
    private boolean enable;
    private Long nextTriggerTime;
    private String nextTriggerTimeStr;
    private double minCpuCores;
    private double minMemorySpace;
    private double minDiskSpace;
    private Date gmtCreate;
    private Date gmtModified;
    private String designatedWorkers;
    private Integer maxWorkerCount;
    private List<String> notifyUserIds;
    private String extra;
    private String dispatchStrategy;
    private LifeCycle lifeCycle;
    private AlarmConfig alarmConfig;
    private String tag;
    private LogConfig logConfig;

    public static JobInfoVO from(JobInfoDO jobInfoDO) {
        JobInfoVO jobInfoVO = new JobInfoVO();
        BeanUtils.copyProperties((Object)jobInfoDO, (Object)jobInfoVO);
        TimeExpressionType timeExpressionType = TimeExpressionType.of((int)jobInfoDO.getTimeExpressionType());
        ExecuteType executeType = ExecuteType.of((int)jobInfoDO.getExecuteType());
        ProcessorType processorType = ProcessorType.of((int)jobInfoDO.getProcessorType());
        DispatchStrategy dispatchStrategy = DispatchStrategy.of((Integer)jobInfoDO.getDispatchStrategy());
        jobInfoVO.setTimeExpressionType(timeExpressionType.name());
        jobInfoVO.setExecuteType(executeType.name());
        jobInfoVO.setProcessorType(processorType.name());
        jobInfoVO.setEnable(jobInfoDO.getStatus().intValue() == SwitchableStatus.ENABLE.getV());
        jobInfoVO.setDispatchStrategy(dispatchStrategy.name());
        if (!StringUtils.isEmpty((CharSequence)jobInfoDO.getNotifyUserIds())) {
            jobInfoVO.setNotifyUserIds(SJ.COMMA_SPLITTER.splitToList((CharSequence)jobInfoDO.getNotifyUserIds()));
        } else {
            jobInfoVO.setNotifyUserIds((List)Lists.newLinkedList());
        }
        jobInfoVO.setNextTriggerTimeStr(CommonUtils.formatTime((Long)jobInfoDO.getNextTriggerTime()));
        if (!StringUtils.isEmpty((CharSequence)jobInfoDO.getAlarmConfig())) {
            jobInfoVO.setAlarmConfig((AlarmConfig)JSON.parseObject((String)jobInfoDO.getAlarmConfig(), AlarmConfig.class));
        } else {
            jobInfoVO.setAlarmConfig(new AlarmConfig());
        }
        if (!StringUtils.isEmpty((CharSequence)jobInfoDO.getLifecycle())) {
            jobInfoVO.setLifeCycle(LifeCycle.parse((String)jobInfoDO.getLifecycle()));
        }
        if (!StringUtils.isEmpty((CharSequence)jobInfoDO.getLogConfig())) {
            jobInfoVO.setLogConfig((LogConfig)JSONObject.parseObject((String)jobInfoDO.getLogConfig(), LogConfig.class));
        } else {
            jobInfoVO.setLogConfig(new LogConfig());
        }
        return jobInfoVO;
    }

    public Long getId() {
        return this.id;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getJobParams() {
        return this.jobParams;
    }

    public String getTimeExpressionType() {
        return this.timeExpressionType;
    }

    public String getTimeExpression() {
        return this.timeExpression;
    }

    public String getExecuteType() {
        return this.executeType;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public String getProcessorInfo() {
        return this.processorInfo;
    }

    public Integer getMaxInstanceNum() {
        return this.maxInstanceNum;
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    public Long getInstanceTimeLimit() {
        return this.instanceTimeLimit;
    }

    public Integer getInstanceRetryNum() {
        return this.instanceRetryNum;
    }

    public Integer getTaskRetryNum() {
        return this.taskRetryNum;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Long getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public String getNextTriggerTimeStr() {
        return this.nextTriggerTimeStr;
    }

    public double getMinCpuCores() {
        return this.minCpuCores;
    }

    public double getMinMemorySpace() {
        return this.minMemorySpace;
    }

    public double getMinDiskSpace() {
        return this.minDiskSpace;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public String getDesignatedWorkers() {
        return this.designatedWorkers;
    }

    public Integer getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    public List<String> getNotifyUserIds() {
        return this.notifyUserIds;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getDispatchStrategy() {
        return this.dispatchStrategy;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public AlarmConfig getAlarmConfig() {
        return this.alarmConfig;
    }

    public String getTag() {
        return this.tag;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setJobParams(String jobParams) {
        this.jobParams = jobParams;
    }

    public void setTimeExpressionType(String timeExpressionType) {
        this.timeExpressionType = timeExpressionType;
    }

    public void setTimeExpression(String timeExpression) {
        this.timeExpression = timeExpression;
    }

    public void setExecuteType(String executeType) {
        this.executeType = executeType;
    }

    public void setProcessorType(String processorType) {
        this.processorType = processorType;
    }

    public void setProcessorInfo(String processorInfo) {
        this.processorInfo = processorInfo;
    }

    public void setMaxInstanceNum(Integer maxInstanceNum) {
        this.maxInstanceNum = maxInstanceNum;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public void setInstanceTimeLimit(Long instanceTimeLimit) {
        this.instanceTimeLimit = instanceTimeLimit;
    }

    public void setInstanceRetryNum(Integer instanceRetryNum) {
        this.instanceRetryNum = instanceRetryNum;
    }

    public void setTaskRetryNum(Integer taskRetryNum) {
        this.taskRetryNum = taskRetryNum;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setNextTriggerTime(Long nextTriggerTime) {
        this.nextTriggerTime = nextTriggerTime;
    }

    public void setNextTriggerTimeStr(String nextTriggerTimeStr) {
        this.nextTriggerTimeStr = nextTriggerTimeStr;
    }

    public void setMinCpuCores(double minCpuCores) {
        this.minCpuCores = minCpuCores;
    }

    public void setMinMemorySpace(double minMemorySpace) {
        this.minMemorySpace = minMemorySpace;
    }

    public void setMinDiskSpace(double minDiskSpace) {
        this.minDiskSpace = minDiskSpace;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setDesignatedWorkers(String designatedWorkers) {
        this.designatedWorkers = designatedWorkers;
    }

    public void setMaxWorkerCount(Integer maxWorkerCount) {
        this.maxWorkerCount = maxWorkerCount;
    }

    public void setNotifyUserIds(List<String> notifyUserIds) {
        this.notifyUserIds = notifyUserIds;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setDispatchStrategy(String dispatchStrategy) {
        this.dispatchStrategy = dispatchStrategy;
    }

    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void setAlarmConfig(AlarmConfig alarmConfig) {
        this.alarmConfig = alarmConfig;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobInfoVO)) {
            return false;
        }
        JobInfoVO other = (JobInfoVO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$jobDescription = this.getJobDescription();
        String other$jobDescription = other.getJobDescription();
        if (this$jobDescription == null ? other$jobDescription != null : !this$jobDescription.equals(other$jobDescription)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        String this$jobParams = this.getJobParams();
        String other$jobParams = other.getJobParams();
        if (this$jobParams == null ? other$jobParams != null : !this$jobParams.equals(other$jobParams)) {
            return false;
        }
        String this$timeExpressionType = this.getTimeExpressionType();
        String other$timeExpressionType = other.getTimeExpressionType();
        if (this$timeExpressionType == null ? other$timeExpressionType != null : !this$timeExpressionType.equals(other$timeExpressionType)) {
            return false;
        }
        String this$timeExpression = this.getTimeExpression();
        String other$timeExpression = other.getTimeExpression();
        if (this$timeExpression == null ? other$timeExpression != null : !this$timeExpression.equals(other$timeExpression)) {
            return false;
        }
        String this$executeType = this.getExecuteType();
        String other$executeType = other.getExecuteType();
        if (this$executeType == null ? other$executeType != null : !this$executeType.equals(other$executeType)) {
            return false;
        }
        String this$processorType = this.getProcessorType();
        String other$processorType = other.getProcessorType();
        if (this$processorType == null ? other$processorType != null : !this$processorType.equals(other$processorType)) {
            return false;
        }
        String this$processorInfo = this.getProcessorInfo();
        String other$processorInfo = other.getProcessorInfo();
        if (this$processorInfo == null ? other$processorInfo != null : !this$processorInfo.equals(other$processorInfo)) {
            return false;
        }
        Integer this$maxInstanceNum = this.getMaxInstanceNum();
        Integer other$maxInstanceNum = other.getMaxInstanceNum();
        if (this$maxInstanceNum == null ? other$maxInstanceNum != null : !((Object)this$maxInstanceNum).equals(other$maxInstanceNum)) {
            return false;
        }
        Integer this$concurrency = this.getConcurrency();
        Integer other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
            return false;
        }
        Long this$instanceTimeLimit = this.getInstanceTimeLimit();
        Long other$instanceTimeLimit = other.getInstanceTimeLimit();
        if (this$instanceTimeLimit == null ? other$instanceTimeLimit != null : !((Object)this$instanceTimeLimit).equals(other$instanceTimeLimit)) {
            return false;
        }
        Integer this$instanceRetryNum = this.getInstanceRetryNum();
        Integer other$instanceRetryNum = other.getInstanceRetryNum();
        if (this$instanceRetryNum == null ? other$instanceRetryNum != null : !((Object)this$instanceRetryNum).equals(other$instanceRetryNum)) {
            return false;
        }
        Integer this$taskRetryNum = this.getTaskRetryNum();
        Integer other$taskRetryNum = other.getTaskRetryNum();
        if (this$taskRetryNum == null ? other$taskRetryNum != null : !((Object)this$taskRetryNum).equals(other$taskRetryNum)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        Long this$nextTriggerTime = this.getNextTriggerTime();
        Long other$nextTriggerTime = other.getNextTriggerTime();
        if (this$nextTriggerTime == null ? other$nextTriggerTime != null : !((Object)this$nextTriggerTime).equals(other$nextTriggerTime)) {
            return false;
        }
        String this$nextTriggerTimeStr = this.getNextTriggerTimeStr();
        String other$nextTriggerTimeStr = other.getNextTriggerTimeStr();
        if (this$nextTriggerTimeStr == null ? other$nextTriggerTimeStr != null : !this$nextTriggerTimeStr.equals(other$nextTriggerTimeStr)) {
            return false;
        }
        if (Double.compare(this.getMinCpuCores(), other.getMinCpuCores()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinMemorySpace(), other.getMinMemorySpace()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinDiskSpace(), other.getMinDiskSpace()) != 0) {
            return false;
        }
        Date this$gmtCreate = this.getGmtCreate();
        Date other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Date this$gmtModified = this.getGmtModified();
        Date other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$designatedWorkers = this.getDesignatedWorkers();
        String other$designatedWorkers = other.getDesignatedWorkers();
        if (this$designatedWorkers == null ? other$designatedWorkers != null : !this$designatedWorkers.equals(other$designatedWorkers)) {
            return false;
        }
        Integer this$maxWorkerCount = this.getMaxWorkerCount();
        Integer other$maxWorkerCount = other.getMaxWorkerCount();
        if (this$maxWorkerCount == null ? other$maxWorkerCount != null : !((Object)this$maxWorkerCount).equals(other$maxWorkerCount)) {
            return false;
        }
        List this$notifyUserIds = this.getNotifyUserIds();
        List other$notifyUserIds = other.getNotifyUserIds();
        if (this$notifyUserIds == null ? other$notifyUserIds != null : !((Object)this$notifyUserIds).equals(other$notifyUserIds)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        String this$dispatchStrategy = this.getDispatchStrategy();
        String other$dispatchStrategy = other.getDispatchStrategy();
        if (this$dispatchStrategy == null ? other$dispatchStrategy != null : !this$dispatchStrategy.equals(other$dispatchStrategy)) {
            return false;
        }
        LifeCycle this$lifeCycle = this.getLifeCycle();
        LifeCycle other$lifeCycle = other.getLifeCycle();
        if (this$lifeCycle == null ? other$lifeCycle != null : !this$lifeCycle.equals(other$lifeCycle)) {
            return false;
        }
        AlarmConfig this$alarmConfig = this.getAlarmConfig();
        AlarmConfig other$alarmConfig = other.getAlarmConfig();
        if (this$alarmConfig == null ? other$alarmConfig != null : !this$alarmConfig.equals(other$alarmConfig)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        LogConfig this$logConfig = this.getLogConfig();
        LogConfig other$logConfig = other.getLogConfig();
        return !(this$logConfig == null ? other$logConfig != null : !this$logConfig.equals(other$logConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobInfoVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $jobDescription = this.getJobDescription();
        result = result * 59 + ($jobDescription == null ? 43 : $jobDescription.hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        String $jobParams = this.getJobParams();
        result = result * 59 + ($jobParams == null ? 43 : $jobParams.hashCode());
        String $timeExpressionType = this.getTimeExpressionType();
        result = result * 59 + ($timeExpressionType == null ? 43 : $timeExpressionType.hashCode());
        String $timeExpression = this.getTimeExpression();
        result = result * 59 + ($timeExpression == null ? 43 : $timeExpression.hashCode());
        String $executeType = this.getExecuteType();
        result = result * 59 + ($executeType == null ? 43 : $executeType.hashCode());
        String $processorType = this.getProcessorType();
        result = result * 59 + ($processorType == null ? 43 : $processorType.hashCode());
        String $processorInfo = this.getProcessorInfo();
        result = result * 59 + ($processorInfo == null ? 43 : $processorInfo.hashCode());
        Integer $maxInstanceNum = this.getMaxInstanceNum();
        result = result * 59 + ($maxInstanceNum == null ? 43 : ((Object)$maxInstanceNum).hashCode());
        Integer $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
        Long $instanceTimeLimit = this.getInstanceTimeLimit();
        result = result * 59 + ($instanceTimeLimit == null ? 43 : ((Object)$instanceTimeLimit).hashCode());
        Integer $instanceRetryNum = this.getInstanceRetryNum();
        result = result * 59 + ($instanceRetryNum == null ? 43 : ((Object)$instanceRetryNum).hashCode());
        Integer $taskRetryNum = this.getTaskRetryNum();
        result = result * 59 + ($taskRetryNum == null ? 43 : ((Object)$taskRetryNum).hashCode());
        result = result * 59 + (this.isEnable() ? 79 : 97);
        Long $nextTriggerTime = this.getNextTriggerTime();
        result = result * 59 + ($nextTriggerTime == null ? 43 : ((Object)$nextTriggerTime).hashCode());
        String $nextTriggerTimeStr = this.getNextTriggerTimeStr();
        result = result * 59 + ($nextTriggerTimeStr == null ? 43 : $nextTriggerTimeStr.hashCode());
        long $minCpuCores = Double.doubleToLongBits(this.getMinCpuCores());
        result = result * 59 + (int)($minCpuCores >>> 32 ^ $minCpuCores);
        long $minMemorySpace = Double.doubleToLongBits(this.getMinMemorySpace());
        result = result * 59 + (int)($minMemorySpace >>> 32 ^ $minMemorySpace);
        long $minDiskSpace = Double.doubleToLongBits(this.getMinDiskSpace());
        result = result * 59 + (int)($minDiskSpace >>> 32 ^ $minDiskSpace);
        Date $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Date $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $designatedWorkers = this.getDesignatedWorkers();
        result = result * 59 + ($designatedWorkers == null ? 43 : $designatedWorkers.hashCode());
        Integer $maxWorkerCount = this.getMaxWorkerCount();
        result = result * 59 + ($maxWorkerCount == null ? 43 : ((Object)$maxWorkerCount).hashCode());
        List $notifyUserIds = this.getNotifyUserIds();
        result = result * 59 + ($notifyUserIds == null ? 43 : ((Object)$notifyUserIds).hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        String $dispatchStrategy = this.getDispatchStrategy();
        result = result * 59 + ($dispatchStrategy == null ? 43 : $dispatchStrategy.hashCode());
        LifeCycle $lifeCycle = this.getLifeCycle();
        result = result * 59 + ($lifeCycle == null ? 43 : $lifeCycle.hashCode());
        AlarmConfig $alarmConfig = this.getAlarmConfig();
        result = result * 59 + ($alarmConfig == null ? 43 : $alarmConfig.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        LogConfig $logConfig = this.getLogConfig();
        result = result * 59 + ($logConfig == null ? 43 : $logConfig.hashCode());
        return result;
    }

    public String toString() {
        return "JobInfoVO(id=" + this.getId() + ", jobName=" + this.getJobName() + ", jobDescription=" + this.getJobDescription() + ", appId=" + this.getAppId() + ", jobParams=" + this.getJobParams() + ", timeExpressionType=" + this.getTimeExpressionType() + ", timeExpression=" + this.getTimeExpression() + ", executeType=" + this.getExecuteType() + ", processorType=" + this.getProcessorType() + ", processorInfo=" + this.getProcessorInfo() + ", maxInstanceNum=" + this.getMaxInstanceNum() + ", concurrency=" + this.getConcurrency() + ", instanceTimeLimit=" + this.getInstanceTimeLimit() + ", instanceRetryNum=" + this.getInstanceRetryNum() + ", taskRetryNum=" + this.getTaskRetryNum() + ", enable=" + this.isEnable() + ", nextTriggerTime=" + this.getNextTriggerTime() + ", nextTriggerTimeStr=" + this.getNextTriggerTimeStr() + ", minCpuCores=" + this.getMinCpuCores() + ", minMemorySpace=" + this.getMinMemorySpace() + ", minDiskSpace=" + this.getMinDiskSpace() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", designatedWorkers=" + this.getDesignatedWorkers() + ", maxWorkerCount=" + this.getMaxWorkerCount() + ", notifyUserIds=" + this.getNotifyUserIds() + ", extra=" + this.getExtra() + ", dispatchStrategy=" + this.getDispatchStrategy() + ", lifeCycle=" + this.getLifeCycle() + ", alarmConfig=" + this.getAlarmConfig() + ", tag=" + this.getTag() + ", logConfig=" + this.getLogConfig() + ")";
    }
}

