/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.common.utils.OmsFileUtils;
import tech.powerjob.server.core.instance.InstanceLogService;
import tech.powerjob.server.core.instance.InstanceService;
import tech.powerjob.server.core.service.CacheService;
import tech.powerjob.server.persistence.PageResult;
import tech.powerjob.server.persistence.StringPage;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.web.request.QueryInstanceRequest;
import tech.powerjob.server.web.response.InstanceDetailVO;
import tech.powerjob.server.web.response.InstanceInfoVO;

@RestController
@RequestMapping(value={"/instance"})
public class InstanceController {
    private static final Logger log = LoggerFactory.getLogger(InstanceController.class);
    @Resource
    private InstanceService instanceService;
    @Resource
    private InstanceLogService instanceLogService;
    @Resource
    private CacheService cacheService;
    @Resource
    private InstanceInfoRepository instanceInfoRepository;

    @GetMapping(value={"/stop"})
    public ResultDTO<Void> stopInstance(Long appId, Long instanceId) {
        this.instanceService.stopInstance(appId, instanceId);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/retry"})
    public ResultDTO<Void> retryInstance(String appId, Long instanceId) {
        this.instanceService.retryInstance(Long.valueOf(appId), instanceId);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/detail"})
    public ResultDTO<InstanceDetailVO> getInstanceDetail(Long instanceId) {
        return ResultDTO.success((Object)InstanceDetailVO.from((InstanceDetail)this.instanceService.getInstanceDetail(instanceId)));
    }

    @GetMapping(value={"/log"})
    public ResultDTO<StringPage> getInstanceLog(Long appId, Long instanceId, Long index) {
        return ResultDTO.success((Object)this.instanceLogService.fetchInstanceLog(appId, instanceId, index));
    }

    @GetMapping(value={"/downloadLogUrl"})
    public ResultDTO<String> getDownloadUrl(Long appId, Long instanceId) {
        return ResultDTO.success((Object)this.instanceLogService.fetchDownloadUrl(appId, instanceId));
    }

    @GetMapping(value={"/downloadLog"})
    public void downloadLogFile(Long instanceId, HttpServletResponse response) throws Exception {
        File file = this.instanceLogService.downloadInstanceLog(instanceId.longValue());
        OmsFileUtils.file2HttpResponse((File)file, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/downloadLog4Console"})
    public void downloadLog4Console(Long appId, Long instanceId, HttpServletResponse response) {
        String downloadUrl = this.instanceLogService.fetchDownloadUrl(appId, instanceId);
        String logFilePath = OmsFileUtils.genTemporaryWorkPath() + String.format("powerjob-%s-%s.log", appId, instanceId);
        File logFile = new File(logFilePath);
        try {
            FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)logFile);
            OmsFileUtils.file2HttpResponse((File)logFile, (HttpServletResponse)response);
        }
        finally {
            FileUtils.forceDelete((File)logFile);
        }
    }

    @PostMapping(value={"/list"})
    public ResultDTO<PageResult<InstanceInfoVO>> list(@RequestBody QueryInstanceRequest request) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"gmtModified"});
        PageRequest pageable = PageRequest.of((int)request.getIndex(), (int)request.getPageSize(), (Sort)sort);
        InstanceInfoDO queryEntity = new InstanceInfoDO();
        BeanUtils.copyProperties((Object)request, (Object)queryEntity);
        queryEntity.setType(Integer.valueOf(request.getType().getV()));
        if (!StringUtils.isEmpty((CharSequence)request.getStatus())) {
            queryEntity.setStatus(Integer.valueOf(InstanceStatus.valueOf((String)request.getStatus()).getV()));
        }
        Page pageResult = this.instanceInfoRepository.findAll(Example.of((Object)queryEntity), (Pageable)pageable);
        return ResultDTO.success((Object)this.convertPage(pageResult));
    }

    private PageResult<InstanceInfoVO> convertPage(Page<InstanceInfoDO> page) {
        List content = page.getContent().stream().map(x -> InstanceInfoVO.from((InstanceInfoDO)x, (String)this.cacheService.getJobName(x.getJobId()))).collect(Collectors.toList());
        PageResult pageResult = new PageResult(page);
        pageResult.setData(content);
        return pageResult;
    }
}

