/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.worker;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.model.DeployedContainerInfo;
import tech.powerjob.common.request.WorkerHeartbeat;
import tech.powerjob.server.common.module.WorkerInfo;

public class ClusterStatusHolder {
    private static final Logger log = LoggerFactory.getLogger(ClusterStatusHolder.class);
    private final String appName;
    private final Map<String, WorkerInfo> address2WorkerInfo;
    private Map<Long, Map<String, DeployedContainerInfo>> containerId2Infos;

    public ClusterStatusHolder(String appName) {
        this.appName = appName;
        this.address2WorkerInfo = Maps.newConcurrentMap();
        this.containerId2Infos = Maps.newConcurrentMap();
    }

    public void updateStatus(WorkerHeartbeat heartbeat) {
        WorkerInfo workerInfo;
        long oldTime;
        String workerAddress = heartbeat.getWorkerAddress();
        long heartbeatTime = heartbeat.getHeartbeatTime();
        if (heartbeatTime < (oldTime = (workerInfo = this.address2WorkerInfo.computeIfAbsent(workerAddress, ignore -> {
            WorkerInfo wf = new WorkerInfo();
            wf.refresh(heartbeat);
            return wf;
        })).getLastActiveTime())) {
            log.warn("[ClusterStatusHolder-{}] receive the expired heartbeat from {}, serverTime: {}, heartTime: {}", new Object[]{this.appName, heartbeat.getWorkerAddress(), System.currentTimeMillis(), heartbeat.getHeartbeatTime()});
            return;
        }
        workerInfo.refresh(heartbeat);
        List containerInfos = heartbeat.getContainerInfos();
        if (!CollectionUtils.isEmpty((Collection)containerInfos)) {
            containerInfos.forEach(containerInfo -> {
                Map infos = this.containerId2Infos.computeIfAbsent(containerInfo.getContainerId(), ignore -> Maps.newConcurrentMap());
                infos.put(workerAddress, containerInfo);
            });
        }
    }

    public Map<String, WorkerInfo> getAllWorkers() {
        return this.address2WorkerInfo;
    }

    public List<DeployedContainerInfo> getDeployedContainerInfos(Long containerId) {
        LinkedList res = Lists.newLinkedList();
        this.containerId2Infos.getOrDefault(containerId, Collections.emptyMap()).forEach((address, info) -> {
            info.setWorkerAddress(address);
            res.add(info);
        });
        return res;
    }

    public void release() {
        log.info("[ClusterStatusHolder-{}] clean the containerInfos, listDeployedContainer service may down about 1min~", (Object)this.appName);
        this.containerId2Infos = Maps.newConcurrentMap();
        LinkedList timeoutAddress = Lists.newLinkedList();
        this.address2WorkerInfo.forEach((addr, workerInfo) -> {
            if (workerInfo.timeout()) {
                timeoutAddress.add(addr);
            }
        });
        if (!timeoutAddress.isEmpty()) {
            log.info("[ClusterStatusHolder-{}] detective timeout workers({}), try to release their infos.", (Object)this.appName, (Object)timeoutAddress);
            timeoutAddress.forEach(this.address2WorkerInfo::remove);
        }
    }
}

