/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.worker.utils;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.common.module.WorkerInfo;

public class SpecifyUtils {
    private static final String TAG_EQUALS = "tagEquals:";
    private static final String TAG_IN = "tagIn:";

    public static boolean match(WorkerInfo workerInfo, String specifyInfo) {
        String workerTag = workerInfo.getTag();
        if (specifyInfo.startsWith(TAG_IN)) {
            String targetTag = specifyInfo.replace(TAG_IN, "");
            return Optional.ofNullable(workerTag).orElse("").contains(targetTag);
        }
        if (specifyInfo.startsWith(TAG_EQUALS)) {
            String targetTag = specifyInfo.replace(TAG_EQUALS, "");
            return Optional.ofNullable(workerTag).orElse("").equals(targetTag);
        }
        HashSet designatedWorkersSet = Sets.newHashSet((Iterable)SJ.COMMA_SPLITTER.splitToList((CharSequence)specifyInfo));
        for (String tagOrAddress : designatedWorkersSet) {
            if (!tagOrAddress.equals(workerInfo.getTag()) && !tagOrAddress.equals(workerInfo.getAddress())) continue;
            return true;
        }
        return false;
    }
}

