/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.storage.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.common.spring.condition.PropertyAndOneBeanCondition;
import tech.powerjob.server.extension.dfs.DFsService;
import tech.powerjob.server.extension.dfs.DownloadRequest;
import tech.powerjob.server.extension.dfs.FileLocation;
import tech.powerjob.server.extension.dfs.FileMeta;
import tech.powerjob.server.extension.dfs.StoreRequest;
import tech.powerjob.server.persistence.storage.AbstractDFsService;

@Priority(value=0x7FFFFFFD)
@Conditional(value={MySqlSeriesCondition.class})
public class MySqlSeriesDfsService
extends AbstractDFsService {
    private static final Logger log = LoggerFactory.getLogger(MySqlSeriesDfsService.class);
    private DataSource dataSource;
    private static final String TYPE_MYSQL = "mysql_series";
    private static final String KEY_DRIVER_NAME = "driver";
    private static final String KEY_URL = "url";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_AUTO_CREATE_TABLE = "auto_create_table";
    private static final String KEY_TABLE_NAME = "table_name";
    private static final String DEFAULT_TABLE_NAME = "powerjob_files";
    private static final String CREATE_TABLE_SQL = "CREATE TABLE\nIF\n\tNOT EXISTS %s (\n\t\t`id` BIGINT NOT NULL AUTO_INCREMENT COMMENT 'ID',\n\t\t`bucket` VARCHAR ( 255 ) NOT NULL COMMENT '\u5206\u6876',\n\t\t`name` VARCHAR ( 255 ) NOT NULL COMMENT '\u6587\u4ef6\u540d\u79f0',\n\t\t`version` VARCHAR ( 255 ) NOT NULL COMMENT '\u7248\u672c',\n\t\t`meta` VARCHAR ( 255 ) COMMENT '\u5143\u6570\u636e',\n\t\t`length` BIGINT NOT NULL COMMENT '\u957f\u5ea6',\n\t\t`status` INT NOT NULL COMMENT '\u72b6\u6001',\n\t\t`data` LONGBLOB NOT NULL COMMENT '\u6587\u4ef6\u5185\u5bb9',\n\t\t`extra` VARCHAR ( 255 ) COMMENT '\u5176\u4ed6\u4fe1\u606f',\n\t\t`gmt_create` DATETIME NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',\n\t\t`gmt_modified` DATETIME COMMENT '\u66f4\u65b0\u65f6\u95f4',\n\tPRIMARY KEY ( id ) \n\t);";
    private static final String INSERT_SQL = "insert into %s(bucket, name, version, meta, length, status, data, extra, gmt_create, gmt_modified) values (?,?,?,?,?,?,?,?,?,?);";
    private static final String DELETE_SQL = "DELETE FROM %s ";
    private static final String QUERY_FULL_SQL = "select * from %s";
    private static final String QUERY_META_SQL = "select bucket, name, version, meta, length, status, extra, gmt_create, gmt_modified from %s";

    private void deleteByLocation(FileLocation fileLocation) {
        String dSQLPrefix = this.fullSQL(DELETE_SQL);
        String dSQL = dSQLPrefix.concat(MySqlSeriesDfsService.whereSQL(fileLocation));
        this.executeDelete(dSQL);
    }

    private void executeDelete(String sql) {
        try (Connection con = this.dataSource.getConnection();){
            con.createStatement().executeUpdate(sql);
        }
        catch (Exception e) {
            log.error("[MySqlSeriesDfsService] executeDelete failed, sql: {}", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(StoreRequest storeRequest) throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        String insertSQL = this.fullSQL(INSERT_SQL);
        FileLocation fileLocation = storeRequest.getFileLocation();
        this.deleteByLocation(fileLocation);
        HashMap meta = Maps.newHashMap();
        meta.put("_server_", this.serverInfo.getIp());
        meta.put("_local_file_path_", storeRequest.getLocalFile().getAbsolutePath());
        Date date = new Date(System.currentTimeMillis());
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(storeRequest.getLocalFile().toPath(), new OpenOption[0]));
             Connection con = this.dataSource.getConnection();){
            PreparedStatement pst = con.prepareStatement(insertSQL);
            pst.setString(1, fileLocation.getBucket());
            pst.setString(2, fileLocation.getName());
            pst.setString(3, "mu");
            pst.setString(4, JsonUtils.toJSONString((Object)meta));
            pst.setLong(5, storeRequest.getLocalFile().length());
            pst.setInt(6, SwitchableStatus.ENABLE.getV());
            pst.setBlob(7, bufferedInputStream);
            pst.setString(8, null);
            pst.setDate(9, date);
            pst.setDate(10, date);
            pst.execute();
            log.info("[MySqlSeriesDfsService] store [{}] successfully, cost: {}", (Object)fileLocation, (Object)sw);
        }
    }

    public void download(DownloadRequest downloadRequest) throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        String querySQL = this.fullSQL(QUERY_FULL_SQL);
        FileLocation fileLocation = downloadRequest.getFileLocation();
        FileUtils.forceMkdirParent((File)downloadRequest.getTarget());
        try (Connection con = this.dataSource.getConnection();){
            ResultSet resultSet = con.createStatement().executeQuery(querySQL.concat(MySqlSeriesDfsService.whereSQL(fileLocation)));
            boolean exist = resultSet.next();
            if (!exist) {
                log.warn("[MySqlSeriesDfsService] download file[{}] failed due to not exits!", (Object)fileLocation);
                return;
            }
            Blob dataBlob = resultSet.getBlob("data");
            FileUtils.copyInputStreamToFile((InputStream)new BufferedInputStream(dataBlob.getBinaryStream()), (File)downloadRequest.getTarget());
            log.info("[MySqlSeriesDfsService] download [{}] successfully, cost: {}", (Object)fileLocation, (Object)sw);
        }
        catch (Exception e) {
            log.error("[MySqlSeriesDfsService] download file [{}] failed!", (Object)fileLocation, (Object)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<FileMeta> fetchFileMeta(FileLocation fileLocation) throws IOException {
        String querySQL = this.fullSQL(QUERY_META_SQL);
        try (Connection con = this.dataSource.getConnection();){
            ResultSet resultSet = con.createStatement().executeQuery(querySQL.concat(MySqlSeriesDfsService.whereSQL(fileLocation)));
            boolean exist = resultSet.next();
            if (!exist) {
                Optional<FileMeta> optional2 = Optional.empty();
                return optional2;
            }
            FileMeta fileMeta = new FileMeta().setLength(resultSet.getLong("length")).setLastModifiedTime((java.util.Date)resultSet.getDate("gmt_modified")).setMetaInfo(JsonUtils.parseMap((String)resultSet.getString("meta")));
            Optional<FileMeta> optional = Optional.of(fileMeta);
            return optional;
        }
        catch (Exception e) {
            log.error("[MySqlSeriesDfsService] fetchFileMeta [{}] failed!", (Object)fileLocation);
            ExceptionUtils.rethrow((Throwable)e);
            return Optional.empty();
        }
    }

    public void cleanExpiredFiles(String bucket, int days) {
        String dSQLPrefix = this.fullSQL(DELETE_SQL);
        long targetTs = DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)(-days)).getTime();
        String targetDeleteTime = CommonUtils.formatTime((Long)targetTs);
        log.info("[MySqlSeriesDfsService] start to cleanExpiredFiles, targetDeleteTime: {}", (Object)targetDeleteTime);
        String fSQL = dSQLPrefix.concat(String.format(" where gmt_modified < '%s'", targetDeleteTime));
        log.info("[MySqlSeriesDfsService] cleanExpiredFiles SQL: {}", (Object)fSQL);
        this.executeDelete(fSQL);
    }

    @Override
    protected void init(ApplicationContext applicationContext) {
        Environment env = applicationContext.getEnvironment();
        MySQLProperty mySQLProperty = new MySQLProperty().setDriver(MySqlSeriesDfsService.fetchProperty(env, TYPE_MYSQL, KEY_DRIVER_NAME)).setUrl(MySqlSeriesDfsService.fetchProperty(env, TYPE_MYSQL, KEY_URL)).setUsername(MySqlSeriesDfsService.fetchProperty(env, TYPE_MYSQL, KEY_USERNAME)).setPassword(MySqlSeriesDfsService.fetchProperty(env, TYPE_MYSQL, KEY_PASSWORD)).setAutoCreateTable(Boolean.TRUE.toString().equalsIgnoreCase(MySqlSeriesDfsService.fetchProperty(env, TYPE_MYSQL, KEY_AUTO_CREATE_TABLE)));
        try {
            this.initDatabase(mySQLProperty);
            this.initTable(mySQLProperty);
        }
        catch (Exception e) {
            log.error("[MySqlSeriesDfsService] init datasource failed!", (Throwable)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
        log.info("[MySqlSeriesDfsService] initialize successfully, THIS_WILL_BE_THE_STORAGE_LAYER.");
    }

    void initDatabase(MySQLProperty property) {
        log.info("[MySqlSeriesDfsService] init datasource by config: {}", (Object)property);
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(property.driver);
        config.setJdbcUrl(property.url);
        config.setUsername(property.username);
        config.setPassword(property.password);
        config.setAutoCommit(true);
        config.setMinimumIdle(2);
        config.setMaximumPoolSize(32);
        this.dataSource = new HikariDataSource(config);
    }

    void initTable(MySQLProperty property) throws Exception {
        if (property.autoCreateTable) {
            String createTableSQL = this.fullSQL(CREATE_TABLE_SQL);
            log.info("[MySqlSeriesDfsService] use create table SQL: {}", (Object)createTableSQL);
            try (Connection connection = this.dataSource.getConnection();){
                connection.createStatement().execute(createTableSQL);
                log.info("[MySqlSeriesDfsService] auto create table successfully!");
            }
        }
    }

    private String fullSQL(String sql) {
        return String.format(sql, this.parseTableName());
    }

    private String parseTableName() {
        if (this.applicationContext == null) {
            return DEFAULT_TABLE_NAME;
        }
        String tableName = MySqlSeriesDfsService.fetchProperty(this.applicationContext.getEnvironment(), TYPE_MYSQL, KEY_TABLE_NAME);
        return StringUtils.isEmpty((CharSequence)tableName) ? DEFAULT_TABLE_NAME : tableName;
    }

    private static String whereSQL(FileLocation fileLocation) {
        return String.format(" where bucket='%s' AND name='%s' ", fileLocation.getBucket(), fileLocation.getName());
    }

    public void destroy() throws Exception {
    }

    public static class MySqlSeriesCondition
    extends PropertyAndOneBeanCondition {
        protected List<String> anyConfigKey() {
            return Lists.newArrayList((Object[])new String[]{"oms.storage.dfs.mysql_series.url"});
        }

        protected Class<?> beanType() {
            return DFsService.class;
        }
    }

    static class MySQLProperty {
        private String driver;
        private String url;
        private String username;
        private String password;
        private boolean autoCreateTable;

        public String getDriver() {
            return this.driver;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isAutoCreateTable() {
            return this.autoCreateTable;
        }

        public MySQLProperty setDriver(String driver) {
            this.driver = driver;
            return this;
        }

        public MySQLProperty setUrl(String url) {
            this.url = url;
            return this;
        }

        public MySQLProperty setUsername(String username) {
            this.username = username;
            return this;
        }

        public MySQLProperty setPassword(String password) {
            this.password = password;
            return this;
        }

        public MySQLProperty setAutoCreateTable(boolean autoCreateTable) {
            this.autoCreateTable = autoCreateTable;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MySQLProperty)) {
                return false;
            }
            MySQLProperty other = (MySQLProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driver = this.getDriver();
            String other$driver = other.getDriver();
            if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            return this.isAutoCreateTable() == other.isAutoCreateTable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MySQLProperty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driver = this.getDriver();
            result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            result = result * 59 + (this.isAutoCreateTable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "MySqlSeriesDfsService.MySQLProperty(driver=" + this.getDriver() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", autoCreateTable=" + this.isAutoCreateTable() + ")";
        }
    }
}

