/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.storage.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Priority;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import tech.powerjob.server.common.spring.condition.PropertyAndOneBeanCondition;
import tech.powerjob.server.extension.dfs.DFsService;
import tech.powerjob.server.extension.dfs.DownloadRequest;
import tech.powerjob.server.extension.dfs.FileLocation;
import tech.powerjob.server.extension.dfs.FileMeta;
import tech.powerjob.server.extension.dfs.StoreRequest;
import tech.powerjob.server.persistence.storage.AbstractDFsService;

@Priority(value=0x7FFFFFFC)
@Conditional(value={MinioOssCondition.class})
public class MinioOssService
extends AbstractDFsService {
    private static final Logger log = LoggerFactory.getLogger(MinioOssService.class);
    private static final String TYPE_MINIO = "minio";
    private static final String KEY_ENDPOINT = "endpoint";
    private static final String KEY_BUCKET_NAME = "bucketName";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private AmazonS3 amazonS3;
    private String bucket;
    private static final String NOT_FOUNT = "404 Not Found";

    public void store(StoreRequest storeRequest) {
        try {
            String fileName = MinioOssService.parseFileName(storeRequest.getFileLocation());
            PutObjectRequest request = new PutObjectRequest(this.bucket, fileName, storeRequest.getLocalFile());
            this.amazonS3.putObject(request);
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public void download(DownloadRequest downloadRequest) {
        try {
            FileUtils.forceMkdirParent((File)downloadRequest.getTarget());
            String fileName = MinioOssService.parseFileName(downloadRequest.getFileLocation());
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucket, fileName);
            this.amazonS3.getObject(getObjectRequest, downloadRequest.getTarget());
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public Optional<FileMeta> fetchFileMeta(FileLocation fileLocation) {
        try {
            String fileName = MinioOssService.parseFileName(fileLocation);
            ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(this.bucket, fileName);
            return Optional.ofNullable(objectMetadata).map(minioStat -> {
                HashMap metaInfo = Maps.newHashMap();
                if (objectMetadata.getRawMetadata() != null) {
                    metaInfo.putAll(objectMetadata.getRawMetadata());
                }
                return new FileMeta().setLastModifiedTime(objectMetadata.getLastModified()).setLength(objectMetadata.getContentLength()).setMetaInfo((Map)metaInfo);
            });
        }
        catch (AmazonS3Exception s3Exception) {
            String errorCode = s3Exception.getErrorCode();
            if (NOT_FOUNT.equalsIgnoreCase(errorCode)) {
                return Optional.empty();
            }
        }
        catch (Exception oe) {
            ExceptionUtils.rethrow((Throwable)oe);
        }
        return Optional.empty();
    }

    private static String parseFileName(FileLocation fileLocation) {
        return String.format("%s/%s", fileLocation.getBucket(), fileLocation.getName());
    }

    public void cleanExpiredFiles(String bucket, int days) {
    }

    public void destroy() {
    }

    @Override
    protected void init(ApplicationContext applicationContext) {
        Environment environment = applicationContext.getEnvironment();
        String endpoint = MinioOssService.fetchProperty(environment, TYPE_MINIO, KEY_ENDPOINT);
        String bucketName = MinioOssService.fetchProperty(environment, TYPE_MINIO, KEY_BUCKET_NAME);
        String accessKey = MinioOssService.fetchProperty(environment, TYPE_MINIO, ACCESS_KEY);
        String secretKey = MinioOssService.fetchProperty(environment, TYPE_MINIO, SECRET_KEY);
        try {
            this.initOssClient(endpoint, bucketName, accessKey, secretKey);
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public void initOssClient(String endpoint, String bucketName, String accessKey, String secretKey) {
        log.info("[Minio] init OSS by config: endpoint={}, bucketName={}, accessKey={}, secretKey={}", new Object[]{endpoint, bucketName, accessKey, secretKey});
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            throw new IllegalArgumentException("'oms.storage.dfs.minio.bucketName' can't be empty, please creat a bucket in minio oss console then config it to powerjob");
        }
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(accessKey, secretKey);
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, "us-east-1"))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        this.bucket = bucketName;
        this.createBucket(bucketName);
        log.info("[Minio] initialize OSS successfully!");
    }

    public void createBucket(String bucketName) {
        if (this.bucketExists(bucketName)) {
            return;
        }
        Bucket createBucketResult = this.amazonS3.createBucket(bucketName);
        log.info("[Minio] createBucket successfully, bucketName: {}, createResult: {}", (Object)bucketName, (Object)createBucketResult);
        String policy = "{\n    \"Version\": \"2012-10-17\",\n    \"Statement\": [\n        {\n            \"Action\": [\n                \"s3:GetObject\"\n            ],\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Resource\": [\n                \"arn:aws:s3:::" + bucketName + "/*\"\n            ]\n        }\n    ]\n}";
        try {
            this.amazonS3.setBucketPolicy(bucketName, policy);
        }
        catch (Exception e) {
            log.warn("[Minio] setBucketPolicy failed, maybe you need to setBucketPolicy by yourself!", (Throwable)e);
        }
    }

    public boolean bucketExists(String bucketName) {
        return this.amazonS3.doesBucketExistV2(bucketName);
    }

    public static class MinioOssCondition
    extends PropertyAndOneBeanCondition {
        protected List<String> anyConfigKey() {
            return Lists.newArrayList((Object[])new String[]{"oms.storage.dfs.minio.endpoint"});
        }

        protected Class<?> beanType() {
            return DFsService.class;
        }
    }
}

