/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.config;

import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import tech.powerjob.server.persistence.config.MultiDatasourceProperties;
import tech.powerjob.server.persistence.config.PowerJobPhysicalNamingStrategy;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"tech.powerjob.server.persistence.remote"}, entityManagerFactoryRef="remoteEntityManagerFactory", transactionManagerRef="remoteTransactionManager")
public class RemoteJpaConfig {
    public static final String CORE_PACKAGES = "tech.powerjob.server.persistence.remote";

    private static Map<String, Object> genDatasourceProperties() {
        JpaProperties jpaProperties = new JpaProperties();
        jpaProperties.setOpenInView(Boolean.valueOf(false));
        jpaProperties.setShowSql(false);
        HibernateProperties hibernateProperties = new HibernateProperties();
        hibernateProperties.setDdlAuto("update");
        hibernateProperties.getNaming().setPhysicalStrategy(PowerJobPhysicalNamingStrategy.class.getName());
        HibernateSettings hibernateSettings = new HibernateSettings();
        return hibernateProperties.determineHibernateProperties(jpaProperties.getProperties(), hibernateSettings);
    }

    @Primary
    @Bean(name={"remoteEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean initRemoteEntityManagerFactory(@Qualifier(value="omsRemoteDatasource") DataSource omsRemoteDatasource, @Qualifier(value="multiDatasourceProperties") MultiDatasourceProperties properties, EntityManagerFactoryBuilder builder) {
        Map<String, Object> datasourceProperties = RemoteJpaConfig.genDatasourceProperties();
        datasourceProperties.putAll(properties.getRemote().getHibernate().getProperties());
        return builder.dataSource(omsRemoteDatasource).properties(datasourceProperties).packages(new String[]{CORE_PACKAGES}).persistenceUnit("remotePersistenceUnit").build();
    }

    @Primary
    @Bean(name={"remoteTransactionManager"})
    public PlatformTransactionManager initRemoteTransactionManager(@Qualifier(value="remoteEntityManagerFactory") LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean) {
        return new JpaTransactionManager(Objects.requireNonNull(localContainerEntityManagerFactoryBean.getObject()));
    }
}

