/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import tech.powerjob.common.PowerQuery;
import tech.powerjob.common.exception.PowerJobException;

public class QueryConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryConvertUtils.class);

    public static <T> Specification<T> toSpecification(PowerQuery powerQuery) {
        return (Specification & Serializable)(root, query, cb) -> {
            LinkedList predicates = Lists.newLinkedList();
            Field[] fields = powerQuery.getClass().getDeclaredFields();
            try {
                for (Field field : fields) {
                    String colName;
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object fieldValue = field.get(powerQuery);
                    if (fieldValue == null) continue;
                    if (fieldName.endsWith(PowerQuery.EQUAL)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.EQUAL);
                        predicates.add(cb.equal((Expression)root.get(colName), fieldValue));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.NOT_EQUAL)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.NOT_EQUAL);
                        predicates.add(cb.notEqual((Expression)root.get(colName), fieldValue));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.LIKE)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.LIKE);
                        predicates.add(cb.like((Expression)root.get(colName), QueryConvertUtils.convertLikeParams(fieldValue)));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.NOT_LIKE)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.NOT_LIKE);
                        predicates.add(cb.notLike((Expression)root.get(colName), QueryConvertUtils.convertLikeParams(fieldValue)));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.LESS_THAN)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.LESS_THAN);
                        predicates.add(cb.lessThan((Expression)root.get(colName), (Comparable)fieldValue));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.GREATER_THAN)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.GREATER_THAN);
                        predicates.add(cb.greaterThan((Expression)root.get(colName), (Comparable)fieldValue));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.LESS_THAN_EQUAL)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.LESS_THAN_EQUAL);
                        predicates.add(cb.lessThanOrEqualTo((Expression)root.get(colName), (Comparable)fieldValue));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.GREATER_THAN_EQUAL)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.GREATER_THAN_EQUAL);
                        predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(colName), (Comparable)fieldValue));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.IN)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.IN);
                        predicates.add(root.get(colName).in(QueryConvertUtils.convertInParams(fieldValue)));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.NOT_IN)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.NOT_IN);
                        predicates.add(cb.not((Expression)root.get(colName).in(QueryConvertUtils.convertInParams(fieldValue))));
                        continue;
                    }
                    if (fieldName.endsWith(PowerQuery.IS_NULL)) {
                        colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.IS_NULL);
                        predicates.add(cb.isNull((Expression)root.get(colName)));
                        continue;
                    }
                    if (!fieldName.endsWith(PowerQuery.IS_NOT_NULL)) continue;
                    colName = StringUtils.substringBeforeLast((String)fieldName, (String)PowerQuery.IS_NOT_NULL);
                    predicates.add(cb.isNotNull((Expression)root.get(colName)));
                }
            }
            catch (Exception e) {
                log.warn("[QueryConvertUtils] convert failed for query: {}", (Object)query, (Object)e);
                throw new PowerJobException("convert query object failed, maybe you should redesign your query object!");
            }
            if (powerQuery.getAppIdEq() != null) {
                predicates.add(cb.equal((Expression)root.get("appId"), (Object)powerQuery.getAppIdEq()));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
    }

    private static String convertLikeParams(Object o) {
        String s = (String)o;
        if (!s.startsWith("%")) {
            s = "%" + s;
        }
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        return s;
    }

    private static Object[] convertInParams(Object o) {
        return JSONArray.parseArray((String)JSONArray.toJSONString((Object)o)).toArray();
    }
}

