/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.extension.defaultimpl.workerfilter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.model.SystemMetrics;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.extension.WorkerFilter;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;

@Component
public class SystemMetricsWorkerFilter
implements WorkerFilter {
    private static final Logger log = LoggerFactory.getLogger(SystemMetricsWorkerFilter.class);

    @Override
    public boolean filter(WorkerInfo workerInfo, JobInfoDO jobInfo) {
        boolean filter;
        SystemMetrics metrics = workerInfo.getSystemMetrics();
        boolean bl = filter = !metrics.available(jobInfo.getMinCpuCores(), jobInfo.getMinMemorySpace(), jobInfo.getMinDiskSpace());
        if (filter) {
            log.info("[Job-{}] filter worker[{}] because the {} do not meet the requirements", new Object[]{jobInfo.getId(), workerInfo.getAddress(), workerInfo.getSystemMetrics()});
        }
        return filter;
    }
}

