/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.extension.defaultimpl.alarm.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.utils.HttpUtils;
import tech.powerjob.server.extension.Alarmable;
import tech.powerjob.server.extension.defaultimpl.alarm.module.Alarm;
import tech.powerjob.server.persistence.remote.model.UserInfoDO;

@Service
public class WebHookAlarmService
implements Alarmable {
    private static final Logger log = LoggerFactory.getLogger(WebHookAlarmService.class);
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";

    @Override
    public void onFailed(Alarm alarm, List<UserInfoDO> targetUserList) {
        if (CollectionUtils.isEmpty(targetUserList)) {
            return;
        }
        targetUserList.forEach(user -> {
            String webHook = user.getWebHook();
            if (StringUtils.isEmpty((CharSequence)webHook)) {
                return;
            }
            if (!webHook.startsWith(HTTP_PROTOCOL_PREFIX) && !webHook.startsWith(HTTPS_PROTOCOL_PREFIX)) {
                webHook = HTTP_PROTOCOL_PREFIX + webHook;
            }
            MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
            RequestBody requestBody = RequestBody.create((MediaType)jsonType, (String)JSONObject.toJSONString((Object)alarm));
            try {
                String response = HttpUtils.post((String)webHook, (RequestBody)requestBody);
                log.info("[WebHookAlarmService] invoke webhook[url={}] successfully, response is {}", (Object)webHook, (Object)response);
            }
            catch (Exception e) {
                log.warn("[WebHookAlarmService] invoke webhook[url={}] failed!", (Object)webHook, (Object)e);
            }
        });
    }
}

