/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.extension.defaultimpl.alarm.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.extension.Alarmable;
import tech.powerjob.server.extension.defaultimpl.alarm.impl.DingTalkUtils;
import tech.powerjob.server.extension.defaultimpl.alarm.module.Alarm;
import tech.powerjob.server.persistence.remote.model.UserInfoDO;

@Service
public class DingTalkAlarmService
implements Alarmable {
    private static final Logger log = LoggerFactory.getLogger(DingTalkAlarmService.class);
    private final Environment environment;
    private Long agentId;
    private DingTalkUtils dingTalkUtils;
    private Cache<String, String> mobile2UserIdCache;
    private static final int CACHE_SIZE = 8192;
    private static final String EMPTY_TAG = "EMPTY";

    @Override
    public void onFailed(Alarm alarm, List<UserInfoDO> targetUserList) {
        if (this.dingTalkUtils == null) {
            return;
        }
        HashSet userIds = Sets.newHashSet();
        targetUserList.forEach(user -> {
            String phone = user.getPhone();
            if (StringUtils.isEmpty((CharSequence)phone)) {
                return;
            }
            try {
                String userId = (String)this.mobile2UserIdCache.get((Object)phone, () -> {
                    try {
                        return this.dingTalkUtils.fetchUserIdByMobile(phone);
                    }
                    catch (PowerJobException ignore) {
                        return EMPTY_TAG;
                    }
                    catch (Exception ignore) {
                        return null;
                    }
                });
                if (!EMPTY_TAG.equals(userId)) {
                    userIds.add(userId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        userIds.remove(null);
        if (!userIds.isEmpty()) {
            String userListStr = SJ.COMMA_JOINER.skipNulls().join((Iterable)userIds);
            LinkedList markdownEntities = Lists.newLinkedList();
            markdownEntities.add(new DingTalkUtils.MarkdownEntity("server", NetUtils.getLocalHost()));
            String content = alarm.fetchContent().replaceAll("\r\n", ",");
            markdownEntities.add(new DingTalkUtils.MarkdownEntity("content", content));
            try {
                this.dingTalkUtils.sendMarkdownAsync(alarm.fetchTitle(), markdownEntities, userListStr, this.agentId);
            }
            catch (Exception e) {
                log.error("[DingTalkAlarmService] send ding message failed, reason is {}", (Object)e.getMessage());
            }
        }
    }

    @PostConstruct
    public void init() {
        String agentId = this.environment.getProperty("oms.alarm.ding.agent-id");
        String appKey = this.environment.getProperty("oms.alarm.ding.app-key");
        String appSecret = this.environment.getProperty("oms.alarm.ding.app-secret");
        log.info("[DingTalkAlarmService] init with appKey:{},appSecret:{},agentId:{}", new Object[]{appKey, appSecret, agentId});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{agentId, appKey, appSecret})) {
            log.warn("[DingTalkAlarmService] cannot get agentId, appKey, appSecret at the same time, this service is unavailable");
            return;
        }
        if (!StringUtils.isNumeric((CharSequence)agentId)) {
            log.warn("[DingTalkAlarmService] DingTalkAlarmService is unavailable due to invalid agentId: {}", (Object)agentId);
            return;
        }
        this.agentId = Long.valueOf(agentId);
        this.dingTalkUtils = new DingTalkUtils(appKey, appSecret);
        this.mobile2UserIdCache = CacheBuilder.newBuilder().maximumSize(8192L).softValues().build();
        log.info("[DingTalkAlarmService] init DingTalkAlarmService successfully!");
    }

    public DingTalkAlarmService(Environment environment) {
        this.environment = environment;
    }
}

