/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.extension.defaultimpl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.server.extension.LockService;
import tech.powerjob.server.persistence.remote.model.OmsLockDO;
import tech.powerjob.server.persistence.remote.repository.OmsLockRepository;

@Service
public class DatabaseLockService
implements LockService {
    private static final Logger log = LoggerFactory.getLogger(DatabaseLockService.class);
    private final String ownerIp = NetUtils.getLocalHost();
    private final OmsLockRepository omsLockRepository;

    @Autowired
    public DatabaseLockService(OmsLockRepository omsLockRepository) {
        this.omsLockRepository = omsLockRepository;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            int num = omsLockRepository.deleteByOwnerIP(this.ownerIp);
            log.info("[DatabaseLockService] execute shutdown hook, release all lock(owner={},num={})", (Object)this.ownerIp, (Object)num);
        }));
    }

    @Override
    public boolean tryLock(String name, long maxLockTime) {
        OmsLockDO newLock = new OmsLockDO(name, this.ownerIp, Long.valueOf(maxLockTime));
        try {
            this.omsLockRepository.saveAndFlush((Object)newLock);
            return true;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
        }
        catch (Exception e) {
            log.warn("[DatabaseLockService] write lock to database failed, lockName = {}.", (Object)name, (Object)e);
        }
        OmsLockDO omsLockDO = this.omsLockRepository.findByLockName(name);
        long lockedMillions = System.currentTimeMillis() - omsLockDO.getGmtCreate().getTime();
        if (lockedMillions > omsLockDO.getMaxLockTime()) {
            log.warn("[DatabaseLockService] The lock[{}] already timeout, will be unlocked now.", (Object)omsLockDO);
            this.unlock(name);
            return this.tryLock(name, maxLockTime);
        }
        return false;
    }

    @Override
    public void unlock(String name) {
        try {
            CommonUtils.executeWithRetry0(() -> this.omsLockRepository.deleteByLockName(name));
        }
        catch (Exception e) {
            log.error("[DatabaseLockService] unlock {} failed.", (Object)name, (Object)e);
        }
    }
}

