/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.login.impl;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.ErrorCodes;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.DigestUtils;
import tech.powerjob.server.auth.common.PowerJobAuthException;
import tech.powerjob.server.auth.login.LoginTypeInfo;
import tech.powerjob.server.auth.login.ThirdPartyLoginRequest;
import tech.powerjob.server.auth.login.ThirdPartyLoginService;
import tech.powerjob.server.auth.login.ThirdPartyUser;
import tech.powerjob.server.auth.login.TokenLoginVerifyInfo;
import tech.powerjob.server.common.Loggers;
import tech.powerjob.server.persistence.remote.model.PwjbUserInfoDO;
import tech.powerjob.server.persistence.remote.repository.PwjbUserInfoRepository;

@Service
public class PwjbAccountLoginService
implements ThirdPartyLoginService {
    @Resource
    private PwjbUserInfoRepository pwjbUserInfoRepository;

    @Override
    public LoginTypeInfo loginType() {
        return new LoginTypeInfo().setType("PWJB").setName("PowerJob Account");
    }

    @Override
    public String generateLoginUrl(HttpServletRequest httpServletRequest) {
        return "FE-REDIRECT:".concat("powerjobLogin");
    }

    @Override
    public ThirdPartyUser login(ThirdPartyLoginRequest loginRequest) {
        String loginInfo = loginRequest.getOriginParams();
        if (StringUtils.isEmpty((CharSequence)loginInfo)) {
            throw new IllegalArgumentException("can't find login Info");
        }
        Map loginInfoMap = JsonUtils.parseMap((String)loginInfo);
        String username = MapUtils.getString((Map)loginInfoMap, (Object)"username");
        String password = MapUtils.getString((Map)loginInfoMap, (Object)"password");
        String encryption = MapUtils.getString((Map)loginInfoMap, (Object)"encryption");
        Loggers.WEB.debug("[PowerJobLoginService] username: {}, password: {}, encryption: {}", new Object[]{username, password, encryption});
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{username, password})) {
            Loggers.WEB.debug("[PowerJobLoginService] username or password is empty, login failed!");
            throw new PowerJobAuthException(ErrorCodes.INVALID_REQUEST);
        }
        Optional userInfoOpt = this.pwjbUserInfoRepository.findByUsername(username);
        if (!userInfoOpt.isPresent()) {
            Loggers.WEB.debug("[PowerJobLoginService] can't find user by username: {}", (Object)username);
            throw new PowerJobAuthException(ErrorCodes.USER_NOT_EXIST);
        }
        PwjbUserInfoDO dbUser = (PwjbUserInfoDO)userInfoOpt.get();
        if (DigestUtils.rePassword((String)password, (String)username).equals(dbUser.getPassword())) {
            ThirdPartyUser material;
            ThirdPartyUser bizUser = new ThirdPartyUser();
            bizUser.setUsername(username);
            String extra = dbUser.getExtra();
            if (StringUtils.isNotEmpty((CharSequence)extra) && (material = (ThirdPartyUser)JsonUtils.parseObjectIgnoreException((String)extra, ThirdPartyUser.class)) != null) {
                bizUser.setEmail(material.getEmail());
                bizUser.setNick(material.getNick());
                bizUser.setPhone(material.getPhone());
                bizUser.setWebHook(material.getWebHook());
            }
            TokenLoginVerifyInfo tokenLoginVerifyInfo = new TokenLoginVerifyInfo();
            tokenLoginVerifyInfo.setEncryptedToken(dbUser.getPassword());
            bizUser.setTokenLoginVerifyInfo(tokenLoginVerifyInfo);
            return bizUser;
        }
        Loggers.WEB.debug("[PowerJobLoginService] user[{}]'s password is incorrect, login failed!", (Object)username);
        throw new PowerJobException("password is incorrect");
    }

    @Override
    public boolean tokenLoginVerify(String username, TokenLoginVerifyInfo tokenLoginVerifyInfo) {
        if (tokenLoginVerifyInfo == null) {
            return false;
        }
        Optional userInfoOpt = this.pwjbUserInfoRepository.findByUsername(username);
        if (userInfoOpt.isPresent()) {
            String dbPassword = ((PwjbUserInfoDO)userInfoOpt.get()).getPassword();
            return StringUtils.equals((CharSequence)dbPassword, (CharSequence)tokenLoginVerifyInfo.getEncryptedToken());
        }
        return false;
    }
}

