/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.jwt.impl;

import com.google.common.collect.Maps;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tech.powerjob.server.auth.jwt.JwtService;
import tech.powerjob.server.auth.jwt.ParseResult;
import tech.powerjob.server.auth.jwt.SecretProvider;

@Service
public class JwtServiceImpl
implements JwtService {
    private static final Logger log = LoggerFactory.getLogger(JwtServiceImpl.class);
    @Resource
    private SecretProvider secretProvider;
    @Value(value="${oms.auth.security.jwt.expire-seconds:604800}")
    private int jwtExpireTime;
    private static final String BASE_SECURITY = "CengMengXiangZhangJianZouTianYaKanYiKanShiJieDeFanHuaNianShaoDeXinZongYouXieQingKuangRuJinWoSiHaiWeiJia";

    @Override
    public String build(Map<String, Object> body, String extraSk) {
        String secret = this.fetchSk(extraSk);
        return JwtServiceImpl.innerBuild(secret, this.jwtExpireTime, body);
    }

    static String innerBuild(String secret, int expireSeconds, Map<String, Object> body) {
        JwtBuilder jwtBuilder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").addClaims(body).setSubject("PowerJob").setExpiration(new Date(System.currentTimeMillis() + 1000L * (long)expireSeconds)).setId(UUID.randomUUID().toString()).signWith(JwtServiceImpl.genSecretKey(secret), SignatureAlgorithm.HS256);
        return jwtBuilder.compact();
    }

    @Override
    public ParseResult parse(String jwt, String extraSk) {
        try {
            Map<String, Object> parseResult = JwtServiceImpl.innerParse(this.fetchSk(extraSk), jwt);
            return new ParseResult().setStatus(ParseResult.Status.SUCCESS).setResult(parseResult);
        }
        catch (ExpiredJwtException expiredJwtException) {
            return new ParseResult().setStatus(ParseResult.Status.EXPIRED).setMsg(expiredJwtException.getMessage());
        }
        catch (Exception e) {
            log.warn("[JwtService] parse jwt[{}] with extraSk[{}] failed", new Object[]{jwt, extraSk, e});
            return new ParseResult().setStatus(ParseResult.Status.FAILED).setMsg(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private String fetchSk(String extraSk) {
        if (StringUtils.isEmpty((CharSequence)extraSk)) {
            return this.secretProvider.fetchSecretKey();
        }
        return this.secretProvider.fetchSecretKey().concat(extraSk);
    }

    static Map<String, Object> innerParse(String secret, String jwtStr) {
        Jws claimsJws = Jwts.parserBuilder().setSigningKey(JwtServiceImpl.genSecretKey(secret)).build().parseClaimsJws(jwtStr);
        HashMap ret = Maps.newHashMap();
        ret.putAll((Map)claimsJws.getBody());
        return ret;
    }

    private static Key genSecretKey(String secret) {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)BASE_SECURITY.concat(secret));
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }
}

