/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth;

import com.google.common.collect.Sets;
import java.util.Set;
import tech.powerjob.server.auth.Permission;

public enum Role {
    OBSERVER(10, Sets.newHashSet((Object[])new Permission[]{Permission.READ})),
    QA(20, Sets.newHashSet((Object[])new Permission[]{Permission.READ, Permission.OPS})),
    DEVELOPER(30, Sets.newHashSet((Object[])new Permission[]{Permission.READ, Permission.WRITE, Permission.OPS})),
    ADMIN(40, Sets.newHashSet((Object[])new Permission[]{Permission.READ, Permission.WRITE, Permission.OPS, Permission.SU}));

    private final int v;
    private final Set<Permission> permissions;

    public static Role of(int vv) {
        for (Role role : Role.values()) {
            if (vv != role.v) continue;
            return role;
        }
        throw new IllegalArgumentException("unknown role: " + vv);
    }

    public int getV() {
        return this.v;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    private Role(int v, Set<Permission> permissions) {
        this.v = v;
        this.permissions = permissions;
    }
}

