/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.login.impl;

import com.aliyun.dingtalkcontact_1_0.Client;
import com.aliyun.dingtalkcontact_1_0.models.GetUserHeaders;
import com.aliyun.dingtalkcontact_1_0.models.GetUserResponseBody;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.server.auth.login.LoginTypeInfo;
import tech.powerjob.server.auth.login.ThirdPartyLoginRequest;
import tech.powerjob.server.auth.login.ThirdPartyLoginService;
import tech.powerjob.server.auth.login.ThirdPartyUser;
import tech.powerjob.server.common.Loggers;

@Service
public class DingTalkLoginService
implements ThirdPartyLoginService {
    @Value(value="${oms.auth.dingtalk.appkey:#{null}}")
    private String dingTalkAppKey;
    @Value(value="${oms.auth.dingtalk.appSecret:#{null}}")
    private String dingTalkAppSecret;
    @Value(value="${oms.auth.dingtalk.callbackUrl:#{null}}")
    private String dingTalkCallbackUrl;

    @Override
    public LoginTypeInfo loginType() {
        return new LoginTypeInfo().setType("DING").setName("DingTalk");
    }

    @Override
    public String generateLoginUrl(HttpServletRequest httpServletRequest) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.dingTalkAppKey, this.dingTalkAppSecret, this.dingTalkCallbackUrl})) {
            throw new IllegalArgumentException("please config 'oms.auth.dingtalk.appkey', 'oms.auth.dingtalk.appSecret' and 'oms.auth.dingtalk.callbackUrl' in properties!");
        }
        String urlString = URLEncoder.encode(this.dingTalkCallbackUrl, StandardCharsets.UTF_8.name());
        String url = "https://login.dingtalk.com/oauth2/auth?redirect_uri=" + urlString + "&response_type=code&client_id=" + this.dingTalkAppKey + "&scope=openid&state=" + "DING" + "&prompt=consent";
        Loggers.WEB.info("[DingTalkBizLoginService] login url: {}", (Object)url);
        return url;
    }

    @Override
    public ThirdPartyUser login(ThirdPartyLoginRequest loginRequest) {
        try {
            com.aliyun.dingtalkoauth2_1_0.Client client = DingTalkLoginService.authClient();
            GetUserTokenRequest getUserTokenRequest = new GetUserTokenRequest().setClientId(this.dingTalkAppKey).setClientSecret(this.dingTalkAppSecret).setCode(loginRequest.getHttpServletRequest().getParameter("authCode")).setGrantType("authorization_code");
            GetUserTokenResponse getUserTokenResponse = client.getUserToken(getUserTokenRequest);
            String accessToken = getUserTokenResponse.getBody().getAccessToken();
            GetUserResponseBody dingUser = this.getUserinfo(accessToken);
            if (dingUser != null) {
                ThirdPartyUser bizUser = new ThirdPartyUser();
                bizUser.setUsername(dingUser.getUnionId());
                bizUser.setNick(dingUser.getNick());
                bizUser.setPhone(dingUser.getMobile());
                bizUser.setEmail(dingUser.getEmail());
                return bizUser;
            }
        }
        catch (Exception e) {
            Loggers.WEB.error("[DingTalkBizLoginService] login by dingTalk failed!", (Throwable)e);
            throw e;
        }
        throw new PowerJobException("login from dingTalk failed!");
    }

    private static com.aliyun.dingtalkoauth2_1_0.Client authClient() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new com.aliyun.dingtalkoauth2_1_0.Client(config);
    }

    private static Client contactClient() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new Client(config);
    }

    private GetUserResponseBody getUserinfo(String accessToken) throws Exception {
        Client client = DingTalkLoginService.contactClient();
        GetUserHeaders getUserHeaders = new GetUserHeaders();
        getUserHeaders.xAcsDingtalkAccessToken = accessToken;
        return client.getUserWithOptions("me", getUserHeaders, new RuntimeOptions()).getBody();
    }
}

