/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.service.login.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.auth.LoginUserHolder;
import tech.powerjob.server.auth.PowerJobUser;
import tech.powerjob.server.auth.common.AuthErrorCode;
import tech.powerjob.server.auth.common.PowerJobAuthException;
import tech.powerjob.server.auth.common.utils.HttpServletUtils;
import tech.powerjob.server.auth.jwt.JwtService;
import tech.powerjob.server.auth.login.LoginTypeInfo;
import tech.powerjob.server.auth.login.ThirdPartyLoginRequest;
import tech.powerjob.server.auth.login.ThirdPartyLoginService;
import tech.powerjob.server.auth.login.ThirdPartyUser;
import tech.powerjob.server.auth.login.TokenLoginVerifyInfo;
import tech.powerjob.server.auth.service.login.LoginRequest;
import tech.powerjob.server.auth.service.login.PowerJobLoginService;
import tech.powerjob.server.common.Loggers;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.persistence.remote.model.UserInfoDO;
import tech.powerjob.server.persistence.remote.repository.UserInfoRepository;

@Service
public class PowerJobLoginServiceImpl
implements PowerJobLoginService {
    private static final Logger log = LoggerFactory.getLogger(PowerJobLoginServiceImpl.class);
    private final JwtService jwtService;
    private final UserInfoRepository userInfoRepository;
    private final Map<String, ThirdPartyLoginService> code2ThirdPartyLoginService;

    @Autowired
    public PowerJobLoginServiceImpl(JwtService jwtService, UserInfoRepository userInfoRepository, List<ThirdPartyLoginService> thirdPartyLoginServices) {
        this.jwtService = jwtService;
        this.userInfoRepository = userInfoRepository;
        this.code2ThirdPartyLoginService = Maps.newHashMap();
        thirdPartyLoginServices.forEach(s -> {
            this.code2ThirdPartyLoginService.put(s.loginType().getType(), (ThirdPartyLoginService)s);
            log.info("[PowerJobLoginService] register ThirdPartyLoginService: {}", (Object)s.loginType());
        });
    }

    @Override
    public List<LoginTypeInfo> fetchSupportLoginTypes() {
        return Lists.newArrayList(this.code2ThirdPartyLoginService.values()).stream().map(ThirdPartyLoginService::loginType).collect(Collectors.toList());
    }

    @Override
    public String fetchThirdPartyLoginUrl(String type, HttpServletRequest httpServletRequest) {
        ThirdPartyLoginService thirdPartyLoginService = this.fetchBizLoginService(type);
        return thirdPartyLoginService.generateLoginUrl(httpServletRequest);
    }

    @Override
    public PowerJobUser doLogin(LoginRequest loginRequest) throws PowerJobAuthException {
        String loginType = loginRequest.getLoginType();
        ThirdPartyLoginService thirdPartyLoginService = this.fetchBizLoginService(loginType);
        ThirdPartyLoginRequest thirdPartyLoginRequest = new ThirdPartyLoginRequest().setOriginParams(loginRequest.getOriginParams()).setHttpServletRequest(loginRequest.getHttpServletRequest());
        ThirdPartyUser bizUser = thirdPartyLoginService.login(thirdPartyLoginRequest);
        String dbUserName = String.format("%s_%s", loginType, bizUser.getUsername());
        Optional powerJobUserOpt = this.userInfoRepository.findByUsername(dbUserName);
        if (!powerJobUserOpt.isPresent()) {
            UserInfoDO newUser = new UserInfoDO();
            newUser.setUsername(dbUserName);
            newUser.setAccountType(loginType);
            newUser.setOriginUsername(bizUser.getUsername());
            newUser.setTokenLoginVerifyInfo(JsonUtils.toJSONString((Object)bizUser.getTokenLoginVerifyInfo()));
            newUser.setEmail(bizUser.getEmail());
            newUser.setPhone(bizUser.getPhone());
            newUser.setNick(bizUser.getNick());
            newUser.setWebHook(bizUser.getWebHook());
            newUser.setExtra(bizUser.getExtra());
            Loggers.WEB.info("[PowerJobLoginService] sync user to PowerJobUserSystem: {}", (Object)dbUserName);
            this.userInfoRepository.saveAndFlush((Object)newUser);
            powerJobUserOpt = this.userInfoRepository.findByUsername(dbUserName);
        } else {
            UserInfoDO dbUserInfoDO = (UserInfoDO)powerJobUserOpt.get();
            this.checkUserStatus(dbUserInfoDO);
            dbUserInfoDO.setTokenLoginVerifyInfo(JsonUtils.toJSONString((Object)bizUser.getTokenLoginVerifyInfo()));
            dbUserInfoDO.setGmtModified(new Date());
            this.userInfoRepository.saveAndFlush((Object)dbUserInfoDO);
        }
        PowerJobUser ret = new PowerJobUser();
        if (powerJobUserOpt.isPresent()) {
            UserInfoDO dbUser = (UserInfoDO)powerJobUserOpt.get();
            BeanUtils.copyProperties((Object)dbUser, (Object)ret);
            ret.setUsername(dbUserName);
        }
        this.fillJwt(ret, Optional.ofNullable(bizUser.getTokenLoginVerifyInfo()).map(TokenLoginVerifyInfo::getEncryptedToken).orElse(null));
        return ret;
    }

    @Override
    public Optional<PowerJobUser> ifLogin(HttpServletRequest httpServletRequest) {
        Optional<JwtBody> jwtBodyOpt = this.parseJwt(httpServletRequest);
        if (!jwtBodyOpt.isPresent()) {
            return Optional.empty();
        }
        JwtBody jwtBody = jwtBodyOpt.get();
        Optional dbUserInfoOpt = this.userInfoRepository.findByUsername(jwtBody.getUsername());
        if (!dbUserInfoOpt.isPresent()) {
            throw new PowerJobAuthException(AuthErrorCode.USER_NOT_EXIST);
        }
        UserInfoDO dbUser = (UserInfoDO)dbUserInfoOpt.get();
        this.checkUserStatus(dbUser);
        PowerJobUser powerJobUser = new PowerJobUser();
        String tokenLoginVerifyInfoStr = dbUser.getTokenLoginVerifyInfo();
        TokenLoginVerifyInfo tokenLoginVerifyInfo = Optional.ofNullable(tokenLoginVerifyInfoStr).map(x -> (TokenLoginVerifyInfo)JsonUtils.parseObjectIgnoreException((String)x, TokenLoginVerifyInfo.class)).orElse(new TokenLoginVerifyInfo());
        if (StringUtils.isNotEmpty((CharSequence)tokenLoginVerifyInfo.getEncryptedToken())) {
            if (!StringUtils.equals((CharSequence)jwtBody.getEncryptedToken(), (CharSequence)tokenLoginVerifyInfo.getEncryptedToken())) {
                throw new PowerJobAuthException(AuthErrorCode.INVALID_TOKEN);
            }
            ThirdPartyLoginService thirdPartyLoginService = this.code2ThirdPartyLoginService.get(dbUser.getAccountType());
            boolean tokenLoginVerifyOk = thirdPartyLoginService.tokenLoginVerify(dbUser.getOriginUsername(), tokenLoginVerifyInfo);
            if (!tokenLoginVerifyOk) {
                throw new PowerJobAuthException(AuthErrorCode.USER_AUTH_FAILED);
            }
        }
        BeanUtils.copyProperties((Object)dbUser, (Object)powerJobUser);
        LoginUserHolder.set(powerJobUser);
        return Optional.of(powerJobUser);
    }

    private void checkUserStatus(UserInfoDO dbUser) {
        int accountStatus = Optional.ofNullable(dbUser.getStatus()).orElse(SwitchableStatus.ENABLE.getV());
        if (accountStatus == SwitchableStatus.DISABLE.getV()) {
            throw new PowerJobAuthException(AuthErrorCode.USER_DISABLED);
        }
    }

    private ThirdPartyLoginService fetchBizLoginService(String loginType) {
        ThirdPartyLoginService loginService = this.code2ThirdPartyLoginService.get(loginType);
        if (loginService == null) {
            throw new PowerJobAuthException(AuthErrorCode.INVALID_REQUEST, "can't find ThirdPartyLoginService by type: " + loginType);
        }
        return loginService;
    }

    private void fillJwt(PowerJobUser powerJobUser, String encryptedToken) {
        JwtBody jwtBody = new JwtBody();
        jwtBody.setUsername(powerJobUser.getUsername());
        if (StringUtils.isNotEmpty((CharSequence)encryptedToken)) {
            jwtBody.setEncryptedToken(encryptedToken);
        }
        Map jwtMap = JsonUtils.parseMap((String)JsonUtils.toJSONString((Object)jwtBody));
        powerJobUser.setJwtToken(this.jwtService.build(jwtMap, null));
    }

    private Optional<JwtBody> parseJwt(HttpServletRequest httpServletRequest) {
        String jwtStr = HttpServletUtils.fetchFromHeader("Power_jwt", httpServletRequest);
        if (StringUtils.isEmpty((CharSequence)jwtStr)) {
            return Optional.empty();
        }
        Map<String, Object> jwtBodyMap = this.jwtService.parse(jwtStr, null);
        if (MapUtils.isEmpty(jwtBodyMap)) {
            return Optional.empty();
        }
        return Optional.ofNullable(JsonUtils.parseObject((String)JsonUtils.toJSONString(jwtBodyMap), JwtBody.class));
    }

    static class JwtBody
    implements Serializable {
        private String username;
        private String encryptedToken;

        public String getUsername() {
            return this.username;
        }

        public String getEncryptedToken() {
            return this.encryptedToken;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setEncryptedToken(String encryptedToken) {
            this.encryptedToken = encryptedToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JwtBody)) {
                return false;
            }
            JwtBody other = (JwtBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$encryptedToken = this.getEncryptedToken();
            String other$encryptedToken = other.getEncryptedToken();
            return !(this$encryptedToken == null ? other$encryptedToken != null : !this$encryptedToken.equals(other$encryptedToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JwtBody;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $encryptedToken = this.getEncryptedToken();
            result = result * 59 + ($encryptedToken == null ? 43 : $encryptedToken.hashCode());
            return result;
        }

        public String toString() {
            return "PowerJobLoginServiceImpl.JwtBody(username=" + this.getUsername() + ", encryptedToken=" + this.getEncryptedToken() + ")";
        }
    }
}

