/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.interceptor;

import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import tech.powerjob.common.exception.ImpossibleException;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.server.auth.LoginUserHolder;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.PowerJobUser;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.common.AuthErrorCode;
import tech.powerjob.server.auth.common.PowerJobAuthException;
import tech.powerjob.server.auth.common.utils.HttpServletUtils;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.auth.interceptor.DynamicPermissionPlugin;
import tech.powerjob.server.auth.interceptor.EmptyPlugin;
import tech.powerjob.server.auth.service.login.PowerJobLoginService;
import tech.powerjob.server.auth.service.permission.PowerJobPermissionService;
import tech.powerjob.server.common.Loggers;

@Component
public class PowerJobAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PowerJobAuthInterceptor.class);
    @Resource
    private PowerJobLoginService powerJobLoginService;
    @Resource
    private PowerJobPermissionService powerJobPermissionService;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        boolean hasPermission;
        String appIdStr;
        String namespaceIdStr;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        ApiPermission apiPermissionAnno = method.getAnnotation(ApiPermission.class);
        if (apiPermissionAnno == null) {
            return true;
        }
        Optional<PowerJobUser> loginUserOpt = this.powerJobLoginService.ifLogin(request);
        if (!loginUserOpt.isPresent()) {
            throw new PowerJobAuthException(AuthErrorCode.USER_NOT_LOGIN);
        }
        PowerJobUser powerJobUser = loginUserOpt.get();
        LoginUserHolder.set(powerJobUser);
        Permission requiredPermission = PowerJobAuthInterceptor.parsePermission(request, handler, apiPermissionAnno);
        RoleScope roleScope = apiPermissionAnno.roleScope();
        Long targetId = null;
        if (RoleScope.NAMESPACE.equals((Object)roleScope) && StringUtils.isNotEmpty((CharSequence)(namespaceIdStr = HttpServletUtils.fetchFromHeader("NamespaceId", request)))) {
            targetId = Long.valueOf(namespaceIdStr);
        }
        if (RoleScope.APP.equals((Object)roleScope) && StringUtils.isNotEmpty((CharSequence)(appIdStr = HttpServletUtils.fetchFromHeader("AppId", request)))) {
            targetId = Long.valueOf(appIdStr);
        }
        if (hasPermission = this.powerJobPermissionService.hasPermission(powerJobUser.getId(), roleScope, targetId, requiredPermission)) {
            return true;
        }
        String resourceName = PowerJobAuthInterceptor.parseResourceName(apiPermissionAnno, handlerMethod);
        Loggers.WEB.info("[PowerJobAuthInterceptor] user[{}] has no permission to access: {}", (Object)powerJobUser.getUsername(), (Object)resourceName);
        throw new PowerJobException("Permission denied!");
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        LoginUserHolder.clean();
    }

    private static String parseResourceName(ApiPermission apiPermission, HandlerMethod handlerMethod) {
        String name = apiPermission.name();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return name;
        }
        try {
            String clzName = handlerMethod.getBean().getClass().getSimpleName();
            String methodName = handlerMethod.getMethod().getName();
            return String.format("%s_%s", clzName, methodName);
        }
        catch (Exception exception) {
            return "UNKNOWN";
        }
    }

    private static Permission parsePermission(HttpServletRequest request, Object handler, ApiPermission apiPermission) {
        Class<? extends DynamicPermissionPlugin> dynamicPermissionPlugin = apiPermission.dynamicPermissionPlugin();
        if (EmptyPlugin.class.equals(dynamicPermissionPlugin)) {
            return apiPermission.requiredPermission();
        }
        try {
            DynamicPermissionPlugin dynamicPermission = dynamicPermissionPlugin.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return dynamicPermission.calculate(request, handler);
        }
        catch (Throwable t) {
            log.error("[PowerJobAuthService] process dynamicPermissionPlugin failed!", t);
            ExceptionUtils.rethrow((Throwable)t);
            throw new ImpossibleException();
        }
    }
}

