/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.service.permission;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.Role;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.service.permission.PowerJobPermissionService;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.model.UserRoleDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.persistence.remote.repository.UserRoleRepository;

@Service
public class PowerJobPermissionServiceImpl
implements PowerJobPermissionService {
    private static final Logger log = LoggerFactory.getLogger(PowerJobPermissionServiceImpl.class);
    @Resource
    private AppInfoRepository appInfoRepository;
    @Resource
    private UserRoleRepository userRoleRepository;

    @Override
    public boolean hasPermission(Long userId, RoleScope roleScope, Long target, Permission requiredPermission) {
        List userRoleList = Optional.ofNullable(this.userRoleRepository.findAllByUserId(userId)).orElse(Collections.emptyList());
        ArrayListMultimap appId2Role = ArrayListMultimap.create();
        ArrayListMultimap namespaceId2Role = ArrayListMultimap.create();
        ArrayList globalRoles = Lists.newArrayList();
        for (UserRoleDO userRole : userRoleList) {
            Role role = Role.of(userRole.getRole());
            if (RoleScope.GLOBAL.getV() == userRole.getScope().intValue()) {
                if (Role.ADMIN.equals((Object)role)) {
                    return true;
                }
                globalRoles.add(role);
            }
            if (RoleScope.NAMESPACE.getV() == userRole.getScope().intValue()) {
                namespaceId2Role.put((Object)userRole.getTarget(), (Object)role);
            }
            if (RoleScope.APP.getV() != userRole.getScope().intValue()) continue;
            appId2Role.put((Object)userRole.getTarget(), (Object)role);
        }
        if (requiredPermission == Permission.NONE) {
            return true;
        }
        for (Role role : globalRoles) {
            if (!role.getPermissions().contains((Object)requiredPermission)) continue;
            return true;
        }
        if (RoleScope.APP.equals((Object)roleScope)) {
            return this.checkAppPermission(target, requiredPermission, (Multimap<Long, Role>)appId2Role, (Multimap<Long, Role>)namespaceId2Role);
        }
        if (RoleScope.NAMESPACE.equals((Object)roleScope)) {
            return this.checkNamespacePermission(target, requiredPermission, (Multimap<Long, Role>)namespaceId2Role);
        }
        return false;
    }

    @Override
    public void grantRole(RoleScope roleScope, Long target, Long userId, Role role, String extra) {
        UserRoleDO userRoleDO = new UserRoleDO();
        userRoleDO.setGmtCreate(new Date());
        userRoleDO.setGmtModified(new Date());
        userRoleDO.setExtra(extra);
        userRoleDO.setScope(Integer.valueOf(roleScope.getV()));
        userRoleDO.setTarget(target);
        userRoleDO.setUserId(userId);
        userRoleDO.setRole(Integer.valueOf(role.getV()));
        this.userRoleRepository.saveAndFlush((Object)userRoleDO);
        log.info("[PowerJobPermissionService] [grantPermission] saveAndFlush userRole successfully: {}", (Object)userRoleDO);
    }

    @Override
    public void retrieveRole(RoleScope roleScope, Long target, Long userId, Role role) {
        List originUserRole = this.userRoleRepository.findAllByScopeAndTargetAndRoleAndUserId(Integer.valueOf(roleScope.getV()), target, Integer.valueOf(role.getV()), userId);
        log.info("[PowerJobPermissionService] [retrievePermission] origin rule: {}", (Object)originUserRole);
        Optional.ofNullable(originUserRole).orElse(Collections.emptyList()).forEach(r -> {
            this.userRoleRepository.deleteById((Object)r.getId());
            log.info("[PowerJobPermissionService] [retrievePermission] delete UserRole: {}", r);
        });
    }

    @Override
    public Map<Role, List<Long>> fetchUserWithPermissions(RoleScope roleScope, Long target) {
        List permissionUserList = this.userRoleRepository.findAllByScopeAndTarget(Integer.valueOf(roleScope.getV()), target);
        HashMap ret = Maps.newHashMap();
        Optional.ofNullable(permissionUserList).orElse(Collections.emptyList()).forEach(userRoleDO -> {
            Role role = Role.of(userRoleDO.getRole());
            List userIds = ret.computeIfAbsent(role, ignore -> Lists.newArrayList());
            userIds.add(userRoleDO.getUserId());
        });
        return ret;
    }

    @Override
    public Map<Role, List<Long>> fetchUserHadPermissionTargets(RoleScope roleScope, Long userId) {
        HashMap ret = Maps.newHashMap();
        List userRoleDOList = this.userRoleRepository.findAllByUserIdAndScope(userId, Integer.valueOf(roleScope.getV()));
        Optional.ofNullable(userRoleDOList).orElse(Collections.emptyList()).forEach(r -> {
            Role role = Role.of(r.getRole());
            List targetIds = ret.computeIfAbsent(role, ignore -> Lists.newArrayList());
            targetIds.add(r.getTarget());
        });
        return ret;
    }

    private boolean checkAppPermission(Long targetId, Permission requiredPermission, Multimap<Long, Role> appId2Role, Multimap<Long, Role> namespaceId2Role) {
        Collection appRoles = appId2Role.get((Object)targetId);
        for (Role role : appRoles) {
            if (!role.getPermissions().contains((Object)requiredPermission)) continue;
            return true;
        }
        Optional appInfoOpt = this.appInfoRepository.findById((Object)targetId);
        if (!appInfoOpt.isPresent()) {
            throw new IllegalArgumentException("can't find appInfo by appId in permission check: " + targetId);
        }
        Long namespaceId = Optional.ofNullable(((AppInfoDO)appInfoOpt.get()).getNamespaceId()).orElse(-1L);
        Collection namespaceRoles = namespaceId2Role.get((Object)namespaceId);
        for (Role role : namespaceRoles) {
            if (!role.getPermissions().contains((Object)requiredPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNamespacePermission(Long targetId, Permission requiredPermission, Multimap<Long, Role> namespaceId2Role) {
        Collection namespaceRoles = namespaceId2Role.get((Object)targetId);
        for (Role role : namespaceRoles) {
            if (!role.getPermissions().contains((Object)requiredPermission)) continue;
            return true;
        }
        return false;
    }
}

