/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.jwt.impl;

import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import tech.powerjob.server.auth.jwt.SecretProvider;
import tech.powerjob.server.common.utils.DigestUtils;

@Component
public class DefaultSecretProvider
implements SecretProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretProvider.class);
    @Resource
    private Environment environment;
    private static final String PROPERTY_KEY = "spring.datasource.core.jdbc-url";

    @Override
    public String fetchSecretKey() {
        try {
            String propertyValue = this.environment.getProperty(PROPERTY_KEY);
            if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
                String md5 = DigestUtils.md5((String)propertyValue);
                log.debug("[DefaultSecretProvider] propertyValue: {} ==> md5: {}", (Object)propertyValue, (Object)md5);
                if (StringUtils.isNotEmpty((CharSequence)md5)) {
                    return md5;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "ZQQZJ";
    }
}

