/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import shade.powerjob.com.alibaba.fastjson.JSONObject;
import shade.powerjob.org.apache.commons.lang3.StringUtils;
import tech.powerjob.official.processors.impl.sql.AbstractSqlProcessor;
import tech.powerjob.official.processors.util.CommonUtils;
import tech.powerjob.worker.core.processor.TaskContext;

public class DynamicDatasourceSqlProcessor
extends AbstractSqlProcessor {
    @Override
    protected void validateParams(AbstractSqlProcessor.SqlParams sqlParams) {
        if (StringUtils.isEmpty(sqlParams.getJdbcUrl())) {
            throw new IllegalArgumentException("jdbcUrl can't be empty in DynamicDatasourceSqlProcessor!");
        }
    }

    @Override
    Connection getConnection(AbstractSqlProcessor.SqlParams sqlParams, TaskContext taskContext) throws SQLException {
        JSONObject params = JSONObject.parseObject(CommonUtils.parseParams(taskContext));
        Properties properties = new Properties();
        params.forEach((k, v) -> properties.setProperty((String)k, String.valueOf(v)));
        return DriverManager.getConnection(sqlParams.getJdbcUrl(), properties);
    }

    @Override
    protected String getSecurityDKey() {
        return "powerjob.official-processor.dynamic-datasource.enable";
    }
}

