/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import shade.powerjob.com.alibaba.fastjson.JSON;
import shade.powerjob.com.google.common.base.Joiner;
import shade.powerjob.com.google.common.collect.Lists;
import shade.powerjob.com.google.common.collect.Maps;
import tech.powerjob.official.processors.CommonBasicProcessor;
import tech.powerjob.official.processors.util.CommonUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.log.OmsLogger;

public abstract class AbstractSqlProcessor
extends CommonBasicProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSqlProcessor.class);
    protected static final int DEFAULT_TIMEOUT = 60;
    protected final Map<String, Predicate<String>> sqlValidatorMap = Maps.newConcurrentMap();
    protected SqlParser sqlParser;
    private static final Joiner JOINER = Joiner.on("|").useForNull("-");

    @Override
    public ProcessResult process0(TaskContext taskContext) {
        OmsLogger omsLogger = taskContext.getOmsLogger();
        SqlParams sqlParams = this.extractParams(taskContext);
        omsLogger.info("origin sql params: {}", new Object[]{JSON.toJSON(sqlParams)});
        this.validateParams(sqlParams);
        StopWatch stopWatch = new StopWatch(this.getClass().getSimpleName());
        stopWatch.start("Parse SQL");
        if (this.sqlParser != null) {
            omsLogger.info("before parse sql: {}", new Object[]{sqlParams.getSql()});
            String newSQL = this.sqlParser.parse(sqlParams.getSql(), taskContext);
            sqlParams.setSql(newSQL);
            omsLogger.info("after parse sql: {}", new Object[]{newSQL});
        }
        stopWatch.stop();
        stopWatch.start("Validate SQL");
        this.validateSql(sqlParams.getSql(), omsLogger);
        stopWatch.stop();
        stopWatch.start("Execute SQL");
        omsLogger.info("final sql params: {}", new Object[]{JSON.toJSON(sqlParams)});
        this.executeSql(sqlParams, taskContext);
        stopWatch.stop();
        omsLogger.info(stopWatch.prettyPrint(), new Object[0]);
        String message = String.format("execute successfully, used time: %s millisecond", stopWatch.getTotalTimeMillis());
        return new ProcessResult(true, message);
    }

    abstract Connection getConnection(SqlParams var1, TaskContext var2) throws SQLException;

    private void executeSql(SqlParams sqlParams, TaskContext ctx) {
        OmsLogger omsLogger = ctx.getOmsLogger();
        try (Connection connection = this.getConnection(sqlParams, ctx);){
            boolean originAutoCommitFlag = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try (Statement statement = connection.createStatement();){
                statement.setQueryTimeout(sqlParams.getTimeout() == null ? 60 : sqlParams.getTimeout());
                statement.execute(sqlParams.getSql());
                connection.commit();
                if (sqlParams.showResult) {
                    this.outputSqlResult(statement, omsLogger);
                }
            }
            catch (Throwable e) {
                omsLogger.error("execute sql failed, try to rollback", new Object[]{e});
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(originAutoCommitFlag);
            }
        }
    }

    private void outputSqlResult(Statement statement, OmsLogger omsLogger) throws SQLException {
        omsLogger.info("====== SQL EXECUTE RESULT ======", new Object[0]);
        for (int index = 0; index < Integer.MAX_VALUE; ++index) {
            ResultSet resultSet = statement.getResultSet();
            if (resultSet != null) {
                try (ResultSet rs = resultSet;){
                    int columnCount = rs.getMetaData().getColumnCount();
                    LinkedList<String> columnNames = Lists.newLinkedList();
                    for (int i = 1; i <= columnCount; ++i) {
                        columnNames.add(rs.getMetaData().getColumnName(i));
                    }
                    omsLogger.info("[Result-{}] [Columns] {}" + System.lineSeparator(), new Object[]{index, JOINER.join(columnNames)});
                    int rowIndex = 0;
                    LinkedList<Object> row = Lists.newLinkedList();
                    while (rs.next()) {
                        for (int i = 1; i <= columnCount; ++i) {
                            row.add(rs.getObject(i));
                        }
                        omsLogger.info("[Result-{}] [Row-{}] {}" + System.lineSeparator(), new Object[]{index, rowIndex++, JOINER.join(row)});
                    }
                }
            } else {
                int updateCount = statement.getUpdateCount();
                if (updateCount != -1) {
                    omsLogger.info("[Result-{}] update count: {}", new Object[]{index, updateCount});
                }
            }
            if (!statement.getMoreResults() && statement.getUpdateCount() == -1) break;
        }
        omsLogger.info("====== SQL EXECUTE RESULT ======", new Object[0]);
    }

    protected SqlParams extractParams(TaskContext taskContext) {
        return JSON.parseObject(CommonUtils.parseParams(taskContext), SqlParams.class);
    }

    protected void validateParams(SqlParams sqlParams) {
    }

    public void setSqlParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
    }

    public void registerSqlValidator(String validatorName, Predicate<String> sqlValidator) {
        this.sqlValidatorMap.put(validatorName, sqlValidator);
        log.info("register sql validator({})' successfully.", (Object)validatorName);
    }

    private void validateSql(String sql, OmsLogger omsLogger) {
        if (this.sqlValidatorMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Predicate<String>> entry : this.sqlValidatorMap.entrySet()) {
            Predicate<String> validator = entry.getValue();
            if (validator.test(sql)) continue;
            omsLogger.error("validate sql by validator[{}] failed, skip to process!", new Object[]{entry.getKey()});
            throw new IllegalArgumentException("illegal sql, can't pass the validation of " + entry.getKey());
        }
    }

    @FunctionalInterface
    public static interface SqlParser {
        public String parse(String var1, TaskContext var2);
    }

    public static class SqlParams {
        private String dataSourceName;
        private String sql;
        private Integer timeout;
        private String jdbcUrl;
        private boolean showResult;

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public String getSql() {
            return this.sql;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public boolean isShowResult() {
            return this.showResult;
        }

        public void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        public void setShowResult(boolean showResult) {
            this.showResult = showResult;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SqlParams)) {
                return false;
            }
            SqlParams other = (SqlParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dataSourceName = this.getDataSourceName();
            String other$dataSourceName = other.getDataSourceName();
            if (this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            String this$jdbcUrl = this.getJdbcUrl();
            String other$jdbcUrl = other.getJdbcUrl();
            if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
                return false;
            }
            return this.isShowResult() == other.isShowResult();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SqlParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dataSourceName = this.getDataSourceName();
            result = result * 59 + ($dataSourceName == null ? 43 : $dataSourceName.hashCode());
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            String $jdbcUrl = this.getJdbcUrl();
            result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
            result = result * 59 + (this.isShowResult() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AbstractSqlProcessor.SqlParams(dataSourceName=" + this.getDataSourceName() + ", sql=" + this.getSql() + ", timeout=" + this.getTimeout() + ", jdbcUrl=" + this.getJdbcUrl() + ", showResult=" + this.isShowResult() + ")";
        }
    }
}

