/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl.script;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.powerjob.com.google.common.collect.Sets;
import shade.powerjob.org.apache.commons.io.FileUtils;
import shade.powerjob.org.apache.commons.lang3.StringUtils;
import shade.powerjob.org.apache.commons.lang3.SystemUtils;
import tech.powerjob.official.processors.CommonBasicProcessor;
import tech.powerjob.official.processors.util.CommonUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.log.OmsLogger;

public abstract class AbstractScriptProcessor
extends CommonBasicProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractScriptProcessor.class);
    private static final ForkJoinPool POOL = new ForkJoinPool(4 * Runtime.getRuntime().availableProcessors());
    private static final Set<String> DOWNLOAD_PROTOCOL = Sets.newHashSet("http", "https", "ftp");
    protected static final String SH_SHELL = "/bin/sh";
    protected static final String CMD_SHELL = "cmd.exe";
    private static final String WORKER_DIR = System.getProperty("user.home") + "/powerjob/worker/official_script_processor/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProcessResult process0(TaskContext context) throws Exception {
        String result;
        OmsLogger omsLogger = context.getOmsLogger();
        String scriptParams = CommonUtils.parseParams(context);
        omsLogger.info("[SYSTEM] ScriptProcessor start to process, params: {}", new Object[]{scriptParams});
        if (scriptParams == null) {
            String message = "[SYSTEM] ScriptParams is null, please check jobParam configuration.";
            omsLogger.warn(message, new Object[0]);
            return new ProcessResult(false, message);
        }
        String scriptPath = this.prepareScriptFile(context.getInstanceId(), scriptParams);
        omsLogger.info("[SYSTEM] Generate executable file successfully, path: {}", new Object[]{scriptPath});
        if (SystemUtils.IS_OS_WINDOWS && StringUtils.equals(this.getRunCommand(), SH_SHELL)) {
            String message = String.format("[SYSTEM] Current OS is %s where shell scripts cannot run.", SystemUtils.OS_NAME);
            omsLogger.warn(message, new Object[0]);
            return new ProcessResult(false, message);
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            ProcessBuilder chmodPb = new ProcessBuilder("/bin/chmod", "755", scriptPath);
            chmodPb.start().waitFor();
            omsLogger.info("[SYSTEM] chmod 755 authorization complete, ready to start execution~", new Object[0]);
        }
        ProcessBuilder pb = StringUtils.equals(this.getRunCommand(), CMD_SHELL) ? new ProcessBuilder(this.getRunCommand(), "/c", scriptPath) : new ProcessBuilder(this.getRunCommand(), scriptPath);
        Process process = pb.start();
        StringBuilder inputBuilder = new StringBuilder();
        StringBuilder errorBuilder = new StringBuilder();
        boolean success = true;
        Charset charset = this.getCharset();
        try (InputStream is = process.getInputStream();
             InputStream es = process.getErrorStream();){
            POOL.execute(() -> AbstractScriptProcessor.copyStream(is, inputBuilder, omsLogger, charset));
            POOL.execute(() -> AbstractScriptProcessor.copyStream(es, errorBuilder, omsLogger, charset));
            success = process.waitFor() == 0;
        }
        catch (InterruptedException ie) {
            try {
                omsLogger.info("[SYSTEM] ScriptProcessor has been interrupted", new Object[0]);
            }
            catch (Throwable throwable) {
                String result2 = String.format("[INPUT]: %s;[ERROR]: %s", inputBuilder.toString(), errorBuilder.toString());
                throw throwable;
            }
            result = String.format("[INPUT]: %s;[ERROR]: %s", inputBuilder.toString(), errorBuilder.toString());
        }
        result = String.format("[INPUT]: %s;[ERROR]: %s", inputBuilder.toString(), errorBuilder.toString());
        return new ProcessResult(success, result);
    }

    private String prepareScriptFile(Long instanceId, String processorInfo) throws IOException {
        String scriptPath;
        block52: {
            scriptPath = WORKER_DIR + this.getScriptName(instanceId);
            File script = new File(scriptPath);
            if (script.exists()) {
                return scriptPath;
            }
            File dir = new File(script.getParent());
            boolean success = dir.mkdirs();
            success = script.createNewFile();
            if (!success) {
                throw new RuntimeException("create script file failed");
            }
            for (String protocol : DOWNLOAD_PROTOCOL) {
                if (!processorInfo.startsWith(protocol)) continue;
                FileUtils.copyURLToFile(new URL(processorInfo), script, 5000, 300000);
                return scriptPath;
            }
            Charset charset = this.getCharset();
            if (charset != null) {
                try (OutputStreamWriter fstream = new OutputStreamWriter(Files.newOutputStream(script.toPath(), new OpenOption[0]), charset);
                     BufferedWriter out = new BufferedWriter(fstream);){
                    out.write(processorInfo);
                    out.flush();
                    break block52;
                }
            }
            try (FileWriter fw = new FileWriter(script);
                 BufferedWriter bw = new BufferedWriter(fw);){
                bw.write(processorInfo);
                bw.flush();
            }
        }
        return scriptPath;
    }

    private static void copyStream(InputStream is, StringBuilder sb, OmsLogger omsLogger, Charset charset) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, charset));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                omsLogger.info(line, new Object[0]);
            }
        }
        catch (Exception e) {
            log.warn("[ScriptProcessor] copyStream failed.", (Throwable)e);
            omsLogger.warn("[SYSTEM] copyStream failed.", new Object[]{e});
            sb.append("Exception: ").append(e);
        }
    }

    protected abstract String getScriptName(Long var1);

    protected abstract String getRunCommand();

    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }
}

