/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.request.http;

import java.util.List;
import tech.powerjob.common.enums.DispatchStrategy;
import tech.powerjob.common.enums.ExecuteType;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.model.AlarmConfig;
import tech.powerjob.common.model.JobAdvancedRuntimeConfig;
import tech.powerjob.common.model.LifeCycle;
import tech.powerjob.common.model.LogConfig;
import tech.powerjob.common.utils.CommonUtils;

public class SaveJobInfoRequest {
    private Long id;
    private String jobName;
    private String jobDescription;
    private Long appId;
    private String jobParams;
    private TimeExpressionType timeExpressionType;
    private String timeExpression;
    private ExecuteType executeType;
    private ProcessorType processorType;
    private String processorInfo;
    private Integer maxInstanceNum = 0;
    private Integer concurrency = 5;
    private Long instanceTimeLimit = 0L;
    private Integer instanceRetryNum = 0;
    private Integer taskRetryNum = 0;
    private double minCpuCores = 0.0;
    private double minMemorySpace = 0.0;
    private double minDiskSpace = 0.0;
    private boolean enable = true;
    private String designatedWorkers;
    private Integer maxWorkerCount = 0;
    private List<Long> notifyUserIds;
    private String extra;
    private DispatchStrategy dispatchStrategy;
    private String dispatchStrategyConfig;
    private LifeCycle lifeCycle;
    private AlarmConfig alarmConfig;
    private String tag;
    private LogConfig logConfig;
    private JobAdvancedRuntimeConfig advancedRuntimeConfig;

    public void valid() {
        CommonUtils.requireNonNull(this.jobName, "jobName can't be empty");
        CommonUtils.requireNonNull(this.appId, "appId can't be empty");
        CommonUtils.requireNonNull(this.processorInfo, "processorInfo can't be empty");
        CommonUtils.requireNonNull(this.executeType, "executeType can't be empty");
        CommonUtils.requireNonNull(this.processorType, "processorType can't be empty");
        CommonUtils.requireNonNull(this.timeExpressionType, "timeExpressionType can't be empty");
    }

    public DispatchStrategy getDispatchStrategy() {
        if (this.dispatchStrategy == null) {
            return DispatchStrategy.HEALTH_FIRST;
        }
        return this.dispatchStrategy;
    }

    public Long getId() {
        return this.id;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getJobParams() {
        return this.jobParams;
    }

    public TimeExpressionType getTimeExpressionType() {
        return this.timeExpressionType;
    }

    public String getTimeExpression() {
        return this.timeExpression;
    }

    public ExecuteType getExecuteType() {
        return this.executeType;
    }

    public ProcessorType getProcessorType() {
        return this.processorType;
    }

    public String getProcessorInfo() {
        return this.processorInfo;
    }

    public Integer getMaxInstanceNum() {
        return this.maxInstanceNum;
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    public Long getInstanceTimeLimit() {
        return this.instanceTimeLimit;
    }

    public Integer getInstanceRetryNum() {
        return this.instanceRetryNum;
    }

    public Integer getTaskRetryNum() {
        return this.taskRetryNum;
    }

    public double getMinCpuCores() {
        return this.minCpuCores;
    }

    public double getMinMemorySpace() {
        return this.minMemorySpace;
    }

    public double getMinDiskSpace() {
        return this.minDiskSpace;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getDesignatedWorkers() {
        return this.designatedWorkers;
    }

    public Integer getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    public List<Long> getNotifyUserIds() {
        return this.notifyUserIds;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getDispatchStrategyConfig() {
        return this.dispatchStrategyConfig;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public AlarmConfig getAlarmConfig() {
        return this.alarmConfig;
    }

    public String getTag() {
        return this.tag;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public JobAdvancedRuntimeConfig getAdvancedRuntimeConfig() {
        return this.advancedRuntimeConfig;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setJobParams(String jobParams) {
        this.jobParams = jobParams;
    }

    public void setTimeExpressionType(TimeExpressionType timeExpressionType) {
        this.timeExpressionType = timeExpressionType;
    }

    public void setTimeExpression(String timeExpression) {
        this.timeExpression = timeExpression;
    }

    public void setExecuteType(ExecuteType executeType) {
        this.executeType = executeType;
    }

    public void setProcessorType(ProcessorType processorType) {
        this.processorType = processorType;
    }

    public void setProcessorInfo(String processorInfo) {
        this.processorInfo = processorInfo;
    }

    public void setMaxInstanceNum(Integer maxInstanceNum) {
        this.maxInstanceNum = maxInstanceNum;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public void setInstanceTimeLimit(Long instanceTimeLimit) {
        this.instanceTimeLimit = instanceTimeLimit;
    }

    public void setInstanceRetryNum(Integer instanceRetryNum) {
        this.instanceRetryNum = instanceRetryNum;
    }

    public void setTaskRetryNum(Integer taskRetryNum) {
        this.taskRetryNum = taskRetryNum;
    }

    public void setMinCpuCores(double minCpuCores) {
        this.minCpuCores = minCpuCores;
    }

    public void setMinMemorySpace(double minMemorySpace) {
        this.minMemorySpace = minMemorySpace;
    }

    public void setMinDiskSpace(double minDiskSpace) {
        this.minDiskSpace = minDiskSpace;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setDesignatedWorkers(String designatedWorkers) {
        this.designatedWorkers = designatedWorkers;
    }

    public void setMaxWorkerCount(Integer maxWorkerCount) {
        this.maxWorkerCount = maxWorkerCount;
    }

    public void setNotifyUserIds(List<Long> notifyUserIds) {
        this.notifyUserIds = notifyUserIds;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setDispatchStrategy(DispatchStrategy dispatchStrategy) {
        this.dispatchStrategy = dispatchStrategy;
    }

    public void setDispatchStrategyConfig(String dispatchStrategyConfig) {
        this.dispatchStrategyConfig = dispatchStrategyConfig;
    }

    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void setAlarmConfig(AlarmConfig alarmConfig) {
        this.alarmConfig = alarmConfig;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public void setAdvancedRuntimeConfig(JobAdvancedRuntimeConfig advancedRuntimeConfig) {
        this.advancedRuntimeConfig = advancedRuntimeConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaveJobInfoRequest)) {
            return false;
        }
        SaveJobInfoRequest other = (SaveJobInfoRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$jobDescription = this.getJobDescription();
        String other$jobDescription = other.getJobDescription();
        if (this$jobDescription == null ? other$jobDescription != null : !this$jobDescription.equals(other$jobDescription)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        String this$jobParams = this.getJobParams();
        String other$jobParams = other.getJobParams();
        if (this$jobParams == null ? other$jobParams != null : !this$jobParams.equals(other$jobParams)) {
            return false;
        }
        TimeExpressionType this$timeExpressionType = this.getTimeExpressionType();
        TimeExpressionType other$timeExpressionType = other.getTimeExpressionType();
        if (this$timeExpressionType == null ? other$timeExpressionType != null : !((Object)((Object)this$timeExpressionType)).equals((Object)other$timeExpressionType)) {
            return false;
        }
        String this$timeExpression = this.getTimeExpression();
        String other$timeExpression = other.getTimeExpression();
        if (this$timeExpression == null ? other$timeExpression != null : !this$timeExpression.equals(other$timeExpression)) {
            return false;
        }
        ExecuteType this$executeType = this.getExecuteType();
        ExecuteType other$executeType = other.getExecuteType();
        if (this$executeType == null ? other$executeType != null : !((Object)((Object)this$executeType)).equals((Object)other$executeType)) {
            return false;
        }
        ProcessorType this$processorType = this.getProcessorType();
        ProcessorType other$processorType = other.getProcessorType();
        if (this$processorType == null ? other$processorType != null : !((Object)((Object)this$processorType)).equals((Object)other$processorType)) {
            return false;
        }
        String this$processorInfo = this.getProcessorInfo();
        String other$processorInfo = other.getProcessorInfo();
        if (this$processorInfo == null ? other$processorInfo != null : !this$processorInfo.equals(other$processorInfo)) {
            return false;
        }
        Integer this$maxInstanceNum = this.getMaxInstanceNum();
        Integer other$maxInstanceNum = other.getMaxInstanceNum();
        if (this$maxInstanceNum == null ? other$maxInstanceNum != null : !((Object)this$maxInstanceNum).equals(other$maxInstanceNum)) {
            return false;
        }
        Integer this$concurrency = this.getConcurrency();
        Integer other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
            return false;
        }
        Long this$instanceTimeLimit = this.getInstanceTimeLimit();
        Long other$instanceTimeLimit = other.getInstanceTimeLimit();
        if (this$instanceTimeLimit == null ? other$instanceTimeLimit != null : !((Object)this$instanceTimeLimit).equals(other$instanceTimeLimit)) {
            return false;
        }
        Integer this$instanceRetryNum = this.getInstanceRetryNum();
        Integer other$instanceRetryNum = other.getInstanceRetryNum();
        if (this$instanceRetryNum == null ? other$instanceRetryNum != null : !((Object)this$instanceRetryNum).equals(other$instanceRetryNum)) {
            return false;
        }
        Integer this$taskRetryNum = this.getTaskRetryNum();
        Integer other$taskRetryNum = other.getTaskRetryNum();
        if (this$taskRetryNum == null ? other$taskRetryNum != null : !((Object)this$taskRetryNum).equals(other$taskRetryNum)) {
            return false;
        }
        if (Double.compare(this.getMinCpuCores(), other.getMinCpuCores()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinMemorySpace(), other.getMinMemorySpace()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinDiskSpace(), other.getMinDiskSpace()) != 0) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        String this$designatedWorkers = this.getDesignatedWorkers();
        String other$designatedWorkers = other.getDesignatedWorkers();
        if (this$designatedWorkers == null ? other$designatedWorkers != null : !this$designatedWorkers.equals(other$designatedWorkers)) {
            return false;
        }
        Integer this$maxWorkerCount = this.getMaxWorkerCount();
        Integer other$maxWorkerCount = other.getMaxWorkerCount();
        if (this$maxWorkerCount == null ? other$maxWorkerCount != null : !((Object)this$maxWorkerCount).equals(other$maxWorkerCount)) {
            return false;
        }
        List<Long> this$notifyUserIds = this.getNotifyUserIds();
        List<Long> other$notifyUserIds = other.getNotifyUserIds();
        if (this$notifyUserIds == null ? other$notifyUserIds != null : !((Object)this$notifyUserIds).equals(other$notifyUserIds)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        DispatchStrategy this$dispatchStrategy = this.getDispatchStrategy();
        DispatchStrategy other$dispatchStrategy = other.getDispatchStrategy();
        if (this$dispatchStrategy == null ? other$dispatchStrategy != null : !((Object)((Object)this$dispatchStrategy)).equals((Object)other$dispatchStrategy)) {
            return false;
        }
        String this$dispatchStrategyConfig = this.getDispatchStrategyConfig();
        String other$dispatchStrategyConfig = other.getDispatchStrategyConfig();
        if (this$dispatchStrategyConfig == null ? other$dispatchStrategyConfig != null : !this$dispatchStrategyConfig.equals(other$dispatchStrategyConfig)) {
            return false;
        }
        LifeCycle this$lifeCycle = this.getLifeCycle();
        LifeCycle other$lifeCycle = other.getLifeCycle();
        if (this$lifeCycle == null ? other$lifeCycle != null : !((Object)this$lifeCycle).equals(other$lifeCycle)) {
            return false;
        }
        AlarmConfig this$alarmConfig = this.getAlarmConfig();
        AlarmConfig other$alarmConfig = other.getAlarmConfig();
        if (this$alarmConfig == null ? other$alarmConfig != null : !((Object)this$alarmConfig).equals(other$alarmConfig)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        LogConfig this$logConfig = this.getLogConfig();
        LogConfig other$logConfig = other.getLogConfig();
        if (this$logConfig == null ? other$logConfig != null : !this$logConfig.equals(other$logConfig)) {
            return false;
        }
        JobAdvancedRuntimeConfig this$advancedRuntimeConfig = this.getAdvancedRuntimeConfig();
        JobAdvancedRuntimeConfig other$advancedRuntimeConfig = other.getAdvancedRuntimeConfig();
        return !(this$advancedRuntimeConfig == null ? other$advancedRuntimeConfig != null : !this$advancedRuntimeConfig.equals(other$advancedRuntimeConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SaveJobInfoRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $jobDescription = this.getJobDescription();
        result = result * 59 + ($jobDescription == null ? 43 : $jobDescription.hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        String $jobParams = this.getJobParams();
        result = result * 59 + ($jobParams == null ? 43 : $jobParams.hashCode());
        TimeExpressionType $timeExpressionType = this.getTimeExpressionType();
        result = result * 59 + ($timeExpressionType == null ? 43 : ((Object)((Object)$timeExpressionType)).hashCode());
        String $timeExpression = this.getTimeExpression();
        result = result * 59 + ($timeExpression == null ? 43 : $timeExpression.hashCode());
        ExecuteType $executeType = this.getExecuteType();
        result = result * 59 + ($executeType == null ? 43 : ((Object)((Object)$executeType)).hashCode());
        ProcessorType $processorType = this.getProcessorType();
        result = result * 59 + ($processorType == null ? 43 : ((Object)((Object)$processorType)).hashCode());
        String $processorInfo = this.getProcessorInfo();
        result = result * 59 + ($processorInfo == null ? 43 : $processorInfo.hashCode());
        Integer $maxInstanceNum = this.getMaxInstanceNum();
        result = result * 59 + ($maxInstanceNum == null ? 43 : ((Object)$maxInstanceNum).hashCode());
        Integer $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
        Long $instanceTimeLimit = this.getInstanceTimeLimit();
        result = result * 59 + ($instanceTimeLimit == null ? 43 : ((Object)$instanceTimeLimit).hashCode());
        Integer $instanceRetryNum = this.getInstanceRetryNum();
        result = result * 59 + ($instanceRetryNum == null ? 43 : ((Object)$instanceRetryNum).hashCode());
        Integer $taskRetryNum = this.getTaskRetryNum();
        result = result * 59 + ($taskRetryNum == null ? 43 : ((Object)$taskRetryNum).hashCode());
        long $minCpuCores = Double.doubleToLongBits(this.getMinCpuCores());
        result = result * 59 + (int)($minCpuCores >>> 32 ^ $minCpuCores);
        long $minMemorySpace = Double.doubleToLongBits(this.getMinMemorySpace());
        result = result * 59 + (int)($minMemorySpace >>> 32 ^ $minMemorySpace);
        long $minDiskSpace = Double.doubleToLongBits(this.getMinDiskSpace());
        result = result * 59 + (int)($minDiskSpace >>> 32 ^ $minDiskSpace);
        result = result * 59 + (this.isEnable() ? 79 : 97);
        String $designatedWorkers = this.getDesignatedWorkers();
        result = result * 59 + ($designatedWorkers == null ? 43 : $designatedWorkers.hashCode());
        Integer $maxWorkerCount = this.getMaxWorkerCount();
        result = result * 59 + ($maxWorkerCount == null ? 43 : ((Object)$maxWorkerCount).hashCode());
        List<Long> $notifyUserIds = this.getNotifyUserIds();
        result = result * 59 + ($notifyUserIds == null ? 43 : ((Object)$notifyUserIds).hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        DispatchStrategy $dispatchStrategy = this.getDispatchStrategy();
        result = result * 59 + ($dispatchStrategy == null ? 43 : ((Object)((Object)$dispatchStrategy)).hashCode());
        String $dispatchStrategyConfig = this.getDispatchStrategyConfig();
        result = result * 59 + ($dispatchStrategyConfig == null ? 43 : $dispatchStrategyConfig.hashCode());
        LifeCycle $lifeCycle = this.getLifeCycle();
        result = result * 59 + ($lifeCycle == null ? 43 : ((Object)$lifeCycle).hashCode());
        AlarmConfig $alarmConfig = this.getAlarmConfig();
        result = result * 59 + ($alarmConfig == null ? 43 : ((Object)$alarmConfig).hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        LogConfig $logConfig = this.getLogConfig();
        result = result * 59 + ($logConfig == null ? 43 : $logConfig.hashCode());
        JobAdvancedRuntimeConfig $advancedRuntimeConfig = this.getAdvancedRuntimeConfig();
        result = result * 59 + ($advancedRuntimeConfig == null ? 43 : $advancedRuntimeConfig.hashCode());
        return result;
    }

    public String toString() {
        return "SaveJobInfoRequest(id=" + this.getId() + ", jobName=" + this.getJobName() + ", jobDescription=" + this.getJobDescription() + ", appId=" + this.getAppId() + ", jobParams=" + this.getJobParams() + ", timeExpressionType=" + (Object)((Object)this.getTimeExpressionType()) + ", timeExpression=" + this.getTimeExpression() + ", executeType=" + (Object)((Object)this.getExecuteType()) + ", processorType=" + (Object)((Object)this.getProcessorType()) + ", processorInfo=" + this.getProcessorInfo() + ", maxInstanceNum=" + this.getMaxInstanceNum() + ", concurrency=" + this.getConcurrency() + ", instanceTimeLimit=" + this.getInstanceTimeLimit() + ", instanceRetryNum=" + this.getInstanceRetryNum() + ", taskRetryNum=" + this.getTaskRetryNum() + ", minCpuCores=" + this.getMinCpuCores() + ", minMemorySpace=" + this.getMinMemorySpace() + ", minDiskSpace=" + this.getMinDiskSpace() + ", enable=" + this.isEnable() + ", designatedWorkers=" + this.getDesignatedWorkers() + ", maxWorkerCount=" + this.getMaxWorkerCount() + ", notifyUserIds=" + this.getNotifyUserIds() + ", extra=" + this.getExtra() + ", dispatchStrategy=" + (Object)((Object)this.getDispatchStrategy()) + ", dispatchStrategyConfig=" + this.getDispatchStrategyConfig() + ", lifeCycle=" + this.getLifeCycle() + ", alarmConfig=" + this.getAlarmConfig() + ", tag=" + this.getTag() + ", logConfig=" + this.getLogConfig() + ", advancedRuntimeConfig=" + this.getAdvancedRuntimeConfig() + ")";
    }
}

