/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PEWorkflowDAG
implements Serializable {
    private List<Node> nodes;
    private List<Edge> edges;

    public PEWorkflowDAG(@Nonnull List<Node> nodes, @Nullable List<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges == null ? Lists.newLinkedList() : edges;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PEWorkflowDAG)) {
            return false;
        }
        PEWorkflowDAG other = (PEWorkflowDAG)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Node> this$nodes = this.getNodes();
        List<Node> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<Edge> this$edges = this.getEdges();
        List<Edge> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PEWorkflowDAG;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<Edge> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    public String toString() {
        return "PEWorkflowDAG(nodes=" + this.getNodes() + ", edges=" + this.getEdges() + ")";
    }

    public PEWorkflowDAG() {
    }

    public static class Edge
    implements Serializable {
        private Long from;
        private Long to;

        public Long getFrom() {
            return this.from;
        }

        public Long getTo() {
            return this.to;
        }

        public void setFrom(Long from) {
            this.from = from;
        }

        public void setTo(Long to) {
            this.to = to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$from = this.getFrom();
            Long other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            Long this$to = this.getTo();
            Long other$to = other.getTo();
            return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Edge;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            Long $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            return result;
        }

        public String toString() {
            return "PEWorkflowDAG.Edge(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }

        public Edge() {
        }

        public Edge(Long from, Long to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class Node
    implements Serializable {
        private Long nodeId;
        private Integer nodeType;
        private Long jobId;
        private String nodeName;
        @JsonSerialize(using=ToStringSerializer.class)
        private Long instanceId;
        private String nodeParams;
        private Integer status;
        private String result;
        private Boolean enable;
        private Boolean skipWhenFailed;

        public Node(Long nodeId) {
            this.nodeId = nodeId;
        }

        public Long getNodeId() {
            return this.nodeId;
        }

        public Integer getNodeType() {
            return this.nodeType;
        }

        public Long getJobId() {
            return this.jobId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public Long getInstanceId() {
            return this.instanceId;
        }

        public String getNodeParams() {
            return this.nodeParams;
        }

        public Integer getStatus() {
            return this.status;
        }

        public String getResult() {
            return this.result;
        }

        public Boolean getEnable() {
            return this.enable;
        }

        public Boolean getSkipWhenFailed() {
            return this.skipWhenFailed;
        }

        public Node setNodeId(Long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Node setNodeType(Integer nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Node setJobId(Long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Node setNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public Node setInstanceId(Long instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Node setNodeParams(String nodeParams) {
            this.nodeParams = nodeParams;
            return this;
        }

        public Node setStatus(Integer status) {
            this.status = status;
            return this;
        }

        public Node setResult(String result) {
            this.result = result;
            return this;
        }

        public Node setEnable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public Node setSkipWhenFailed(Boolean skipWhenFailed) {
            this.skipWhenFailed = skipWhenFailed;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$nodeId = this.getNodeId();
            Long other$nodeId = other.getNodeId();
            if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
                return false;
            }
            Integer this$nodeType = this.getNodeType();
            Integer other$nodeType = other.getNodeType();
            if (this$nodeType == null ? other$nodeType != null : !((Object)this$nodeType).equals(other$nodeType)) {
                return false;
            }
            Long this$jobId = this.getJobId();
            Long other$jobId = other.getJobId();
            if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
                return false;
            }
            String this$nodeName = this.getNodeName();
            String other$nodeName = other.getNodeName();
            if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
                return false;
            }
            Long this$instanceId = this.getInstanceId();
            Long other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
                return false;
            }
            String this$nodeParams = this.getNodeParams();
            String other$nodeParams = other.getNodeParams();
            if (this$nodeParams == null ? other$nodeParams != null : !this$nodeParams.equals(other$nodeParams)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Boolean this$enable = this.getEnable();
            Boolean other$enable = other.getEnable();
            if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
                return false;
            }
            Boolean this$skipWhenFailed = this.getSkipWhenFailed();
            Boolean other$skipWhenFailed = other.getSkipWhenFailed();
            return !(this$skipWhenFailed == null ? other$skipWhenFailed != null : !((Object)this$skipWhenFailed).equals(other$skipWhenFailed));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $nodeId = this.getNodeId();
            result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
            Integer $nodeType = this.getNodeType();
            result = result * 59 + ($nodeType == null ? 43 : ((Object)$nodeType).hashCode());
            Long $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
            String $nodeName = this.getNodeName();
            result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
            Long $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
            String $nodeParams = this.getNodeParams();
            result = result * 59 + ($nodeParams == null ? 43 : $nodeParams.hashCode());
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Boolean $enable = this.getEnable();
            result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
            Boolean $skipWhenFailed = this.getSkipWhenFailed();
            result = result * 59 + ($skipWhenFailed == null ? 43 : ((Object)$skipWhenFailed).hashCode());
            return result;
        }

        public String toString() {
            return "PEWorkflowDAG.Node(nodeId=" + this.getNodeId() + ", nodeType=" + this.getNodeType() + ", jobId=" + this.getJobId() + ", nodeName=" + this.getNodeName() + ", instanceId=" + this.getInstanceId() + ", nodeParams=" + this.getNodeParams() + ", status=" + this.getStatus() + ", result=" + this.getResult() + ", enable=" + this.getEnable() + ", skipWhenFailed=" + this.getSkipWhenFailed() + ")";
        }

        public Node() {
        }

        public Node(Long nodeId, Integer nodeType, Long jobId, String nodeName, Long instanceId, String nodeParams, Integer status, String result, Boolean enable, Boolean skipWhenFailed) {
            this.nodeId = nodeId;
            this.nodeType = nodeType;
            this.jobId = jobId;
            this.nodeName = nodeName;
            this.instanceId = instanceId;
            this.nodeParams = nodeParams;
            this.status = status;
            this.result = result;
            this.enable = enable;
            this.skipWhenFailed = skipWhenFailed;
        }
    }
}

