/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.client.ClientConfig;
import tech.powerjob.client.IPowerJobClient;
import tech.powerjob.client.TypeStore;
import tech.powerjob.client.module.AppAuthRequest;
import tech.powerjob.client.module.AppAuthResult;
import tech.powerjob.client.service.PowerRequestBody;
import tech.powerjob.client.service.RequestService;
import tech.powerjob.client.service.impl.ClusterRequestServiceOkHttp3Impl;
import tech.powerjob.common.enums.EncryptType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.request.http.SaveJobInfoRequest;
import tech.powerjob.common.request.http.SaveWorkflowNodeRequest;
import tech.powerjob.common.request.http.SaveWorkflowRequest;
import tech.powerjob.common.request.query.JobInfoQuery;
import tech.powerjob.common.response.InstanceInfoDTO;
import tech.powerjob.common.response.JobInfoDTO;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.response.WorkflowInfoDTO;
import tech.powerjob.common.response.WorkflowInstanceInfoDTO;
import tech.powerjob.common.response.WorkflowNodeInfoDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.DigestUtils;

public class PowerJobClient
implements IPowerJobClient,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(PowerJobClient.class);
    private Long appId;
    private final RequestService requestService;

    public PowerJobClient(ClientConfig config) {
        List<String> addressList = config.getAddressList();
        String appName = config.getAppName();
        CommonUtils.requireNonNull(addressList, (String)"addressList can't be null!");
        CommonUtils.requireNonNull((Object)appName, (String)"appName can't be null");
        this.requestService = new ClusterRequestServiceOkHttp3Impl(config);
        AppAuthRequest appAuthRequest = new AppAuthRequest();
        appAuthRequest.setAppName(appName);
        appAuthRequest.setEncryptedPassword(DigestUtils.md5((String)config.getPassword()));
        appAuthRequest.setEncryptType(EncryptType.MD5.getCode());
        String assertResponse = this.requestService.request("/authApp", PowerRequestBody.newJsonRequestBody(appAuthRequest));
        if (StringUtils.isNotEmpty((CharSequence)assertResponse)) {
            ResultDTO resultDTO = (ResultDTO)JSON.parseObject((String)assertResponse, TypeStore.APP_AUTH_RESULT_TYPE, (Feature[])new Feature[0]);
            if (resultDTO.isSuccess()) {
                this.appId = ((AppAuthResult)resultDTO.getData()).getAppId();
            } else {
                throw new PowerJobException(resultDTO.getMessage());
            }
        }
        if (this.appId == null) {
            throw new PowerJobException("appId is null, please check your config");
        }
        log.info("[PowerJobClient] [INIT] {}'s PowerJobClient bootstrap successfully", (Object)appName);
    }

    public PowerJobClient(String domain, String appName, String password) {
        this(new ClientConfig().setAppName(appName).setPassword(password).setAddressList(Lists.newArrayList((Object[])new String[]{domain})));
    }

    public PowerJobClient(List<String> addressList, String appName, String password) {
        this(new ClientConfig().setAppName(appName).setPassword(password).setAddressList(addressList));
    }

    @Override
    public ResultDTO<Long> saveJob(SaveJobInfoRequest request) {
        request.setAppId(this.appId);
        String post = this.requestService.request("/saveJob", PowerRequestBody.newJsonRequestBody(request));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Long> copyJob(Long jobId) {
        HashMap param = Maps.newHashMap();
        param.put("jobId", jobId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/copyJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<SaveJobInfoRequest> exportJob(Long jobId) {
        HashMap param = Maps.newHashMap();
        param.put("jobId", jobId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/exportJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.SAVE_JOB_INFO_REQUEST_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<JobInfoDTO> fetchJob(Long jobId) {
        HashMap param = Maps.newHashMap();
        param.put("jobId", jobId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/fetchJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.JOB_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<List<JobInfoDTO>> fetchAllJob() {
        HashMap param = Maps.newHashMap();
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/fetchAllJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LIST_JOB_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<List<JobInfoDTO>> queryJob(JobInfoQuery powerQuery) {
        powerQuery.setAppIdEq(this.appId);
        String post = this.requestService.request("/queryJob", PowerRequestBody.newJsonRequestBody(powerQuery));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LIST_JOB_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> disableJob(Long jobId) {
        HashMap param = Maps.newHashMap();
        param.put("jobId", jobId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/disableJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> enableJob(Long jobId) {
        HashMap param = Maps.newHashMap();
        param.put("jobId", jobId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/enableJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> deleteJob(Long jobId) {
        HashMap param = Maps.newHashMap();
        param.put("jobId", jobId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/deleteJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Long> runJob(Long jobId, String instanceParams, long delayMS) {
        HashMap param = Maps.newHashMap();
        param.put("jobId", jobId.toString());
        param.put("appId", this.appId.toString());
        param.put("delay", String.valueOf(delayMS));
        if (StringUtils.isNotEmpty((CharSequence)instanceParams)) {
            param.put("instanceParams", instanceParams);
        }
        String post = this.requestService.request("/runJob", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> runJob(Long jobId) {
        return this.runJob(jobId, null, 0L);
    }

    @Override
    public ResultDTO<Void> stopInstance(Long instanceId) {
        HashMap param = Maps.newHashMap();
        param.put("instanceId", instanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/stopInstance", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> cancelInstance(Long instanceId) {
        HashMap param = Maps.newHashMap();
        param.put("instanceId", instanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/cancelInstance", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> retryInstance(Long instanceId) {
        HashMap param = Maps.newHashMap();
        param.put("instanceId", instanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/retryInstance", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Integer> fetchInstanceStatus(Long instanceId) {
        HashMap param = Maps.newHashMap();
        param.put("instanceId", instanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/fetchInstanceStatus", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.INTEGER_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<InstanceInfoDTO> fetchInstanceInfo(Long instanceId) {
        HashMap param = Maps.newHashMap();
        param.put("instanceId", instanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/fetchInstanceInfo", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.INSTANCE_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Long> saveWorkflow(SaveWorkflowRequest request) {
        request.setAppId(this.appId);
        String json = JsonUtils.toJSONStringUnsafe((Object)request);
        String post = this.requestService.request("/saveWorkflow", PowerRequestBody.newJsonRequestBody(json));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Long> copyWorkflow(Long workflowId) {
        HashMap param = Maps.newHashMap();
        param.put("workflowId", workflowId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/copyWorkflow", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<List<WorkflowNodeInfoDTO>> saveWorkflowNode(List<SaveWorkflowNodeRequest> requestList) {
        for (SaveWorkflowNodeRequest saveWorkflowNodeRequest : requestList) {
            saveWorkflowNodeRequest.setAppId(this.appId);
        }
        String json = JsonUtils.toJSONStringUnsafe(requestList);
        String post = this.requestService.request("/addWorkflowNode", PowerRequestBody.newJsonRequestBody(json));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.WF_NODE_LIST_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<WorkflowInfoDTO> fetchWorkflow(Long workflowId) {
        HashMap param = Maps.newHashMap();
        param.put("workflowId", workflowId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/fetchWorkflow", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.WF_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> disableWorkflow(Long workflowId) {
        HashMap param = Maps.newHashMap();
        param.put("workflowId", workflowId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/disableWorkflow", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> enableWorkflow(Long workflowId) {
        HashMap param = Maps.newHashMap();
        param.put("workflowId", workflowId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/enableWorkflow", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> deleteWorkflow(Long workflowId) {
        HashMap param = Maps.newHashMap();
        param.put("workflowId", workflowId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/deleteWorkflow", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Long> runWorkflow(Long workflowId, String initParams, long delayMS) {
        HashMap param = Maps.newHashMap();
        param.put("workflowId", workflowId.toString());
        param.put("appId", this.appId.toString());
        param.put("delay", String.valueOf(delayMS));
        if (StringUtils.isNotEmpty((CharSequence)initParams)) {
            param.put("initParams", initParams);
        }
        String post = this.requestService.request("/runWorkflow", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> runWorkflow(Long workflowId) {
        return this.runWorkflow(workflowId, null, 0L);
    }

    @Override
    public ResultDTO<Void> stopWorkflowInstance(Long wfInstanceId) {
        HashMap param = Maps.newHashMap();
        param.put("wfInstanceId", wfInstanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/stopWfInstance", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> retryWorkflowInstance(Long wfInstanceId) {
        HashMap param = Maps.newHashMap();
        param.put("wfInstanceId", wfInstanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/retryWfInstance", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<Void> markWorkflowNodeAsSuccess(Long wfInstanceId, Long nodeId) {
        HashMap param = Maps.newHashMap();
        param.put("wfInstanceId", wfInstanceId.toString());
        param.put("appId", this.appId.toString());
        param.put("nodeId", nodeId.toString());
        String post = this.requestService.request("/markWorkflowNodeAsSuccess", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public ResultDTO<WorkflowInstanceInfoDTO> fetchWorkflowInstanceInfo(Long wfInstanceId) {
        HashMap param = Maps.newHashMap();
        param.put("wfInstanceId", wfInstanceId.toString());
        param.put("appId", this.appId.toString());
        String post = this.requestService.request("/fetchWfInstanceInfo", PowerRequestBody.newFormRequestBody(param));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.WF_INSTANCE_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    @Override
    public void close() throws IOException {
        this.requestService.close();
    }
}

