/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.errorprone.BugCheckerRefactoringTestHelper;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.SubContext;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import tech.picnic.errorprone.refaster.runner.CodeTransformers;
import tech.picnic.errorprone.refaster.runner.Refaster;

@BugPattern(summary="Exercises a Refaster template collection", severity=BugPattern.SeverityLevel.ERROR)
public final class RefasterTemplateCollection
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String TEMPLATE_COLLECTION_FLAG = "RefasterTemplateCollection:TemplateCollection";
    private static final String TEST_METHOD_NAME_PREFIX = "test";
    private final ImmutableSortedSet<String> templatesUnderTest;
    private final Refaster delegate;

    public RefasterTemplateCollection(ErrorProneFlags flags) {
        String templateCollectionUnderTest = RefasterTemplateCollection.getTemplateCollectionUnderTest(flags);
        this.delegate = RefasterTemplateCollection.createRefasterChecker(templateCollectionUnderTest);
        this.templatesUnderTest = RefasterTemplateCollection.getTemplatesUnderTest(templateCollectionUnderTest);
    }

    private static String getTemplateCollectionUnderTest(ErrorProneFlags flags) {
        return (String)flags.get(TEMPLATE_COLLECTION_FLAG).orElseThrow(() -> new IllegalStateException(String.format("Error Prone flag `%s` must be specified", TEMPLATE_COLLECTION_FLAG)));
    }

    private static Refaster createRefasterChecker(String templateCollectionUnderTest) {
        return new Refaster(ErrorProneFlags.fromMap((Map)ImmutableMap.of((Object)"Refaster:NamePattern", (Object)(Pattern.quote(templateCollectionUnderTest) + ".*"))));
    }

    private static ImmutableSortedSet<String> getTemplatesUnderTest(String templateCollectionUnderTest) {
        return (ImmutableSortedSet)CodeTransformers.getAllCodeTransformers().keySet().stream().filter(k -> k.startsWith(templateCollectionUnderTest)).map(k -> k.replace(templateCollectionUnderTest + "$", "")).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }

    public static void validate(Class<?> clazz) {
        String className = clazz.getSimpleName();
        BugCheckerRefactoringTestHelper.newInstance(RefasterTemplateCollection.class, clazz).setArgs(ImmutableList.of((Object)("-XepOpt:RefasterTemplateCollection:TemplateCollection=" + className))).addInput(className + "TestInput.java").addOutput(className + "TestOutput.java").doTest(BugCheckerRefactoringTestHelper.TestMode.TEXT_MATCH);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ArrayList<Description> matches = new ArrayList<Description>();
        this.delegate.matchCompilationUnit(tree, VisitorState.createForCustomFindingCollection((Context)new SubContext(state.context), matches::add).withPath(state.getPath()));
        ImmutableRangeMap<Integer, String> indexedMatches = RefasterTemplateCollection.indexTemplateMatches(matches, ((JCTree.JCCompilationUnit)tree).endPositions);
        matches.forEach(arg_0 -> ((VisitorState)state).reportMatch(arg_0));
        this.reportMissingMatches(tree, indexedMatches, state);
        this.reportUnexpectedMatches(tree, indexedMatches, state);
        return Description.NO_MATCH;
    }

    private static ImmutableRangeMap<Integer, String> indexTemplateMatches(List<Description> matches, EndPosTable endPositions) {
        ImmutableRangeMap.Builder templateMatches = ImmutableRangeMap.builder();
        for (Description description : matches) {
            Set replacements = ((Fix)Iterables.getOnlyElement((Iterable)description.fixes)).getReplacements(endPositions);
            for (Replacement replacement : replacements) {
                templateMatches.put(replacement.range(), (Object)RefasterTemplateCollection.getSubstringAfterFinalDelimiter('.', description.checkName));
            }
        }
        return templateMatches.build();
    }

    private void reportMissingMatches(CompilationUnitTree tree, ImmutableRangeMap<Integer, String> indexedMatches, VisitorState state) {
        ImmutableSet templatesWithoutMatch = Sets.difference(this.templatesUnderTest, (Set)ImmutableSet.copyOf((Collection)indexedMatches.asMapOfRanges().values())).immutableCopy();
        if (!templatesWithoutMatch.isEmpty()) {
            String sourceFile = ((JCTree.JCCompilationUnit)tree).sourcefile.getName();
            this.reportViolations(tree, String.format("Did not encounter a test in `%s` for the following template(s)", RefasterTemplateCollection.getSubstringAfterFinalDelimiter('/', sourceFile)), (ImmutableSet<String>)templatesWithoutMatch, state);
        }
    }

    private void reportUnexpectedMatches(CompilationUnitTree tree, ImmutableRangeMap<Integer, String> indexedMatches, VisitorState state) {
        UnexpectedMatchReporter unexpectedMatchReporter = new UnexpectedMatchReporter(indexedMatches);
        unexpectedMatchReporter.scan(tree.getTypeDecls(), state);
    }

    private void reportViolations(Tree tree, String message, ImmutableSet<String> violations, VisitorState state) {
        String violationEnumeration = String.join((CharSequence)"\n*  - ", violations);
        String comment = String.format("/*\n*  ERROR: %s:\n*  - %s\n*/\n", message, violationEnumeration);
        SuggestedFix fixWithComment = tree instanceof MethodTree ? SuggestedFix.prefixWith((Tree)tree, (String)comment) : SuggestedFix.postfixWith((Tree)tree, (String)("\n" + comment));
        state.reportMatch(this.describeMatch(tree, (Fix)fixWithComment));
    }

    private static String getSubstringAfterFinalDelimiter(char delimiter, String value) {
        int index = value.lastIndexOf(delimiter);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"String '%s' does not contain character '%s'", (Object)value, (char)delimiter);
        return value.substring(index + 1);
    }

    private class UnexpectedMatchReporter
    extends TreeScanner<Void, VisitorState> {
        private final ImmutableRangeMap<Integer, String> indexedMatches;

        UnexpectedMatchReporter(ImmutableRangeMap<Integer, String> indexedMatches) {
            this.indexedMatches = indexedMatches;
        }

        @Override
        @Nullable
        public Void visitMethod(MethodTree tree, VisitorState state) {
            if (!ASTHelpers.isGeneratedConstructor((MethodTree)tree)) {
                this.getTemplateUnderTest(tree, state).ifPresent(templateUnderTest -> this.reportUnexpectedMatches(tree, (String)templateUnderTest, state));
            }
            return (Void)super.visitMethod(tree, state);
        }

        private void reportUnexpectedMatches(MethodTree tree, String templateUnderTest, VisitorState state) {
            ImmutableListMultimap<Long, String> unexpectedMatchesByLineNumber = this.getUnexpectedMatchesByLineNumber(this.getMatchesInTree(tree, state), templateUnderTest, state);
            if (!unexpectedMatchesByLineNumber.isEmpty()) {
                RefasterTemplateCollection.this.reportViolations(tree, String.format("The following matches unexpectedly occurred in method `%s`", tree.getName()), (ImmutableSet<String>)((ImmutableSet)unexpectedMatchesByLineNumber.entries().stream().map(e -> String.format("Template `%s` matches on line %s, while it should match in a method named `test%s`.", e.getValue(), e.getKey(), e.getValue())).collect(ImmutableSet.toImmutableSet())), state);
            }
        }

        private Optional<String> getTemplateUnderTest(MethodTree tree, VisitorState state) {
            String methodName = tree.getName().toString();
            if (methodName.startsWith(RefasterTemplateCollection.TEST_METHOD_NAME_PREFIX)) {
                return Optional.of(methodName.substring(RefasterTemplateCollection.TEST_METHOD_NAME_PREFIX.length()));
            }
            if (!"elidedTypesAndStaticImports".equals(methodName)) {
                state.reportMatch(RefasterTemplateCollection.this.describeMatch(tree, (Fix)SuggestedFix.prefixWith((Tree)tree, (String)"/* ERROR: Method names should start with `test`. */\n")));
            }
            return Optional.empty();
        }

        private ImmutableRangeMap<Integer, String> getMatchesInTree(MethodTree tree, VisitorState state) {
            int startPosition = ASTHelpers.getStartPosition((Tree)tree);
            int endPosition = state.getEndPosition((Tree)tree);
            Preconditions.checkState((startPosition != -1 && endPosition != -1 ? 1 : 0) != 0, (Object)"Cannot determine location of method in source code");
            return this.indexedMatches.subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)));
        }

        private ImmutableListMultimap<Long, String> getUnexpectedMatchesByLineNumber(ImmutableRangeMap<Integer, String> matches, String templateUnderTest, VisitorState state) {
            LineMap lineMap = state.getPath().getCompilationUnit().getLineMap();
            return (ImmutableListMultimap)matches.asMapOfRanges().entrySet().stream().filter(e -> !((String)e.getValue()).equals(templateUnderTest)).collect(ImmutableListMultimap.toImmutableListMultimap(e -> lineMap.getLineNumber(((Integer)((Range)e.getKey()).lowerEndpoint()).intValue()), Map.Entry::getValue));
        }
    }
}

