/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.errorprone.BugCheckerRefactoringTestHelper;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.SubContext;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.ErrorProneEndPosTable;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.refaster.runner.CodeTransformers;
import tech.picnic.errorprone.refaster.runner.Refaster;

@BugPattern(summary="Exercises a Refaster rule collection", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.ERROR)
public final class RefasterRuleCollection
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String RULE_COLLECTION_FLAG = "RefasterRuleCollection:RuleCollection";
    private static final String TEST_METHOD_NAME_PREFIX = "test";
    private final String ruleCollectionUnderTest;
    private final ImmutableSortedSet<String> rulesUnderTest;
    private final Refaster delegate;

    @Inject
    RefasterRuleCollection(ErrorProneFlags flags) {
        this.ruleCollectionUnderTest = RefasterRuleCollection.getRuleCollectionUnderTest(flags);
        this.delegate = RefasterRuleCollection.createRefasterChecker(this.ruleCollectionUnderTest);
        this.rulesUnderTest = RefasterRuleCollection.getRulesUnderTest(this.ruleCollectionUnderTest);
    }

    private static String getRuleCollectionUnderTest(ErrorProneFlags flags) {
        return (String)flags.get(RULE_COLLECTION_FLAG).orElseThrow(() -> new IllegalStateException("Error Prone flag `%s` must be specified".formatted(RULE_COLLECTION_FLAG)));
    }

    private static Refaster createRefasterChecker(String ruleCollectionUnderTest) {
        return new Refaster(ErrorProneFlags.fromMap((Map)ImmutableMap.of((Object)"Refaster:NamePattern", (Object)(Pattern.quote(ruleCollectionUnderTest) + ".*"))));
    }

    private static ImmutableSortedSet<String> getRulesUnderTest(String ruleCollectionUnderTest) {
        return (ImmutableSortedSet)CodeTransformers.getAllCodeTransformers().keySet().stream().filter(k -> k.startsWith(ruleCollectionUnderTest)).map(k -> k.replace(ruleCollectionUnderTest + "$", "")).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }

    public static void validate(Class<?> clazz) {
        String className = clazz.getSimpleName();
        String inputResource = className + "TestInput.java";
        String outputResource = className + "TestOutput.java";
        BugCheckerRefactoringTestHelper.newInstance(RefasterRuleCollection.class, clazz).setArgs(new String[]{"--add-exports=jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", "-XepOpt:RefasterRuleCollection:RuleCollection=" + className}).addInputLines(inputResource, new String[]{RefasterRuleCollection.loadResource(clazz, inputResource)}).addOutputLines(outputResource, new String[]{RefasterRuleCollection.loadResource(clazz, outputResource)}).doTest(BugCheckerRefactoringTestHelper.TestMode.TEXT_MATCH);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        this.reportIncorrectClassName(tree, state);
        ArrayList<Description> matches = new ArrayList<Description>();
        this.delegate.matchCompilationUnit(tree, VisitorState.createForCustomFindingCollection((Context)new SubContext(state.context), matches::add).withPath(state.getPath()));
        ImmutableRangeMap<Integer, String> indexedMatches = RefasterRuleCollection.indexRuleMatches(matches, ErrorProneEndPosTable.create((CompilationUnitTree)tree));
        matches.forEach(arg_0 -> ((VisitorState)state).reportMatch(arg_0));
        this.reportMissingMatches(tree, indexedMatches, state);
        this.reportUnexpectedMatches(tree, indexedMatches, state);
        return Description.NO_MATCH;
    }

    private void reportIncorrectClassName(CompilationUnitTree tree, VisitorState state) {
        String expectedClassName = this.ruleCollectionUnderTest + "Test";
        for (Tree tree2 : tree.getTypeDecls()) {
            if (tree2 instanceof ClassTree) {
                ClassTree classTree = (ClassTree)tree2;
                if (classTree.getSimpleName().contentEquals(expectedClassName)) continue;
                state.reportMatch(this.describeMatch(tree2, (Fix)SuggestedFix.prefixWith((Tree)tree2, (String)"/* ERROR: Class should be named `%s`. */%n".formatted(expectedClassName))));
                continue;
            }
            state.reportMatch(this.describeMatch(tree2, (Fix)SuggestedFix.prefixWith((Tree)tree2, (String)"/* ERROR: Unexpected token. */%n".formatted(new Object[0]))));
        }
    }

    private static ImmutableRangeMap<Integer, String> indexRuleMatches(List<Description> matches, ErrorProneEndPosTable endPositions) {
        ImmutableRangeMap.Builder ruleMatches = ImmutableRangeMap.builder();
        for (Description description : matches) {
            String ruleName = RefasterRuleCollection.extractRefasterRuleName(description);
            ImmutableSet replacements = ((Fix)Iterables.getOnlyElement((Iterable)description.fixes)).getReplacements(endPositions);
            for (Replacement replacement : replacements) {
                ruleMatches.put(replacement.range(), (Object)ruleName);
            }
        }
        return ruleMatches.build();
    }

    private void reportMissingMatches(CompilationUnitTree tree, ImmutableRangeMap<Integer, String> indexedMatches, VisitorState state) {
        ImmutableSet rulesWithoutMatch = Sets.difference(this.rulesUnderTest, (Set)ImmutableSet.copyOf((Collection)indexedMatches.asMapOfRanges().values())).immutableCopy();
        if (!rulesWithoutMatch.isEmpty()) {
            String sourceFile = ((JCTree.JCCompilationUnit)tree).sourcefile.getName();
            this.reportViolations(tree, "Did not encounter a test in `%s` for the following rule(s)".formatted(RefasterRuleCollection.getSubstringAfterFinalDelimiter('/', sourceFile)), (ImmutableSet<String>)rulesWithoutMatch, state);
        }
    }

    private void reportUnexpectedMatches(CompilationUnitTree tree, ImmutableRangeMap<Integer, String> indexedMatches, VisitorState state) {
        UnexpectedMatchReporter unexpectedMatchReporter = new UnexpectedMatchReporter(indexedMatches);
        unexpectedMatchReporter.scan(tree.getTypeDecls(), state);
    }

    private void reportViolations(Tree tree, String message, ImmutableSet<String> violations, VisitorState state) {
        String violationEnumeration = String.join((CharSequence)"%n*  - ".formatted(new Object[0]), violations);
        String comment = "/*%n*  ERROR: %s:%n*  - %s%n*/%n".formatted(message, violationEnumeration);
        SuggestedFix fixWithComment = tree instanceof MethodTree ? SuggestedFix.prefixWith((Tree)tree, (String)comment) : SuggestedFix.postfixWith((Tree)tree, (String)"%n%s".formatted(comment));
        state.reportMatch(this.describeMatch(tree, (Fix)fixWithComment));
    }

    private static String extractRefasterRuleName(Description description) {
        String message = description.getRawMessage();
        int index = message.indexOf(58);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"Failed to extract Refaster rule name from string '%s'", (Object)message);
        return RefasterRuleCollection.getSubstringAfterFinalDelimiter('.', message.substring(0, index));
    }

    private static String getSubstringAfterFinalDelimiter(char delimiter, String value) {
        int index = value.lastIndexOf(delimiter);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"String '%s' does not contain character '%s'", (Object)value, (char)delimiter);
        return value.substring(index + 1);
    }

    private static String loadResource(Class<?> contextClass, String resource) {
        URL url = Resources.getResource(contextClass, (String)resource);
        try {
            return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot find resource: " + String.valueOf(url), e);
        }
    }

    private class UnexpectedMatchReporter
    extends TreeScanner<Void, VisitorState> {
        private final ImmutableRangeMap<Integer, String> indexedMatches;

        UnexpectedMatchReporter(ImmutableRangeMap<Integer, String> indexedMatches) {
            this.indexedMatches = indexedMatches;
        }

        @Override
        public @Nullable Void visitMethod(MethodTree tree, VisitorState state) {
            if (!ASTHelpers.isGeneratedConstructor((MethodTree)tree)) {
                this.getRuleUnderTest(tree, state).ifPresent(ruleUnderTest -> this.reportUnexpectedMatches(tree, (String)ruleUnderTest, state));
            }
            return (Void)super.visitMethod(tree, state);
        }

        private void reportUnexpectedMatches(MethodTree tree, String ruleUnderTest, VisitorState state) {
            ImmutableListMultimap<Long, String> unexpectedMatchesByLineNumber = UnexpectedMatchReporter.getUnexpectedMatchesByLineNumber(this.getMatchesInTree(tree, state), ruleUnderTest, state);
            if (!unexpectedMatchesByLineNumber.isEmpty()) {
                RefasterRuleCollection.this.reportViolations(tree, "The following matches unexpectedly occurred in method `%s`".formatted(tree.getName()), (ImmutableSet<String>)((ImmutableSet)unexpectedMatchesByLineNumber.entries().stream().map(e -> "Rule `%s` matches on line %s, while it should match in a method named `test%s`.".formatted(e.getValue(), e.getKey(), e.getValue())).collect(ImmutableSet.toImmutableSet())), state);
            }
        }

        private Optional<String> getRuleUnderTest(MethodTree tree, VisitorState state) {
            String methodName = tree.getName().toString();
            if (methodName.startsWith(RefasterRuleCollection.TEST_METHOD_NAME_PREFIX)) {
                return Optional.of(methodName.substring(RefasterRuleCollection.TEST_METHOD_NAME_PREFIX.length()));
            }
            if (!"elidedTypesAndStaticImports".equals(methodName)) {
                state.reportMatch(RefasterRuleCollection.this.describeMatch(tree, (Fix)SuggestedFix.prefixWith((Tree)tree, (String)"/* ERROR: Method names should start with `test`. */%n".formatted(new Object[0]))));
            }
            return Optional.empty();
        }

        private ImmutableRangeMap<Integer, String> getMatchesInTree(MethodTree tree, VisitorState state) {
            int startPosition = ASTHelpers.getStartPosition((Tree)tree);
            int endPosition = state.getEndPosition((Tree)tree);
            Preconditions.checkState((startPosition != -1 && endPosition != -1 ? 1 : 0) != 0, (Object)"Cannot determine location of method in source code");
            return this.indexedMatches.subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)));
        }

        private static ImmutableListMultimap<Long, String> getUnexpectedMatchesByLineNumber(ImmutableRangeMap<Integer, String> matches, String ruleUnderTest, VisitorState state) {
            LineMap lineMap = state.getPath().getCompilationUnit().getLineMap();
            return (ImmutableListMultimap)matches.asMapOfRanges().entrySet().stream().filter(e -> !((String)e.getValue()).equals(ruleUnderTest)).collect(ImmutableListMultimap.toImmutableListMultimap(e -> lineMap.getLineNumber(((Integer)((Range)e.getKey()).lowerEndpoint()).intValue()), Map.Entry::getValue));
        }
    }
}

