/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster;

import com.google.errorprone.ErrorProneOptions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;

public final class ErrorProneFork {
    private static final Optional<Method> ERROR_PRONE_OPTIONS_IS_SUGGESTIONS_AS_WARNINGS_METHOD = Arrays.stream(ErrorProneOptions.class.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> "isSuggestionsAsWarnings".equals(m.getName())).findFirst();

    private ErrorProneFork() {
    }

    public static boolean isErrorProneForkAvailable() {
        return ERROR_PRONE_OPTIONS_IS_SUGGESTIONS_AS_WARNINGS_METHOD.isPresent();
    }

    public static boolean isSuggestionsAsWarningsEnabled(ErrorProneOptions options) {
        return ERROR_PRONE_OPTIONS_IS_SUGGESTIONS_AS_WARNINGS_METHOD.filter(m -> Boolean.TRUE.equals(ErrorProneFork.invoke(m, options, new Object[0]))).isPresent();
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Failed to invoke method '%s'", method), e);
        }
    }
}

