/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class RequiresComputation
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;

    public boolean matches(ExpressionTree expressionTree, VisitorState state) {
        return RequiresComputation.matches(expressionTree);
    }

    private static boolean matches(ExpressionTree expressionTree) {
        ExpressionTree expressionTree2 = expressionTree;
        Objects.requireNonNull(expressionTree2);
        ExpressionTree expressionTree3 = expressionTree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayAccessTree.class, LiteralTree.class, LambdaExpressionTree.class, IdentifierTree.class, MemberReferenceTree.class, MemberSelectTree.class, ParenthesizedTree.class, TypeCastTree.class, UnaryTree.class}, (Object)expressionTree3, n)) {
            case 0 -> {
                ArrayAccessTree arrayAccess = (ArrayAccessTree)expressionTree3;
                if (RequiresComputation.matches(arrayAccess.getExpression()) || RequiresComputation.matches(arrayAccess.getIndex())) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                LiteralTree literal = (LiteralTree)expressionTree3;
                yield false;
            }
            case 2 -> {
                LambdaExpressionTree lambdaExpression = (LambdaExpressionTree)expressionTree3;
                yield false;
            }
            case 3 -> {
                IdentifierTree identifier = (IdentifierTree)expressionTree3;
                yield false;
            }
            case 4 -> {
                MemberReferenceTree memberReference = (MemberReferenceTree)expressionTree3;
                yield RequiresComputation.matches(memberReference.getQualifierExpression());
            }
            case 5 -> {
                MemberSelectTree memberSelect = (MemberSelectTree)expressionTree3;
                yield RequiresComputation.matches(memberSelect.getExpression());
            }
            case 6 -> {
                ParenthesizedTree parenthesized = (ParenthesizedTree)expressionTree3;
                yield RequiresComputation.matches(parenthesized.getExpression());
            }
            case 7 -> {
                TypeCastTree typeCast = (TypeCastTree)expressionTree3;
                yield RequiresComputation.matches(typeCast.getExpression());
            }
            case 8 -> {
                UnaryTree unary = (UnaryTree)expressionTree3;
                yield RequiresComputation.matches(unary.getExpression());
            }
            default -> ASTHelpers.constValue((Tree)expressionTree) == null;
        };
    }
}

