/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Collection;

public final class ThrowsCheckedException
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;

    public boolean matches(ExpressionTree tree, VisitorState state) {
        if (tree instanceof LambdaExpressionTree) {
            return ThrowsCheckedException.throwsCheckedException((LambdaExpressionTree)tree, state);
        }
        if (tree instanceof MemberReferenceTree) {
            return ThrowsCheckedException.throwsCheckedException((MemberReferenceTree)tree, state);
        }
        Type type = ASTHelpers.getType((Tree)tree);
        return type != null && ThrowsCheckedException.throwsCheckedException(type, state);
    }

    private static boolean throwsCheckedException(LambdaExpressionTree tree, VisitorState state) {
        return ThrowsCheckedException.containsCheckedException((Collection<Type>)ASTHelpers.getThrownExceptions((Tree)tree.getBody(), (VisitorState)state), state);
    }

    private static boolean throwsCheckedException(MemberReferenceTree tree, VisitorState state) {
        return ThrowsCheckedException.containsCheckedException(ASTHelpers.getSymbol((MemberReferenceTree)tree).type.getThrownTypes(), state);
    }

    private static boolean throwsCheckedException(Type type, VisitorState state) {
        try {
            return ThrowsCheckedException.containsCheckedException(state.getTypes().findDescriptorType(type).getThrownTypes(), state);
        }
        catch (Types.FunctionDescriptorLookupError e) {
            return state.getTypes().directSupertypes(type).stream().anyMatch(t -> ThrowsCheckedException.throwsCheckedException(t, state));
        }
    }

    private static boolean containsCheckedException(Collection<Type> types, VisitorState state) {
        return types.stream().anyMatch(type -> ThrowsCheckedException.isCheckedException(type, state));
    }

    private static boolean isCheckedException(Type type, VisitorState state) {
        return !ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().runtimeExceptionType, (VisitorState)state) && !ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().errorType, (VisitorState)state);
    }
}

