/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;

public final class IsLikelyTrivialComputation
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;

    public boolean matches(ExpressionTree expressionTree, VisitorState state) {
        MethodInvocationTree methodInvocation;
        if (expressionTree instanceof MethodInvocationTree && (methodInvocation = (MethodInvocationTree)expressionTree).getArguments().isEmpty() && IsLikelyTrivialComputation.matches(methodInvocation.getMethodSelect())) {
            return true;
        }
        return IsLikelyTrivialComputation.matches(expressionTree);
    }

    private static boolean matches(ExpressionTree expressionTree) {
        if (expressionTree instanceof ArrayAccessTree) {
            return IsLikelyTrivialComputation.matches(((ArrayAccessTree)expressionTree).getExpression()) && IsLikelyTrivialComputation.matches(((ArrayAccessTree)expressionTree).getIndex());
        }
        if (expressionTree instanceof LiteralTree) {
            return true;
        }
        if (expressionTree instanceof LambdaExpressionTree) {
            return true;
        }
        if (expressionTree instanceof IdentifierTree) {
            return true;
        }
        if (expressionTree instanceof MemberReferenceTree) {
            return IsLikelyTrivialComputation.matches(((MemberReferenceTree)expressionTree).getQualifierExpression());
        }
        if (expressionTree instanceof MemberSelectTree) {
            return IsLikelyTrivialComputation.matches(((MemberSelectTree)expressionTree).getExpression());
        }
        if (expressionTree instanceof ParenthesizedTree) {
            return IsLikelyTrivialComputation.matches(((ParenthesizedTree)expressionTree).getExpression());
        }
        if (expressionTree instanceof TypeCastTree) {
            return IsLikelyTrivialComputation.matches(((TypeCastTree)expressionTree).getExpression());
        }
        if (expressionTree instanceof UnaryTree) {
            return IsLikelyTrivialComputation.matches(((UnaryTree)expressionTree).getExpression());
        }
        return false;
    }
}

