/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.plugin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.CompositeCodeTransformer;
import com.google.errorprone.refaster.RefasterRuleBuilderScanner;
import com.google.errorprone.refaster.annotation.BeforeTemplate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

final class RefasterRuleCompilerTaskListener
implements TaskListener {
    private final Context context;

    RefasterRuleCompilerTaskListener(Context context) {
        this.context = context;
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() != TaskEvent.Kind.ANALYZE || JavaCompiler.instance(this.context).errorCount() > 0) {
            return;
        }
        JCTree.JCClassDecl tree = JavacTrees.instance(this.context).getTree(taskEvent.getTypeElement());
        if (tree == null || !this.containsRefasterTemplates(tree)) {
            return;
        }
        ImmutableListMultimap<ClassTree, CodeTransformer> rules = this.compileRefasterTemplates(tree);
        for (Map.Entry rule : Multimaps.asMap(rules).entrySet()) {
            try {
                RefasterRuleCompilerTaskListener.outputCodeTransformers((List)rule.getValue(), this.getOutputFile(taskEvent, (ClassTree)rule.getKey()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to persist compiled Refaster templates", e);
            }
        }
    }

    private boolean containsRefasterTemplates(ClassTree tree) {
        return Boolean.TRUE.equals(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitAnnotation(AnnotationTree node, Void v) {
                Symbol sym = ASTHelpers.getSymbol((Tree)node);
                return sym != null && sym.getQualifiedName().contentEquals(BeforeTemplate.class.getCanonicalName()) || (Boolean)super.visitAnnotation(node, v) != false;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return Boolean.TRUE.equals(r1) || Boolean.TRUE.equals(r2);
            }
        }.scan(tree, null));
    }

    private ImmutableListMultimap<ClassTree, CodeTransformer> compileRefasterTemplates(ClassTree tree) {
        ArrayListMultimap rules = ArrayListMultimap.create();
        new TreeScanner<Void, Void>((ListMultimap)rules){
            final /* synthetic */ ListMultimap val$rules;
            {
                this.val$rules = listMultimap;
            }

            @Override
            @Nullable
            public Void visitClass(ClassTree node, Void v) {
                this.val$rules.putAll((Object)node, (Iterable)RefasterRuleBuilderScanner.extractRules((ClassTree)node, (Context)RefasterRuleCompilerTaskListener.this.context));
                return (Void)super.visitClass(node, null);
            }
        }.scan(tree, null);
        return ImmutableListMultimap.copyOf((Multimap)rules);
    }

    private FileObject getOutputFile(TaskEvent taskEvent, ClassTree tree) throws IOException {
        String packageName = Optional.ofNullable(ASTHelpers.getSymbol((ClassTree)tree)).map(ASTHelpers::enclosingPackage).map(Symbol.PackageSymbol::toString).orElse("");
        CharSequence className = Optional.ofNullable(ASTHelpers.getSymbol((ClassTree)tree)).map(RefasterRuleCompilerTaskListener::toSimpleFlatName).orElseGet(tree::getSimpleName);
        String relativeName = className + ".refaster";
        JavaFileManager fileManager = this.context.get(JavaFileManager.class);
        return fileManager.getFileForOutput(StandardLocation.CLASS_OUTPUT, packageName, relativeName, taskEvent.getSourceFile());
    }

    private static CharSequence toSimpleFlatName(Symbol.ClassSymbol classSymbol) {
        Name flatName = classSymbol.flatName();
        int lastDot = flatName.lastIndexOf((byte)46);
        return lastDot < 0 ? flatName : flatName.subSequence(lastDot + 1, flatName.length());
    }

    private static void outputCodeTransformers(List<CodeTransformer> rules, FileObject target) throws IOException {
        try (ObjectOutputStream output = new ObjectOutputStream(target.openOutputStream());){
            output.writeObject(CompositeCodeTransformer.compose(rules));
        }
    }
}

