/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.SourceCode;

public final class ConflictDetection {
    private ConflictDetection() {
    }

    public static Optional<String> findMethodRenameBlocker(Symbol.MethodSymbol method, String newName, VisitorState state) {
        if (ConflictDetection.isExistingMethodName(method.owner.type, newName, state)) {
            return Optional.of("a method named `%s` is already defined in this class or a supertype".formatted(newName));
        }
        if (ConflictDetection.isLocalMethodInvocation(newName, state)) {
            return Optional.of("another method named `%s` is in scope".formatted(newName));
        }
        if (!SourceCode.isValidIdentifier(newName)) {
            return Optional.of("`%s` is not a valid identifier".formatted(newName));
        }
        return Optional.empty();
    }

    private static boolean isExistingMethodName(Type clazz, String name, VisitorState state) {
        return ASTHelpers.matchingMethods((Name)state.getName(name), method -> true, (Type)clazz, (Types)state.getTypes()).findAny().isPresent();
    }

    private static boolean isLocalMethodInvocation(final String name, VisitorState state) {
        return Boolean.TRUE.equals(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitClass(ClassTree tree, @Nullable Void unused) {
                if (ASTHelpers.getSymbol((ClassTree)tree).isStatic()) {
                    return false;
                }
                return (Boolean)super.visitClass(tree, null);
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, @Nullable Void unused) {
                IdentifierTree identifier;
                ExpressionTree expressionTree = tree.getMethodSelect();
                return expressionTree instanceof IdentifierTree && name.contentEquals((identifier = (IdentifierTree)expressionTree).getName()) || (Boolean)super.visitMethodInvocation(tree, null) != false;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return Boolean.TRUE.equals(r1) || Boolean.TRUE.equals(r2);
            }
        }.scan(Objects.requireNonNull((ClassTree)state.findEnclosing(new Class[]{ClassTree.class}), "No enclosing class").getMembers(), null));
    }
}

