/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;

public final class MoreASTHelpers {
    private MoreASTHelpers() {
    }

    public static ImmutableList<MethodTree> findMethods(CharSequence methodName, VisitorState state) {
        ClassTree clazz = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Visited node is not enclosed by a class");
        return (ImmutableList)clazz.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(method -> method.getName().contentEquals(methodName)).collect(ImmutableList.toImmutableList());
    }

    public static boolean methodExistsInEnclosingClass(CharSequence methodName, VisitorState state) {
        return !MoreASTHelpers.findMethods(methodName, state).isEmpty();
    }

    public static Optional<MethodTree> findMethodExitedOnReturn(VisitorState state) {
        return Optional.ofNullable(state.findEnclosing(new Class[]{LambdaExpressionTree.class, MethodTree.class})).filter(MethodTree.class::isInstance).map(MethodTree.class::cast);
    }

    public static boolean areSameType(Tree treeA, Tree treeB, VisitorState state) {
        return ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)treeA), (Type)ASTHelpers.getType((Tree)treeB), (VisitorState)state);
    }

    public static boolean isStringTyped(Tree tree, VisitorState state) {
        return ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)state.getSymtab().stringType, (VisitorState)state);
    }
}

