/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;

public final class JavaKeywords {
    private static final ImmutableSet<String> BOOLEAN_AND_NULL_LITERALS = ImmutableSet.of((Object)"true", (Object)"false", (Object)"null");
    private static final ImmutableSet<String> RESERVED_KEYWORDS = ImmutableSet.of((Object)"_", (Object)"abstract", (Object)"assert", (Object)"boolean", (Object)"break", (Object)"byte", (Object[])new String[]{"case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"});
    private static final ImmutableSet<String> CONTEXTUAL_KEYWORDS = ImmutableSet.of((Object)"exports", (Object)"module", (Object)"non-sealed", (Object)"open", (Object)"opens", (Object)"permits", (Object[])new String[]{"provides", "record", "requires", "sealed", "to", "transitive", "uses", "var", "with", "yield"});
    private static final ImmutableSet<String> ALL_KEYWORDS = Sets.union(RESERVED_KEYWORDS, CONTEXTUAL_KEYWORDS).immutableCopy();

    private JavaKeywords() {
    }

    public static boolean isValidIdentifier(String str) {
        return !str.isEmpty() && !JavaKeywords.isReservedKeyword(str) && !BOOLEAN_AND_NULL_LITERALS.contains((Object)str) && Character.isJavaIdentifierStart(str.codePointAt(0)) && str.codePoints().skip(1L).allMatch(Character::isUnicodeIdentifierPart);
    }

    public static boolean isReservedKeyword(String str) {
        return RESERVED_KEYWORDS.contains((Object)str);
    }

    public static boolean isContextualKeyword(String str) {
        return CONTEXTUAL_KEYWORDS.contains((Object)str);
    }

    public static boolean isKeyword(String str) {
        return ALL_KEYWORDS.contains((Object)str);
    }
}

