/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.guidelines.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.refaster.Refaster;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="`Refaster#anyOf` should be passed at least two parameters", link="https://error-prone.picnic.tech/bugpatterns/RefasterAnyOfUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class RefasterAnyOfUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> REFASTER_ANY_OF = MethodMatchers.staticMethod().onClass(Refaster.class.getCanonicalName()).named("anyOf");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        int argumentCount = tree.getArguments().size();
        if (argumentCount > 1 || !REFASTER_ANY_OF.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (argumentCount == 0) {
            return this.describeMatch(tree);
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)SourceCode.treeToString((Tree)tree.getArguments().getFirst(), (VisitorState)state)));
    }
}

