/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.guidelines.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import javax.lang.model.element.Name;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Error Prone Support checks must reference their online documentation", link="https://error-prone.picnic.tech/bugpatterns/BugPatternLink", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class BugPatternLink
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ClassTree> IS_ERROR_PRONE_SUPPORT_CLASS = Matchers.packageStartsWith((String)"tech.picnic.errorprone");
    private static final Matcher<ExpressionTree> IS_LINK_TYPE_NONE = FieldMatchers.staticField((String)BugPattern.LinkType.class.getCanonicalName(), (String)"NONE");
    private static final Matcher<ExpressionTree> IS_BUG_PATTERNS_BASE_URL = FieldMatchers.staticField((String)"tech.picnic.errorprone.utils.Documentation", (String)"BUG_PATTERNS_BASE_URL");
    private static final MultiMatcher<ClassTree, AnnotationTree> HAS_BUG_PATTERN_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)BugPattern.class.getCanonicalName()));

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class) != null) {
            return Description.NO_MATCH;
        }
        if (!IS_ERROR_PRONE_SUPPORT_CLASS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ImmutableList bugPatternAnnotations = HAS_BUG_PATTERN_ANNOTATION.multiMatchResult((Tree)tree, state).matchingNodes();
        if (bugPatternAnnotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = (AnnotationTree)Iterables.getOnlyElement((Iterable)bugPatternAnnotations);
        if (BugPatternLink.isCompliant(annotation, tree.getSimpleName(), state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(annotation, (Fix)BugPatternLink.suggestFix(tree, state, annotation));
    }

    private static boolean isCompliant(AnnotationTree annotation, Name className, VisitorState state) {
        ExpressionTree linkType = AnnotationMatcherUtils.getArgument((AnnotationTree)annotation, (String)"linkType");
        if (IS_LINK_TYPE_NONE.matches((Tree)linkType, state)) {
            return true;
        }
        ExpressionTree link = AnnotationMatcherUtils.getArgument((AnnotationTree)annotation, (String)"link");
        if (!(link instanceof BinaryTree)) {
            return false;
        }
        BinaryTree binary = (BinaryTree)link;
        Verify.verify((binary.getKind() == Tree.Kind.PLUS ? 1 : 0) != 0, (String)"Unexpected binary operator", (Object[])new Object[0]);
        return IS_BUG_PATTERNS_BASE_URL.matches((Tree)binary.getLeftOperand(), state) && className.contentEquals((CharSequence)ASTHelpers.constValue((Tree)binary.getRightOperand(), String.class));
    }

    private static SuggestedFix suggestFix(ClassTree tree, VisitorState state, AnnotationTree annotation) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String linkPrefix = SuggestedFixes.qualifyStaticImport((String)"tech.picnic.errorprone.utils.Documentation.BUG_PATTERNS_BASE_URL", (SuggestedFix.Builder)fix, (VisitorState)state);
        fix.merge(SuggestedFixes.updateAnnotationArgumentValues((AnnotationTree)annotation, (VisitorState)state, (String)"link", (Collection)ImmutableList.of((Object)(linkPrefix + " + " + SourceCode.toStringConstantExpression((Object)tree.getSimpleName(), (VisitorState)state)))));
        String linkType = SuggestedFixes.qualifyStaticImport((String)(BugPattern.LinkType.class.getCanonicalName() + ".CUSTOM"), (SuggestedFix.Builder)fix, (VisitorState)state);
        fix.merge(SuggestedFixes.updateAnnotationArgumentValues((AnnotationTree)annotation, (VisitorState)state, (String)"linkType", (Collection)ImmutableList.of((Object)linkType)));
        return fix.build();
    }
}

