/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import java.util.Optional;
import tech.picnic.errorprone.bugpatterns.util.MoreASTHelpers;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Variable assignment is redundant; value can be returned directly", link="https://error-prone.picnic.tech/bugpatterns/DirectReturn", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class DirectReturn
extends BugChecker
implements BugChecker.BlockTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<StatementTree> VARIABLE_RETURN = Matchers.returnStatement((Matcher)Matchers.isVariable());
    private static final Matcher<ExpressionTree> MOCKITO_MOCK_OR_SPY_WITH_IMPLICIT_TYPE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.argument((int)0, (Matcher)Matchers.isSameType((String)Class.class.getName())))), Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf(new String[]{"mock", "spy"})});

    public Description matchBlock(BlockTree tree, VisitorState state) {
        List<? extends StatementTree> statements = tree.getStatements();
        if (statements.size() < 2) {
            return Description.NO_MATCH;
        }
        StatementTree finalStatement = statements.get(statements.size() - 1);
        if (!VARIABLE_RETURN.matches((Tree)finalStatement, state)) {
            return Description.NO_MATCH;
        }
        Symbol variableSymbol = ASTHelpers.getSymbol((Tree)((ReturnTree)finalStatement).getExpression());
        StatementTree precedingStatement = statements.get(statements.size() - 2);
        return DirectReturn.tryMatchAssignment(variableSymbol, precedingStatement).filter(resultExpr -> DirectReturn.canInlineToReturnStatement(resultExpr, state)).map(resultExpr -> this.describeMatch(precedingStatement, (Fix)SuggestedFix.builder().replace((Tree)precedingStatement, String.format("return %s;", SourceCode.treeToString(resultExpr, state))).delete((Tree)finalStatement).build())).orElse(Description.NO_MATCH);
    }

    private static Optional<ExpressionTree> tryMatchAssignment(Symbol targetSymbol, Tree tree) {
        if (tree instanceof ExpressionStatementTree) {
            return DirectReturn.tryMatchAssignment(targetSymbol, ((ExpressionStatementTree)tree).getExpression());
        }
        if (tree instanceof AssignmentTree) {
            AssignmentTree assignment = (AssignmentTree)tree;
            return targetSymbol.equals(ASTHelpers.getSymbol((Tree)assignment.getVariable())) ? Optional.of(assignment.getExpression()) : Optional.empty();
        }
        if (tree instanceof VariableTree) {
            VariableTree declaration = (VariableTree)tree;
            return declaration.getModifiers().getAnnotations().isEmpty() && targetSymbol.equals(ASTHelpers.getSymbol((VariableTree)declaration)) ? Optional.ofNullable(declaration.getInitializer()) : Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canInlineToReturnStatement(ExpressionTree expressionTree, VisitorState state) {
        return !MOCKITO_MOCK_OR_SPY_WITH_IMPLICIT_TYPE.matches((Tree)expressionTree, state) || MoreASTHelpers.findMethodExitedOnReturn(state).filter(m -> MoreASTHelpers.areSameType(expressionTree, m.getReturnType(), state)).isPresent();
    }
}

