/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.base.MoreObjects;
import com.google.errorprone.refaster.Refaster;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

final class NullRules {
    private NullRules() {
    }

    static final class NonNullFunction<T> {
        NonNullFunction() {
        }

        Predicate<T> before() {
            return o -> o != null;
        }

        Predicate<T> after() {
            return Objects::nonNull;
        }
    }

    static final class IsNullFunction<T> {
        IsNullFunction() {
        }

        Predicate<T> before() {
            return o -> o == null;
        }

        Predicate<T> after() {
            return Objects::isNull;
        }
    }

    static final class RequireNonNullElseGet<T, S extends T> {
        RequireNonNullElseGet() {
        }

        T before(T object, Supplier<S> supplier) {
            return Optional.ofNullable(object).orElseGet(supplier);
        }

        T after(T object, Supplier<S> supplier) {
            return Objects.requireNonNullElseGet(object, supplier);
        }
    }

    static final class RequireNonNullElse<T> {
        RequireNonNullElse() {
        }

        T before(T first, T second) {
            return (T)Refaster.anyOf((Object[])new Object[]{MoreObjects.firstNonNull(first, second), Optional.ofNullable(first).orElse(second)});
        }

        T after(T first, T second) {
            return Objects.requireNonNullElse(first, second);
        }
    }

    static final class IsNotNull {
        IsNotNull() {
        }

        boolean before(@Nullable Object object) {
            return Objects.nonNull(object);
        }

        boolean after(@Nullable Object object) {
            return object != null;
        }
    }

    static final class IsNull {
        IsNull() {
        }

        boolean before(@Nullable Object object) {
            return Objects.isNull(object);
        }

        boolean after(@Nullable Object object) {
            return object == null;
        }
    }
}

