/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.errorprone.refaster.Refaster;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectEnumerableAssert;
import org.assertj.core.api.OptionalDoubleAssert;
import org.assertj.core.api.OptionalIntAssert;
import org.assertj.core.api.OptionalLongAssert;

final class AssertJRules {
    private AssertJRules() {
    }

    static final class ObjectEnumerableIsSubsetOfFiveElements<S, T extends S> {
        ObjectEnumerableIsSubsetOfFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.isSubsetOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.isSubsetOf(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableIsSubsetOfFourElements<S, T extends S> {
        ObjectEnumerableIsSubsetOfFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.isSubsetOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.isSubsetOf(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableIsSubsetOfThreeElements<S, T extends S> {
        ObjectEnumerableIsSubsetOfThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.isSubsetOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.isSubsetOf(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableIsSubsetOfTwoElements<S, T extends S> {
        ObjectEnumerableIsSubsetOfTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.isSubsetOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.isSubsetOf(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableContainsOnlyFiveElements<S, T extends S> {
        ObjectEnumerableContainsOnlyFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.hasSameElementsAs((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsOnly(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableContainsOnlyFourElements<S, T extends S> {
        ObjectEnumerableContainsOnlyFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.hasSameElementsAs((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsOnly(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableContainsOnlyThreeElements<S, T extends S> {
        ObjectEnumerableContainsOnlyThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.hasSameElementsAs((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsOnly(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableContainsOnlyTwoElements<S, T extends S> {
        ObjectEnumerableContainsOnlyTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.hasSameElementsAs((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsOnly(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableDoesNotContainSequenceFiveElements<S, T extends S> {
        ObjectEnumerableDoesNotContainSequenceFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.doesNotContainSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.doesNotContainSequence(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableDoesNotContainSequenceFourElements<S, T extends S> {
        ObjectEnumerableDoesNotContainSequenceFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.doesNotContainSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.doesNotContainSequence(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableDoesNotContainSequenceThreeElements<S, T extends S> {
        ObjectEnumerableDoesNotContainSequenceThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.doesNotContainSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.doesNotContainSequence(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableDoesNotContainSequenceTwoElements<S, T extends S> {
        ObjectEnumerableDoesNotContainSequenceTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.doesNotContainSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.doesNotContainSequence(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableDoesNotContainFiveElements<S, T extends S> {
        ObjectEnumerableDoesNotContainFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.doesNotContainAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.doesNotContain(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableDoesNotContainFourElements<S, T extends S> {
        ObjectEnumerableDoesNotContainFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.doesNotContainAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.doesNotContain(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableDoesNotContainThreeElements<S, T extends S> {
        ObjectEnumerableDoesNotContainThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.doesNotContainAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.doesNotContain(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableDoesNotContainTwoElements<S, T extends S> {
        ObjectEnumerableDoesNotContainTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.doesNotContainAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.doesNotContain(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableContainsSubsequenceFiveElements<S, T extends S> {
        ObjectEnumerableContainsSubsequenceFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsSubsequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsSubsequence(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableContainsSubsequenceFourElements<S, T extends S> {
        ObjectEnumerableContainsSubsequenceFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsSubsequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsSubsequence(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableContainsSubsequenceThreeElements<S, T extends S> {
        ObjectEnumerableContainsSubsequenceThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsSubsequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsSubsequence(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableContainsSubsequenceTwoElements<S, T extends S> {
        ObjectEnumerableContainsSubsequenceTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsSubsequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsSubsequence(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableContainsSequenceFiveElements<S, T extends S> {
        ObjectEnumerableContainsSequenceFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsSequence(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableContainsSequenceFourElements<S, T extends S> {
        ObjectEnumerableContainsSequenceFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsSequence(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableContainsSequenceThreeElements<S, T extends S> {
        ObjectEnumerableContainsSequenceThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsSequence(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableContainsSequenceTwoElements<S, T extends S> {
        ObjectEnumerableContainsSequenceTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsSequence(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableContainsExactlyInAnyOrderFiveElements<S, T extends S> {
        ObjectEnumerableContainsExactlyInAnyOrderFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsExactlyInAnyOrderElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsExactlyInAnyOrder(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableContainsExactlyInAnyOrderFourElements<S, T extends S> {
        ObjectEnumerableContainsExactlyInAnyOrderFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsExactlyInAnyOrderElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsExactlyInAnyOrder(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableContainsExactlyInAnyOrderThreeElements<S, T extends S> {
        ObjectEnumerableContainsExactlyInAnyOrderThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsExactlyInAnyOrderElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsExactlyInAnyOrder(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableContainsExactlyInAnyOrderTwoElements<S, T extends S> {
        ObjectEnumerableContainsExactlyInAnyOrderTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsExactlyInAnyOrderElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsExactlyInAnyOrder(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableContainsExactlyFiveElements<S, T extends S> {
        ObjectEnumerableContainsExactlyFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsExactlyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsExactly(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableContainsExactlyFourElements<S, T extends S> {
        ObjectEnumerableContainsExactlyFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsExactlyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsExactly(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableContainsExactlyThreeElements<S, T extends S> {
        ObjectEnumerableContainsExactlyThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsExactlyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsExactly(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableContainsExactlyTwoElements<S, T extends S> {
        ObjectEnumerableContainsExactlyTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsExactlyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsExactly(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableContainsFiveElements<S, T extends S> {
        ObjectEnumerableContainsFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsAll((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.contains(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableContainsFourElements<S, T extends S> {
        ObjectEnumerableContainsFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsAll((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.contains(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableContainsThreeElements<S, T extends S> {
        ObjectEnumerableContainsThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsAll((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.contains(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableContainsTwoElements<S, T extends S> {
        ObjectEnumerableContainsTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsAll((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.contains(new Object[]{e1, e2});
        }
    }

    static final class ObjectEnumerableContainsAnyOfFiveElements<S, T extends S> {
        ObjectEnumerableContainsAnyOfFiveElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4, e5), Arrays.asList(e1, e2, e3, e4, e5), ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableMultiset.of(e1, e2, e3, e4, e5)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4, T e5) {
            return iterAssert.containsAnyOf(new Object[]{e1, e2, e3, e4, e5});
        }
    }

    static final class ObjectEnumerableContainsAnyOfFourElements<S, T extends S> {
        ObjectEnumerableContainsAnyOfFourElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3, e4), Arrays.asList(e1, e2, e3, e4), ImmutableSet.of(e1, e2, e3, e4), ImmutableMultiset.of(e1, e2, e3, e4)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3, T e4) {
            return iterAssert.containsAnyOf(new Object[]{e1, e2, e3, e4});
        }
    }

    static final class ObjectEnumerableContainsAnyOfThreeElements<S, T extends S> {
        ObjectEnumerableContainsAnyOfThreeElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2, e3), Arrays.asList(e1, e2, e3), ImmutableSet.of(e1, e2, e3), ImmutableMultiset.of(e1, e2, e3)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2, T e3) {
            return iterAssert.containsAnyOf(new Object[]{e1, e2, e3});
        }
    }

    static final class ObjectEnumerableContainsAnyOfTwoElements<S, T extends S> {
        ObjectEnumerableContainsAnyOfTwoElements() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(e1, e2), Arrays.asList(e1, e2), ImmutableSet.of(e1, e2), ImmutableMultiset.of(e1, e2)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T e1, T e2) {
            return iterAssert.containsAnyOf(new Object[]{e1, e2});
        }
    }

    static final class AssertThatPredicateRejects<T> {
        AssertThatPredicateRejects() {
        }

        void before(Predicate<T> predicate, T object) {
            Assertions.assertThat((boolean)predicate.test(object)).isFalse();
        }

        void after(Predicate<T> predicate, T object) {
            Assertions.assertThat(predicate).rejects(new Object[]{object});
        }
    }

    static final class AssertThatPredicateAccepts<T> {
        AssertThatPredicateAccepts() {
        }

        void before(Predicate<T> predicate, T object) {
            Assertions.assertThat((boolean)predicate.test(object)).isTrue();
        }

        void after(Predicate<T> predicate, T object) {
            Assertions.assertThat(predicate).accepts(new Object[]{object});
        }
    }

    static final class AssertThatStreamHasSize<T> {
        AssertThatStreamHasSize() {
        }

        void before(Stream<T> stream, int size) {
            Assertions.assertThat((long)stream.count()).isEqualTo((long)size);
        }

        void after(Stream<T> stream, int size) {
            Assertions.assertThat(stream).hasSize(size);
        }
    }

    static final class AssertThatStreamIsNotEmpty<S, T extends S> {
        AssertThatStreamIsNotEmpty() {
        }

        void before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector) {
            Assertions.assertThat(stream.collect(collector)).isNotEmpty();
        }

        void before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector) {
            Assertions.assertThat(stream.collect(collector)).isNotEmpty();
        }

        void after(Stream<S> stream) {
            Assertions.assertThat(stream).isNotEmpty();
        }
    }

    static final class AssertThatStreamIsEmpty<S, T extends S> {
        AssertThatStreamIsEmpty() {
        }

        void before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector) {
            Assertions.assertThat(stream.collect(collector)).isEmpty();
        }

        void before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector) {
            Assertions.assertThat(stream.collect(collector)).isEmpty();
        }

        void after(Stream<S> stream) {
            Assertions.assertThat(stream).isEmpty();
        }
    }

    static final class AssertThatStreamIsSubsetOfVarArgs<S, T extends S, U extends T> {
        AssertThatStreamIsSubsetOfVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U elements) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(Refaster.asVarargs(elements));
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).isSubsetOf(new Object[]{elements});
        }
    }

    static final class AssertThatStreamIsSubsetOf<S, T extends S, U extends T> {
        AssertThatStreamIsSubsetOf() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, Iterable<U> iterable) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(iterable);
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U[] iterable) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf((Object[])iterable);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(iterable);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, U[] iterable) {
            return (ListAssert)Assertions.assertThat(stream).isSubsetOf((Object[])iterable);
        }
    }

    static final class AssertThatStreamContainsOnlyVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsOnlyVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U elements) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsOnly(Refaster.asVarargs(elements));
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsOnly(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsOnly(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsOnly<S, T extends S, U extends T> {
        AssertThatStreamContainsOnly() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U[] array) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsOnly((Object[])array);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] array) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsOnly((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsOnly((Object[])array);
        }
    }

    static final class AssertThatStreamHasSameElementsAs<S, T extends S, U extends T> {
        AssertThatStreamHasSameElementsAs() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, Iterable<U> iterable) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).hasSameElementsAs(iterable);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).hasSameElementsAs(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).hasSameElementsAs(iterable);
        }
    }

    static final class AssertThatStreamDoesNotContainSequenceVarArgs<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainSequenceVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainSequence(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContainSequence(new Object[]{elements});
        }
    }

    static final class AssertThatStreamDoesNotContainSequence<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainSequence() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainSequence(iterable);
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainSequence((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContainSequence(iterable);
        }
    }

    static final class AssertThatStreamDoesNotContainVarArgs<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U elements) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain(Refaster.asVarargs(elements));
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContain(new Object[]{elements});
        }
    }

    static final class AssertThatStreamDoesNotContain<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContain() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U[] array) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain((Object[])array);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] array) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContain((Object[])array);
        }
    }

    static final class AssertThatStreamDoesNotContainAnyElementsOf<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainAnyElementsOf() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, Iterable<U> iterable) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContainAnyElementsOf(iterable);
        }
    }

    static final class AssertThatStreamContainsSubsequenceVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsSubsequenceVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSubsequence(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsSubsequence(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsSubsequence<S, T extends S, U extends T> {
        AssertThatStreamContainsSubsequence() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSubsequence(iterable);
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSubsequence((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsSubsequence(iterable);
        }
    }

    static final class AssertThatStreamContainsSequenceVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsSequenceVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSequence(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsSequence(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsSequence<S, T extends S, U extends T> {
        AssertThatStreamContainsSequence() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSequence(iterable);
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSequence((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsSequence(iterable);
        }
    }

    static final class AssertThatStreamContainsExactlyInAnyOrderVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyInAnyOrderVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyInAnyOrder(Refaster.asVarargs(elements));
        }

        AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, Collector<S, ?, ? extends Multiset<T>> collector, U elements) {
            return (AbstractCollectionAssert)Assertions.assertThat((Collection)((Collection)stream.collect(collector))).containsExactlyInAnyOrder(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyInAnyOrder(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsExactlyInAnyOrder<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyInAnyOrder() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] array) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyInAnyOrder((Object[])array);
        }

        AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, Collector<S, ?, ? extends Multiset<T>> collector, U[] array) {
            return (AbstractCollectionAssert)Assertions.assertThat((Collection)((Collection)stream.collect(collector))).containsExactlyInAnyOrder((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyInAnyOrder((Object[])array);
        }
    }

    static final class AssertThatStreamContainsExactlyInAnyOrderElementsOf<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyInAnyOrderElementsOf() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyInAnyOrderElementsOf(iterable);
        }

        AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, Collector<S, ?, ? extends Multiset<T>> collector, Iterable<U> iterable) {
            return (AbstractCollectionAssert)Assertions.assertThat((Collection)((Collection)stream.collect(collector))).containsExactlyInAnyOrderElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyInAnyOrderElementsOf(iterable);
        }
    }

    static final class AssertThatStreamContainsExactlyVarargs<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyVarargs() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactly(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsExactly(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsExactly<S, T extends S, U extends T> {
        AssertThatStreamContainsExactly() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] array) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactly((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsExactly((Object[])array);
        }
    }

    static final class AssertThatStreamContainsExactlyElementsOf<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyElementsOf() {
        }

        ListAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyElementsOf(iterable);
        }
    }

    static final class AssertThatStreamContainsVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U elements) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).contains(Refaster.asVarargs(elements));
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).contains(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).contains(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContains<S, T extends S, U extends T> {
        AssertThatStreamContains() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U[] array) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).contains((Object[])array);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] array) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).contains((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).contains((Object[])array);
        }
    }

    static final class AssertThatStreamContainsAll<S, T extends S, U extends T> {
        AssertThatStreamContainsAll() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, Iterable<U> iterable) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAll(iterable);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAll(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsAll(iterable);
        }
    }

    static final class AssertThatStreamContainsAnyOfVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsAnyOfVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U elements) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf(Refaster.asVarargs(elements));
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U elements) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsAnyOf(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsAnyOf<S, T extends S, U extends T> {
        AssertThatStreamContainsAnyOf() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, U[] array) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf((Object[])array);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, U[] array) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsAnyOf((Object[])array);
        }
    }

    static final class AssertThatStreamContainsAnyElementsOf<S, T extends S, U extends T> {
        AssertThatStreamContainsAnyElementsOf() {
        }

        IterableAssert<T> before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector, Iterable<U> iterable) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);
        }

        ListAssert<T> before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsAnyElementsOf(iterable);
        }
    }

    static final class AssertThatMapContainsEntry<K, V> {
        AssertThatMapContainsEntry() {
        }

        ObjectAssert<?> before(Map<K, V> map, K key, V value) {
            return (ObjectAssert)Assertions.assertThat(map.get(key)).isEqualTo(value);
        }

        MapAssert<K, V> after(Map<K, V> map, K key, V value) {
            return (MapAssert)Assertions.assertThat(map).containsEntry(key, value);
        }
    }

    static final class AssertThatMapDoesNotContainKey<K, V> {
        AssertThatMapDoesNotContainKey() {
        }

        AbstractBooleanAssert<?> before(Map<K, V> map, K key) {
            return Assertions.assertThat((boolean)map.containsKey(key)).isFalse();
        }

        MapAssert<K, V> after(Map<K, V> map, K key) {
            return (MapAssert)Assertions.assertThat(map).doesNotContainKey(key);
        }
    }

    static final class AssertThatMapContainsKey<K, V> {
        AssertThatMapContainsKey() {
        }

        AbstractBooleanAssert<?> before(Map<K, V> map, K key) {
            return Assertions.assertThat((boolean)map.containsKey(key)).isTrue();
        }

        MapAssert<K, V> after(Map<K, V> map, K key) {
            return (MapAssert)Assertions.assertThat(map).containsKey(key);
        }
    }

    static final class AssertThatMapsHaveSameSize<K, V> {
        AssertThatMapsHaveSameSize() {
        }

        AbstractAssert<?, ?> before(Map<K, V> map1, Map<K, V> map2) {
            return Assertions.assertThat(map1).hasSize(((Integer)Refaster.anyOf((Object[])new Integer[]{map2.size(), map2.keySet().size(), map2.values().size()})).intValue());
        }

        MapAssert<K, V> after(Map<K, V> map1, Map<K, V> map2) {
            return (MapAssert)Assertions.assertThat(map1).hasSameSizeAs(map2);
        }
    }

    static final class AssertThatMapHasSize<K, V> {
        AssertThatMapHasSize() {
        }

        AbstractAssert<?, ?> before(Map<K, V> map, int length) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat((int)map.size()).isEqualTo(length), Assertions.assertThat((Collection)((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values()}))).hasSize(length)});
        }

        MapAssert<K, V> after(Map<K, V> map, int length) {
            return (MapAssert)Assertions.assertThat(map).hasSize(length);
        }
    }

    static final class AssertThatMapIsNotEmpty2<K, V> {
        AssertThatMapIsNotEmpty2() {
        }

        AbstractAssert<?, ?> before(Map<K, V> map) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat((boolean)map.isEmpty()).isFalse(), Assertions.assertThat((int)map.size()).isNotEqualTo(0), Assertions.assertThat((int)map.size()).isPositive(), Assertions.assertThat((Collection)((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values()}))).isNotEmpty()});
        }

        MapAssert<K, V> after(Map<K, V> map) {
            return (MapAssert)Assertions.assertThat(map).isNotEmpty();
        }
    }

    static final class AssertThatMapIsNotEmpty<K, V> {
        AssertThatMapIsNotEmpty() {
        }

        AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert) {
            return mapAssert.isNotEqualTo(Refaster.anyOf((Object[])new Serializable[]{ImmutableMap.of(), ImmutableBiMap.of(), ImmutableSortedMap.of(), new HashMap(), new LinkedHashMap(), new TreeMap()}));
        }

        AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert) {
            return mapAssert.isNotEmpty();
        }
    }

    static final class AssertThatMapIsEmpty2<K, V> {
        AssertThatMapIsEmpty2() {
        }

        void before(Map<K, V> map) {
            Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat(map).hasSize(0), Assertions.assertThat((boolean)map.isEmpty()).isTrue(), Assertions.assertThat((int)map.size()).isEqualTo(0L), Assertions.assertThat((int)map.size()).isNotPositive()});
        }

        void before2(Map<K, V> map) {
            Assertions.assertThat((Collection)((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values()}))).isEmpty();
        }

        void after(Map<K, V> map) {
            Assertions.assertThat(map).isEmpty();
        }
    }

    static final class AssertThatMapIsEmpty<K, V> {
        AssertThatMapIsEmpty() {
        }

        void before(AbstractMapAssert<?, ?, K, V> mapAssert) {
            Refaster.anyOf((Object[])new AbstractMapAssert[]{mapAssert.containsExactlyEntriesOf((Map)Refaster.anyOf((Object[])new Serializable[]{ImmutableMap.of(), ImmutableBiMap.of(), ImmutableSortedMap.of(), new HashMap(), new LinkedHashMap(), new TreeMap()})), mapAssert.hasSameSizeAs((Map)Refaster.anyOf((Object[])new Serializable[]{ImmutableMap.of(), ImmutableBiMap.of(), ImmutableSortedMap.of(), new HashMap(), new LinkedHashMap(), new TreeMap()})), mapAssert.isEqualTo(Refaster.anyOf((Object[])new Serializable[]{ImmutableMap.of(), ImmutableBiMap.of(), ImmutableSortedMap.of(), new HashMap(), new LinkedHashMap(), new TreeMap()})), mapAssert.containsOnlyKeys((Iterable)Refaster.anyOf((Object[])new AbstractCollection[]{ImmutableList.of(), new ArrayList(), ImmutableSet.of(), new HashSet(), new LinkedHashSet(), ImmutableSortedSet.of(), new TreeSet(), ImmutableMultiset.of(), ImmutableSortedMultiset.of()})), mapAssert.containsExactly(new Map.Entry[0]), mapAssert.containsOnly(new Map.Entry[0]), mapAssert.containsOnlyKeys(new Object[0])});
        }

        void after(AbstractMapAssert<?, ?, K, V> mapAssert) {
            mapAssert.isEmpty();
        }
    }

    static final class AssertThatMultisetsAreEqual<S, T extends S> {
        AssertThatMultisetsAreEqual() {
        }

        AbstractCollectionAssert<?, ?, S, ?> before(Multiset<S> multiset1, Multiset<T> multiset2) {
            return (AbstractCollectionAssert)Assertions.assertThat(multiset1).isEqualTo(multiset2);
        }

        AbstractCollectionAssert<?, ?, S, ?> after(Multiset<S> multiset1, Multiset<T> multiset2) {
            return (AbstractCollectionAssert)Assertions.assertThat(multiset1).containsExactlyInAnyOrderElementsOf(multiset2);
        }
    }

    static final class AssertThatSetsAreEqual<S, T extends S> {
        AssertThatSetsAreEqual() {
        }

        AbstractCollectionAssert<?, ?, S, ?> before(Set<S> set1, Set<T> set2) {
            return (AbstractCollectionAssert)Refaster.anyOf((Object[])new AbstractCollectionAssert[]{(AbstractCollectionAssert)Assertions.assertThat(set1).isEqualTo(set2), (AbstractCollectionAssert)Assertions.assertThat(set1).containsExactlyInAnyOrderElementsOf(set2)});
        }

        AbstractCollectionAssert<?, ?, S, ?> after(Set<S> set1, Set<T> set2) {
            return (AbstractCollectionAssert)Assertions.assertThat(set1).hasSameElementsAs(set2);
        }
    }

    static final class AssertThatListsAreEqual<S, T extends S> {
        AssertThatListsAreEqual() {
        }

        ListAssert<S> before(List<S> list1, List<T> list2) {
            return Assertions.assertThat(list1).isEqualTo(list2);
        }

        ListAssert<S> after(List<S> list1, List<T> list2) {
            return (ListAssert)Assertions.assertThat(list1).containsExactlyElementsOf(list2);
        }
    }

    static final class AssertThatIterableHasOneComparableElementEqualTo<S extends Comparable<? super S>, T extends S> {
        AssertThatIterableHasOneComparableElementEqualTo() {
        }

        AbstractComparableAssert<?, S> before(Iterable<S> iterable, T element) {
            return (AbstractComparableAssert)Assertions.assertThat((Comparable)((Comparable)Iterables.getOnlyElement(iterable))).isEqualTo(element);
        }

        IterableAssert<S> after(Iterable<S> iterable, T element) {
            return (IterableAssert)Assertions.assertThat(iterable).containsExactly((Object[])new Comparable[]{element});
        }
    }

    static final class AssertThatIterableHasOneElementEqualTo<S, T extends S> {
        AssertThatIterableHasOneElementEqualTo() {
        }

        ObjectAssert<S> before(Iterable<S> iterable, T element) {
            return (ObjectAssert)Assertions.assertThat((Object)Iterables.getOnlyElement(iterable)).isEqualTo(element);
        }

        IterableAssert<S> after(Iterable<S> iterable, T element) {
            return (IterableAssert)Assertions.assertThat(iterable).containsExactly(new Object[]{element});
        }
    }

    static final class AssertThatIterableHasSize<E> {
        AssertThatIterableHasSize() {
        }

        AbstractIntegerAssert<?> before(Iterable<E> iterable, int length) {
            return Assertions.assertThat((int)Iterables.size(iterable)).isEqualTo(length);
        }

        AbstractIntegerAssert<?> before(Collection<E> iterable, int length) {
            return Assertions.assertThat((int)iterable.size()).isEqualTo(length);
        }

        IterableAssert<E> after(Iterable<E> iterable, int length) {
            return (IterableAssert)Assertions.assertThat(iterable).hasSize(length);
        }
    }

    static final class AssertThatIterableIsNotEmpty<E> {
        AssertThatIterableIsNotEmpty() {
        }

        AbstractAssert<?, ?> before(Iterable<E> iterable) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat((boolean)iterable.iterator().hasNext()).isTrue(), Assertions.assertThat((int)Iterables.size(iterable)).isNotEqualTo(0), Assertions.assertThat((int)Iterables.size(iterable)).isPositive()});
        }

        AbstractAssert<?, ?> before(Collection<E> iterable) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat((boolean)iterable.isEmpty()).isFalse(), Assertions.assertThat((int)iterable.size()).isNotEqualTo(0), Assertions.assertThat((int)iterable.size()).isPositive()});
        }

        IterableAssert<E> after(Iterable<E> iterable) {
            return (IterableAssert)Assertions.assertThat(iterable).isNotEmpty();
        }
    }

    static final class AssertThatIterableIsEmpty<E> {
        AssertThatIterableIsEmpty() {
        }

        void before(Iterable<E> iterable) {
            Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat(iterable).hasSize(0), Assertions.assertThat((boolean)iterable.iterator().hasNext()).isFalse(), Assertions.assertThat((int)Iterables.size(iterable)).isEqualTo(0L), Assertions.assertThat((int)Iterables.size(iterable)).isNotPositive()});
        }

        void before(Collection<E> iterable) {
            Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat((boolean)iterable.isEmpty()).isTrue(), Assertions.assertThat((int)iterable.size()).isEqualTo(0L), Assertions.assertThat((int)iterable.size()).isNotPositive()});
        }

        void after(Collection<E> iterable) {
            Assertions.assertThat(iterable).isEmpty();
        }
    }

    static final class ObjectEnumerableIsSubsetOfOneElement<S, T extends S> {
        ObjectEnumerableIsSubsetOfOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.isSubsetOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.isSubsetOf(new Object[]{element});
        }
    }

    static final class ObjectEnumerableContainsOneDistinctElement<S, T extends S> {
        ObjectEnumerableContainsOneDistinctElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.hasSameElementsAs((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)}));
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.containsOnly(new Object[]{element});
        }
    }

    static final class AssertThatSetContainsExactlyOneElement<S, T extends S> {
        AssertThatSetContainsExactlyOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(Set<S> set, T element) {
            return Assertions.assertThat(set).containsOnly(new Object[]{element});
        }

        ObjectEnumerableAssert<?, S> after(Set<S> set, T element) {
            return Assertions.assertThat(set).containsExactly(new Object[]{element});
        }
    }

    static final class ObjectEnumerableContainsExactlyOneElement<S, T extends S> {
        ObjectEnumerableContainsExactlyOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return (ObjectEnumerableAssert)Refaster.anyOf((Object[])new ObjectEnumerableAssert[]{iterAssert.containsExactlyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)})), iterAssert.containsExactlyInAnyOrderElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)}))});
        }

        ObjectEnumerableAssert<?, S> before2(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.containsExactlyInAnyOrder(new Object[]{element});
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.containsExactly(new Object[]{element});
        }
    }

    static final class ObjectEnumerableDoesNotContainOneElement<S, T extends S> {
        ObjectEnumerableDoesNotContainOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return (ObjectEnumerableAssert)Refaster.anyOf((Object[])new ObjectEnumerableAssert[]{iterAssert.doesNotContainAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)})), iterAssert.doesNotContainSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)})), iterAssert.doesNotContainSequence(new Object[]{element})});
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.doesNotContain(new Object[]{element});
        }
    }

    static final class ObjectEnumerableContainsOneElement<S, T extends S> {
        ObjectEnumerableContainsOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return (ObjectEnumerableAssert)Refaster.anyOf((Object[])new ObjectEnumerableAssert[]{iterAssert.containsAnyElementsOf((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)})), iterAssert.containsAnyOf(new Object[]{element}), iterAssert.containsAll((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)})), iterAssert.containsSequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)})), iterAssert.containsSequence(new Object[]{element}), iterAssert.containsSubsequence((Iterable)Refaster.anyOf((Object[])new Collection[]{ImmutableList.of(element), Arrays.asList(element), ImmutableSet.of(element), ImmutableMultiset.of(element)})), iterAssert.containsSubsequence(new Object[]{element})});
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.contains(new Object[]{element});
        }
    }

    static final class AssertThatObjectEnumerableIsEmpty<E> {
        AssertThatObjectEnumerableIsEmpty() {
        }

        void before(ObjectEnumerableAssert<?, E> enumAssert) {
            Refaster.anyOf((Object[])new ObjectEnumerableAssert[]{enumAssert.containsExactlyElementsOf((Iterable)Refaster.anyOf((Object[])new AbstractCollection[]{ImmutableList.of(), new ArrayList(), ImmutableSet.of(), new HashSet(), new LinkedHashSet(), ImmutableSortedSet.of(), new TreeSet(), ImmutableMultiset.of(), ImmutableSortedMultiset.of()})), enumAssert.containsExactlyInAnyOrderElementsOf((Iterable)Refaster.anyOf((Object[])new AbstractCollection[]{ImmutableList.of(), new ArrayList(), ImmutableSet.of(), new HashSet(), new LinkedHashSet(), ImmutableSortedSet.of(), new TreeSet(), ImmutableMultiset.of(), ImmutableSortedMultiset.of()})), enumAssert.hasSameElementsAs((Iterable)Refaster.anyOf((Object[])new AbstractCollection[]{ImmutableList.of(), new ArrayList(), ImmutableSet.of(), new HashSet(), new LinkedHashSet(), ImmutableSortedSet.of(), new TreeSet(), ImmutableMultiset.of(), ImmutableSortedMultiset.of()})), (ObjectEnumerableAssert)enumAssert.hasSameSizeAs((Iterable)Refaster.anyOf((Object[])new AbstractCollection[]{ImmutableList.of(), new ArrayList(), ImmutableSet.of(), new HashSet(), new LinkedHashSet(), ImmutableSortedSet.of(), new TreeSet(), ImmutableMultiset.of(), ImmutableSortedMultiset.of()})), enumAssert.isSubsetOf((Iterable)Refaster.anyOf((Object[])new AbstractCollection[]{ImmutableList.of(), new ArrayList(), ImmutableSet.of(), new HashSet(), new LinkedHashSet(), ImmutableSortedSet.of(), new TreeSet(), ImmutableMultiset.of(), ImmutableSortedMultiset.of()})), enumAssert.containsExactly(new Object[0]), enumAssert.containsExactlyInAnyOrder(new Object[0]), enumAssert.containsOnly(new Object[0]), enumAssert.isSubsetOf(new Object[0])});
        }

        void after(ObjectEnumerableAssert<?, E> enumAssert) {
            enumAssert.isEmpty();
        }
    }

    static final class AssertThatOptionalLong {
        AssertThatOptionalLong() {
        }

        AbstractLongAssert<?> before(OptionalLong optional, long expected) {
            return Assertions.assertThat((long)optional.getAsLong()).isEqualTo(expected);
        }

        OptionalLongAssert after(OptionalLong optional, long expected) {
            return (OptionalLongAssert)Assertions.assertThat((OptionalLong)optional).hasValue(expected);
        }
    }

    static final class AssertThatOptionalInt {
        AssertThatOptionalInt() {
        }

        AbstractIntegerAssert<?> before(OptionalInt optional, int expected) {
            return Assertions.assertThat((int)optional.getAsInt()).isEqualTo(expected);
        }

        OptionalIntAssert after(OptionalInt optional, int expected) {
            return (OptionalIntAssert)Assertions.assertThat((OptionalInt)optional).hasValue(expected);
        }
    }

    static final class AssertThatOptionalDouble {
        AssertThatOptionalDouble() {
        }

        AbstractDoubleAssert<?> before(OptionalDouble optional, double expected) {
            return Assertions.assertThat((double)optional.getAsDouble()).isEqualTo(expected);
        }

        OptionalDoubleAssert after(OptionalDouble optional, double expected) {
            return (OptionalDoubleAssert)Assertions.assertThat((OptionalDouble)optional).hasValue(expected);
        }
    }
}

