/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import javax.lang.model.element.AnnotationMirror;

@BugPattern(summary="Scheduled operation must start a new New Relic transaction", link="https://error-prone.picnic.tech/bugpatterns/ScheduledTransactionTrace", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class ScheduledTransactionTrace
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String TRACE_ANNOTATION_FQCN = "com.newrelic.api.agent.Trace";
    private static final Matcher<Tree> IS_SCHEDULED = Matchers.hasAnnotation((String)"org.springframework.scheduling.annotation.Scheduled");
    private static final MultiMatcher<Tree, AnnotationTree> TRACE_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"com.newrelic.api.agent.Trace"));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!IS_SCHEDULED.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ImmutableList traceAnnotations = TRACE_ANNOTATION.multiMatchResult((Tree)tree, state).matchingNodes();
        if (traceAnnotations.isEmpty()) {
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().addImport(TRACE_ANNOTATION_FQCN).prefixWith((Tree)tree, "@Trace(dispatcher = true)").build());
        }
        AnnotationTree traceAnnotation = (AnnotationTree)Iterables.getOnlyElement((Iterable)traceAnnotations);
        if (ScheduledTransactionTrace.isCorrectAnnotation(traceAnnotation)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(traceAnnotation, (Fix)SuggestedFixes.updateAnnotationArgumentValues((AnnotationTree)traceAnnotation, (VisitorState)state, (String)"dispatcher", (Collection)ImmutableList.of((Object)"true")).build());
    }

    private static boolean isCorrectAnnotation(AnnotationTree traceAnnotation) {
        return Boolean.TRUE.equals(AnnotationMirrors.getAnnotationValue((AnnotationMirror)ASTHelpers.getAnnotationMirror((AnnotationTree)traceAnnotation), (String)"dispatcher").getValue());
    }
}

