/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Stream;

final class ImmutableSetMultimapTemplates {
    private ImmutableSetMultimapTemplates() {
    }

    static final class TransformMultimapValuesToImmutableSetMultimap2<K, V1, V2> {
        TransformMultimapValuesToImmutableSetMultimap2() {
        }

        ImmutableSetMultimap<K, V2> before(Multimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableSetMultimap)((Map)Refaster.anyOf((Object[])new Map[]{multimap.asMap(), Multimaps.asMap(multimap)})).entrySet().stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(Map.Entry::getKey, e -> ((Collection)e.getValue()).stream().map(transformation)));
        }

        ImmutableSetMultimap<K, V2> before(ListMultimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableSetMultimap)Multimaps.asMap(multimap).entrySet().stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(transformation)));
        }

        ImmutableSetMultimap<K, V2> before(SetMultimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableSetMultimap)Multimaps.asMap(multimap).entrySet().stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().map(transformation)));
        }

        ImmutableSetMultimap<K, V2> before(SortedSetMultimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableSetMultimap)Multimaps.asMap(multimap).entrySet().stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(Map.Entry::getKey, e -> ((SortedSet)e.getValue()).stream().map(transformation)));
        }

        ImmutableSetMultimap<K, V2> after(Multimap<K, V1> multimap, Function<? super V1, ? extends V2> transformation) {
            return ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues(multimap, transformation));
        }
    }

    static abstract class TransformMultimapValuesToImmutableSetMultimap<K, V1, V2> {
        TransformMultimapValuesToImmutableSetMultimap() {
        }

        abstract V2 valueTransformation(V1 var1);

        ImmutableSetMultimap<K, V2> before(Multimap<K, V1> multimap) {
            return (ImmutableSetMultimap)multimap.entries().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, e -> this.valueTransformation(e.getValue())));
        }

        ImmutableSetMultimap<K, V2> after(Multimap<K, V1> multimap) {
            return ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues(multimap, e -> this.valueTransformation(e)));
        }
    }

    static abstract class StreamOfMapEntriesToImmutableSetMultimap<E, K, V> {
        StreamOfMapEntriesToImmutableSetMultimap() {
        }

        abstract K keyFunction(E var1);

        abstract V valueFunction(E var1);

        ImmutableSetMultimap<K, V> before(Stream<E> stream) {
            return (ImmutableSetMultimap)stream.map(e -> Map.entry(this.keyFunction(e), this.valueFunction(e))).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableSetMultimap<K, V> after(Stream<E> stream) {
            return (ImmutableSetMultimap)stream.collect(ImmutableSetMultimap.toImmutableSetMultimap(e -> this.keyFunction(e), e -> this.valueFunction(e)));
        }
    }

    static final class IterableToImmutableSetMultimap<K, V> {
        IterableToImmutableSetMultimap() {
        }

        ImmutableSetMultimap<K, V> before(Multimap<? extends K, ? extends V> iterable) {
            return (ImmutableSetMultimap)Refaster.anyOf((Object[])new ImmutableSetMultimap[]{ImmutableSetMultimap.copyOf((Iterable)iterable.entries()), ImmutableSetMultimap.builder().putAll(iterable).build()});
        }

        ImmutableSetMultimap<K, V> before(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableSetMultimap)Refaster.anyOf((Object[])new ImmutableSetMultimap[]{ImmutableSetMultimap.builder().putAll(iterable).build(), (ImmutableSetMultimap)Streams.stream(iterable).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue))});
        }

        ImmutableSetMultimap<K, V> before(Collection<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableSetMultimap)iterable.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableSetMultimap<K, V> after(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return ImmutableSetMultimap.copyOf(iterable);
        }
    }

    static final class EntryToImmutableSetMultimap<K, V> {
        EntryToImmutableSetMultimap() {
        }

        ImmutableSetMultimap<K, V> before(Map.Entry<? extends K, ? extends V> entry) {
            return (ImmutableSetMultimap)Refaster.anyOf((Object[])new ImmutableSetMultimap[]{ImmutableSetMultimap.builder().put(entry).build(), (ImmutableSetMultimap)Stream.of(entry).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue))});
        }

        ImmutableSetMultimap<K, V> after(Map.Entry<? extends K, ? extends V> entry) {
            return ImmutableSetMultimap.of(entry.getKey(), entry.getValue());
        }
    }

    static final class PairToImmutableSetMultimap<K, V> {
        PairToImmutableSetMultimap() {
        }

        ImmutableSetMultimap<K, V> before(K key, V value) {
            return ImmutableSetMultimap.builder().put(key, value).build();
        }

        ImmutableSetMultimap<K, V> after(K key, V value) {
            return ImmutableSetMultimap.of(key, value);
        }
    }

    static final class EmptyImmutableSetMultimap<K, V> {
        EmptyImmutableSetMultimap() {
        }

        ImmutableSetMultimap<K, V> before() {
            return ImmutableSetMultimap.builder().build();
        }

        ImmutableSetMultimap<K, V> after() {
            return ImmutableSetMultimap.of();
        }
    }

    static final class ImmutableSetMultimapBuilder<K, V> {
        ImmutableSetMultimapBuilder() {
        }

        ImmutableSetMultimap.Builder<K, V> before() {
            return new ImmutableSetMultimap.Builder();
        }

        ImmutableSetMultimap.Builder<K, V> after() {
            return ImmutableSetMultimap.builder();
        }
    }
}

