/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Stream;

final class ImmutableListMultimapTemplates {
    private ImmutableListMultimapTemplates() {
    }

    static final class TransformMultimapValuesToImmutableListMultimap2<K, V1, V2> {
        TransformMultimapValuesToImmutableListMultimap2() {
        }

        ImmutableListMultimap<K, V2> before(Multimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableListMultimap)((Map)Refaster.anyOf((Object[])new Map[]{multimap.asMap(), Multimaps.asMap(multimap)})).entrySet().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(Map.Entry::getKey, e -> ((Collection)e.getValue()).stream().map(transformation)));
        }

        ImmutableListMultimap<K, V2> before(ListMultimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableListMultimap)Multimaps.asMap(multimap).entrySet().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(transformation)));
        }

        ImmutableListMultimap<K, V2> before(SetMultimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableListMultimap)Multimaps.asMap(multimap).entrySet().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().map(transformation)));
        }

        ImmutableListMultimap<K, V2> before(SortedSetMultimap<K, V1> multimap, java.util.function.Function<? super V1, ? extends V2> transformation) {
            return (ImmutableListMultimap)Multimaps.asMap(multimap).entrySet().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(Map.Entry::getKey, e -> ((SortedSet)e.getValue()).stream().map(transformation)));
        }

        ImmutableListMultimap<K, V2> after(Multimap<K, V1> multimap, Function<? super V1, ? extends V2> transformation) {
            return ImmutableListMultimap.copyOf((Multimap)Multimaps.transformValues(multimap, transformation));
        }
    }

    static abstract class TransformMultimapValuesToImmutableListMultimap<K, V1, V2> {
        TransformMultimapValuesToImmutableListMultimap() {
        }

        abstract V2 valueTransformation(V1 var1);

        ImmutableListMultimap<K, V2> before(Multimap<K, V1> multimap) {
            return (ImmutableListMultimap)multimap.entries().stream().collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, e -> this.valueTransformation(e.getValue())));
        }

        ImmutableListMultimap<K, V2> after(Multimap<K, V1> multimap) {
            return ImmutableListMultimap.copyOf((Multimap)Multimaps.transformValues(multimap, v -> this.valueTransformation(v)));
        }
    }

    static final class IndexIterableToImmutableListMultimap<K, V> {
        IndexIterableToImmutableListMultimap() {
        }

        ImmutableListMultimap<K, V> before(Iterator<V> iterable, java.util.function.Function<? super V, ? extends K> keyFunction) {
            return (ImmutableListMultimap)Streams.stream(iterable).collect(ImmutableListMultimap.toImmutableListMultimap(keyFunction, (java.util.function.Function)((java.util.function.Function)Refaster.anyOf((Object[])new java.util.function.Function[]{java.util.function.Function.identity(), v -> v}))));
        }

        ImmutableListMultimap<K, V> before(Iterable<V> iterable, java.util.function.Function<? super V, ? extends K> keyFunction) {
            return (ImmutableListMultimap)Streams.stream(iterable).collect(ImmutableListMultimap.toImmutableListMultimap(keyFunction, (java.util.function.Function)((java.util.function.Function)Refaster.anyOf((Object[])new java.util.function.Function[]{java.util.function.Function.identity(), v -> v}))));
        }

        ImmutableListMultimap<K, V> before(Collection<V> iterable, java.util.function.Function<? super V, ? extends K> keyFunction) {
            return (ImmutableListMultimap)iterable.stream().collect(ImmutableListMultimap.toImmutableListMultimap(keyFunction, (java.util.function.Function)((java.util.function.Function)Refaster.anyOf((Object[])new java.util.function.Function[]{java.util.function.Function.identity(), v -> v}))));
        }

        ImmutableListMultimap<K, V> after(Iterable<V> iterable, Function<? super V, K> keyFunction) {
            return Multimaps.index(iterable, keyFunction);
        }
    }

    static abstract class StreamOfMapEntriesToImmutableListMultimap<E, K, V> {
        StreamOfMapEntriesToImmutableListMultimap() {
        }

        abstract K keyFunction(E var1);

        abstract V valueFunction(E var1);

        ImmutableListMultimap<K, V> before(Stream<E> stream) {
            return (ImmutableListMultimap)stream.map(e -> Map.entry(this.keyFunction(e), this.valueFunction(e))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableListMultimap<K, V> after(Stream<E> stream) {
            return (ImmutableListMultimap)stream.collect(ImmutableListMultimap.toImmutableListMultimap(e -> this.keyFunction(e), e -> this.valueFunction(e)));
        }
    }

    static final class IterableToImmutableListMultimap<K, V> {
        IterableToImmutableListMultimap() {
        }

        ImmutableMultimap<K, V> before(Multimap<? extends K, ? extends V> iterable) {
            return (ImmutableMultimap)Refaster.anyOf((Object[])new ImmutableMultimap[]{ImmutableListMultimap.copyOf((Iterable)iterable.entries()), ImmutableListMultimap.builder().putAll(iterable).build(), ImmutableMultimap.copyOf(iterable), ImmutableMultimap.copyOf((Iterable)iterable.entries())});
        }

        ImmutableMultimap<K, V> before(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableMultimap)Refaster.anyOf((Object[])new ImmutableMultimap[]{ImmutableListMultimap.builder().putAll(iterable).build(), (ImmutableMultimap)Streams.stream(iterable).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue)), ImmutableMultimap.copyOf(iterable)});
        }

        ImmutableListMultimap<K, V> before(Collection<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableListMultimap)iterable.stream().collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableListMultimap<K, V> after(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return ImmutableListMultimap.copyOf(iterable);
        }
    }

    static final class EntryToImmutableListMultimap<K, V> {
        EntryToImmutableListMultimap() {
        }

        ImmutableListMultimap<K, V> before(Map.Entry<? extends K, ? extends V> entry) {
            return (ImmutableListMultimap)Refaster.anyOf((Object[])new ImmutableListMultimap[]{ImmutableListMultimap.builder().put(entry).build(), (ImmutableListMultimap)Stream.of(entry).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue))});
        }

        ImmutableListMultimap<K, V> after(Map.Entry<? extends K, ? extends V> entry) {
            return ImmutableListMultimap.of(entry.getKey(), entry.getValue());
        }
    }

    static final class PairToImmutableListMultimap<K, V> {
        PairToImmutableListMultimap() {
        }

        ImmutableMultimap<K, V> before(K key, V value) {
            return (ImmutableMultimap)Refaster.anyOf((Object[])new ImmutableMultimap[]{ImmutableListMultimap.builder().put(key, value).build(), ImmutableMultimap.of(key, value)});
        }

        ImmutableListMultimap<K, V> after(K key, V value) {
            return ImmutableListMultimap.of(key, value);
        }
    }

    static final class EmptyImmutableListMultimap<K, V> {
        EmptyImmutableListMultimap() {
        }

        ImmutableMultimap<K, V> before() {
            return (ImmutableMultimap)Refaster.anyOf((Object[])new ImmutableMultimap[]{ImmutableListMultimap.builder().build(), ImmutableMultimap.of()});
        }

        ImmutableListMultimap<K, V> after() {
            return ImmutableListMultimap.of();
        }
    }

    static final class ImmutableListMultimapBuilder<K, V> {
        ImmutableListMultimapBuilder() {
        }

        ImmutableMultimap.Builder<K, V> before() {
            return (ImmutableMultimap.Builder)Refaster.anyOf((Object[])new ImmutableMultimap.Builder[]{new ImmutableListMultimap.Builder(), new ImmutableMultimap.Builder(), ImmutableMultimap.builder()});
        }

        ImmutableListMultimap.Builder<K, V> after() {
            return ImmutableListMultimap.builder();
        }
    }
}

