/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Make sure all `@RequestMapping` method parameters are annotated", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class RequestMappingAnnotation
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String ANN_PACKAGE_PREFIX = "org.springframework.web.bind.annotation.";
    private static final Matcher<Tree> HAS_MAPPING_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.springframework.web.bind.annotation.DeleteMapping"), Matchers.isType((String)"org.springframework.web.bind.annotation.GetMapping"), Matchers.isType((String)"org.springframework.web.bind.annotation.PatchMapping"), Matchers.isType((String)"org.springframework.web.bind.annotation.PostMapping"), Matchers.isType((String)"org.springframework.web.bind.annotation.PutMapping"), Matchers.isType((String)"org.springframework.web.bind.annotation.RequestMapping")}));
    private static final Matcher<MethodTree> LACKS_PARAMETER_ANNOTATION = Matchers.not((Matcher)Matchers.methodHasParameters((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.ALL, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.springframework.web.bind.annotation.PathVariable"), Matchers.isType((String)"org.springframework.web.bind.annotation.RequestAttribute"), Matchers.isType((String)"org.springframework.web.bind.annotation.RequestBody"), Matchers.isType((String)"org.springframework.web.bind.annotation.RequestHeader"), Matchers.isType((String)"org.springframework.web.bind.annotation.RequestParam"), Matchers.isType((String)"org.springframework.web.bind.annotation.RequestPart")})), Matchers.isSameType((String)"java.io.InputStream"), Matchers.isSameType((String)"java.time.ZoneId"), Matchers.isSameType((String)"java.util.Locale"), Matchers.isSameType((String)"java.util.TimeZone"), Matchers.isSameType((String)"javax.servlet.http.HttpServletRequest"), Matchers.isSameType((String)"javax.servlet.http.HttpServletResponse"), Matchers.isSameType((String)"org.springframework.http.HttpMethod"), Matchers.isSameType((String)"org.springframework.web.context.request.NativeWebRequest"), Matchers.isSameType((String)"org.springframework.web.context.request.WebRequest"), Matchers.isSameType((String)"org.springframework.web.server.ServerWebExchange"), Matchers.isSameType((String)"org.springframework.web.util.UriBuilder"), Matchers.isSameType((String)"org.springframework.web.util.UriComponentsBuilder")})));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return HAS_MAPPING_ANNOTATION.matches((Tree)tree, state) && LACKS_PARAMETER_ANNOTATION.matches((Tree)tree, state) ? this.buildDescription(tree).setMessage("Not all parameters of this request mapping method are annotated; this may be a mistake. If the unannotated parameters represent query string parameters, annotate them with `@RequestParam`.").build() : Description.NO_MATCH;
    }
}

