/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.VerifyException;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Ensure invocations of `Comparator#comparing{,Double,Int,Long}` match the return type of the provided function", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"})
@AutoService(value={BugChecker.class})
public final class PrimitiveComparison
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> STATIC_COMPARISON_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(Comparator.class.getName()).namedAnyOf(new String[]{"comparingInt", "comparingLong", "comparingDouble"}), MethodMatchers.staticMethod().onClass(Comparator.class.getName()).named("comparing").withParameters(Function.class.getName(), new String[0])});
    private static final Matcher<ExpressionTree> INSTANCE_COMPARISON_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(Comparator.class.getName()).namedAnyOf(new String[]{"thenComparingInt", "thenComparingLong", "thenComparingDouble"}), MethodMatchers.instanceMethod().onDescendantOf(Comparator.class.getName()).named("thenComparing").withParameters(Function.class.getName(), new String[0])});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        boolean isStatic = STATIC_COMPARISON_METHOD.matches((Tree)tree, state);
        if (!isStatic && !INSTANCE_COMPARISON_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return PrimitiveComparison.getPotentiallyBoxedReturnType(tree.getArguments().get(0)).flatMap(cmpType -> PrimitiveComparison.attemptMethodInvocationReplacement(tree, cmpType, isStatic, state)).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static Optional<Fix> attemptMethodInvocationReplacement(MethodInvocationTree tree, Type cmpType, boolean isStatic, VisitorState state) {
        String preferredMethodName;
        String actualMethodName = ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString();
        if (actualMethodName.equals(preferredMethodName = PrimitiveComparison.getPreferredMethod(cmpType, isStatic, state))) {
            return Optional.empty();
        }
        return Optional.of(PrimitiveComparison.suggestFix(tree, PrimitiveComparison.prefixTypeArgumentsIfRelevant(preferredMethodName, tree, cmpType, state), state));
    }

    private static String prefixTypeArgumentsIfRelevant(String preferredMethodName, MethodInvocationTree tree, Type cmpType, VisitorState state) {
        if (tree.getTypeArguments().isEmpty() || preferredMethodName.startsWith("then")) {
            return preferredMethodName;
        }
        String typeArguments = Stream.concat(Stream.of(SourceCode.treeToString(tree.getTypeArguments().get(0), state)), Stream.of(cmpType.tsym.getSimpleName()).filter(u -> "comparing".equals(preferredMethodName))).collect(Collectors.joining(", ", "<", ">"));
        return typeArguments + preferredMethodName;
    }

    private static String getPreferredMethod(Type cmpType, boolean isStatic, VisitorState state) {
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        if (types.isSubtype(cmpType, symtab.intType)) {
            return isStatic ? "comparingInt" : "thenComparingInt";
        }
        if (types.isSubtype(cmpType, symtab.longType)) {
            return isStatic ? "comparingLong" : "thenComparingLong";
        }
        if (types.isSubtype(cmpType, symtab.doubleType)) {
            return isStatic ? "comparingDouble" : "thenComparingDouble";
        }
        return isStatic ? "comparing" : "thenComparing";
    }

    private static Optional<Type> getPotentiallyBoxedReturnType(ExpressionTree tree) {
        switch (tree.getKind()) {
            case LAMBDA_EXPRESSION: {
                return Optional.ofNullable(ASTHelpers.getType((Tree)((LambdaExpressionTree)tree).getBody()));
            }
            case MEMBER_REFERENCE: {
                Type subType2 = ((JCTree.JCMemberReference)tree).referentType;
                return Optional.of(subType2.getReturnType());
            }
        }
        return Optional.empty();
    }

    private static Fix suggestFix(MethodInvocationTree tree, String preferredMethodName, VisitorState state) {
        ExpressionTree expr = tree.getMethodSelect();
        switch (expr.getKind()) {
            case IDENTIFIER: {
                return SuggestedFix.builder().addStaticImport(Comparator.class.getName() + "." + preferredMethodName).replace((Tree)expr, preferredMethodName).build();
            }
            case MEMBER_SELECT: {
                MemberSelectTree ms = (MemberSelectTree)tree.getMethodSelect();
                return SuggestedFix.replace((Tree)ms, (String)(SourceCode.treeToString(ms.getExpression(), state) + "." + preferredMethodName));
            }
        }
        throw new VerifyException("Unexpected type of expression: " + expr.getKind());
    }
}

