/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Map;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

@BugPattern(summary="`JsonCreator.Mode` should be set for single-argument creators", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class AmbiguousJsonCreator
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<AnnotationTree> IS_JSON_CREATOR_ANNOTATION = Matchers.isType((String)"com.fasterxml.jackson.annotation.JsonCreator");

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!IS_JSON_CREATOR_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ClassTree clazz = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        if (clazz == null || clazz.getKind() != Tree.Kind.ENUM) {
            return Description.NO_MATCH;
        }
        MethodTree method = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
        if (method == null || method.getParameters().size() != 1) {
            return Description.NO_MATCH;
        }
        boolean customMode = ASTHelpers.getAnnotationMirror((AnnotationTree)tree).getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("mode")).map(Map.Entry::getValue).map(AnnotationValue::getValue).filter(Symbol.VarSymbol.class::isInstance).map(Symbol.VarSymbol.class::cast).anyMatch(varSymbol -> !((Name)varSymbol.getSimpleName()).contentEquals("DEFAULT"));
        return customMode ? Description.NO_MATCH : this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)"@JsonCreator(mode = JsonCreator.Mode.DELEGATING)"));
    }
}

