/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Multiset;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectEnumerableAssert;
import org.assertj.core.api.OptionalDoubleAssert;
import org.assertj.core.api.OptionalIntAssert;
import org.assertj.core.api.OptionalLongAssert;

final class AssertJRules {
    private AssertJRules() {
    }

    static final class AssertThatPredicateRejects<T> {
        AssertThatPredicateRejects() {
        }

        void before(Predicate<T> predicate, T object) {
            Assertions.assertThat((boolean)predicate.test(object)).isFalse();
        }

        void after(Predicate<T> predicate, T object) {
            Assertions.assertThat(predicate).rejects(new Object[]{object});
        }
    }

    static final class AssertThatPredicateAccepts<T> {
        AssertThatPredicateAccepts() {
        }

        void before(Predicate<T> predicate, T object) {
            Assertions.assertThat((boolean)predicate.test(object)).isTrue();
        }

        void after(Predicate<T> predicate, T object) {
            Assertions.assertThat(predicate).accepts(new Object[]{object});
        }
    }

    static final class AssertThatStreamIsSubsetOfVarArgs<S, T extends S, U extends T> {
        AssertThatStreamIsSubsetOfVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(Refaster.asVarargs(elements));
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U elements, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(Refaster.asVarargs(elements));
        }

        ListAssert<T> before3(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).isSubsetOf(new Object[]{elements});
        }
    }

    static final class AssertThatStreamIsSubsetOf<S, T extends S, U extends T> {
        AssertThatStreamIsSubsetOf() {
        }

        IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(iterable);
        }

        IterableAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf((Object[])iterable);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(iterable);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf((Object[])iterable);
        }

        ListAssert<T> before3(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf(iterable);
        }

        ListAssert<T> before3(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).isSubsetOf((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, U[] iterable) {
            return (ListAssert)Assertions.assertThat(stream).isSubsetOf((Object[])iterable);
        }
    }

    static final class AssertThatStreamContainsOnlyVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsOnlyVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsOnly(Refaster.asVarargs(elements));
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U elements, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).containsOnly(Refaster.asVarargs(elements));
        }

        ListAssert<T> before3(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsOnly(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsOnly(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsOnly<S, T extends S, U extends T> {
        AssertThatStreamContainsOnly() {
        }

        IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsOnly((Object[])array);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).containsOnly((Object[])array);
        }

        ListAssert<T> before3(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsOnly((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsOnly((Object[])array);
        }
    }

    static final class AssertThatStreamHasSameElementsAs<S, T extends S, U extends T> {
        AssertThatStreamHasSameElementsAs() {
        }

        IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).hasSameElementsAs(iterable);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).hasSameElementsAs(iterable);
        }

        ListAssert<T> before3(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).hasSameElementsAs(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).hasSameElementsAs(iterable);
        }
    }

    static final class AssertThatStreamDoesNotContainSequenceVarArgs<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainSequenceVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainSequence(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContainSequence(new Object[]{elements});
        }
    }

    static final class AssertThatStreamDoesNotContainSequence<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainSequence() {
        }

        ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainSequence(iterable);
        }

        ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainSequence((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContainSequence(iterable);
        }
    }

    static final class AssertThatStreamDoesNotContainVarArgs<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain(Refaster.asVarargs(elements));
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U elements, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain(Refaster.asVarargs(elements));
        }

        ListAssert<T> before3(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContain(new Object[]{elements});
        }
    }

    static final class AssertThatStreamDoesNotContain<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContain() {
        }

        IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain((Object[])array);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain((Object[])array);
        }

        ListAssert<T> before3(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContain((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContain((Object[])array);
        }
    }

    static final class AssertThatStreamDoesNotContainAnyElementsOf<S, T extends S, U extends T> {
        AssertThatStreamDoesNotContainAnyElementsOf() {
        }

        IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);
        }

        ListAssert<T> before3(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).doesNotContainAnyElementsOf(iterable);
        }
    }

    static final class AssertThatStreamContainsSubsequenceVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsSubsequenceVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSubsequence(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsSubsequence(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsSubsequence<S, T extends S, U extends T> {
        AssertThatStreamContainsSubsequence() {
        }

        ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSubsequence(iterable);
        }

        ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSubsequence((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsSubsequence(iterable);
        }
    }

    static final class AssertThatStreamContainsSequenceVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsSequenceVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSequence(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsSequence(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsSequence<S, T extends S, U extends T> {
        AssertThatStreamContainsSequence() {
        }

        ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSequence(iterable);
        }

        ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsSequence((Object[])iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsSequence(iterable);
        }
    }

    static final class AssertThatStreamContainsExactlyInAnyOrderVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyInAnyOrderVarArgs() {
        }

        ListAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyInAnyOrder(Refaster.asVarargs(elements));
        }

        AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, U elements, Collector<S, ?, ? extends Multiset<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat((Collection)((Collection)stream.collect(collector))).containsExactlyInAnyOrder(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyInAnyOrder(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsExactlyInAnyOrder<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyInAnyOrder() {
        }

        ListAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyInAnyOrder((Object[])array);
        }

        AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends Multiset<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat((Collection)((Collection)stream.collect(collector))).containsExactlyInAnyOrder((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyInAnyOrder((Object[])array);
        }
    }

    static final class AssertThatStreamContainsExactlyInAnyOrderElementsOf<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyInAnyOrderElementsOf() {
        }

        ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyInAnyOrderElementsOf(iterable);
        }

        AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Multiset<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat((Collection)((Collection)stream.collect(collector))).containsExactlyInAnyOrderElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyInAnyOrderElementsOf(iterable);
        }
    }

    static final class AssertThatStreamContainsExactlyVarargs<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyVarargs() {
        }

        ListAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactly(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsExactly(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsExactly<S, T extends S, U extends T> {
        AssertThatStreamContainsExactly() {
        }

        ListAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactly((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsExactly((Object[])array);
        }
    }

    static final class AssertThatStreamContainsExactlyElementsOf<S, T extends S, U extends T> {
        AssertThatStreamContainsExactlyElementsOf() {
        }

        ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsExactlyElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsExactlyElementsOf(iterable);
        }
    }

    static final class AssertThatStreamContainsVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).contains(Refaster.asVarargs(elements));
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U elements, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).contains(Refaster.asVarargs(elements));
        }

        ListAssert<T> before3(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).contains(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).contains(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContains<S, T extends S, U extends T> {
        AssertThatStreamContains() {
        }

        IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).contains((Object[])array);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).contains((Object[])array);
        }

        ListAssert<T> before3(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).contains((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).contains((Object[])array);
        }
    }

    static final class AssertThatStreamContainsAll<S, T extends S, U extends T> {
        AssertThatStreamContainsAll() {
        }

        IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAll(iterable);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).containsAll(iterable);
        }

        ListAssert<T> before3(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAll(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsAll(iterable);
        }
    }

    static final class AssertThatStreamContainsAnyOfVarArgs<S, T extends S, U extends T> {
        AssertThatStreamContainsAnyOfVarArgs() {
        }

        IterableAssert<T> before(Stream<S> stream, U elements, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf(Refaster.asVarargs(elements));
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U elements, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf(Refaster.asVarargs(elements));
        }

        ListAssert<T> before3(Stream<S> stream, U elements, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf(Refaster.asVarargs(elements));
        }

        ListAssert<S> after(Stream<S> stream, U elements) {
            return (ListAssert)Assertions.assertThat(stream).containsAnyOf(new Object[]{elements});
        }
    }

    static final class AssertThatStreamContainsAnyOf<S, T extends S, U extends T> {
        AssertThatStreamContainsAnyOf() {
        }

        IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf((Object[])array);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf((Object[])array);
        }

        ListAssert<T> before3(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAnyOf((Object[])array);
        }

        ListAssert<S> after(Stream<S> stream, U[] array) {
            return (ListAssert)Assertions.assertThat(stream).containsAnyOf((Object[])array);
        }
    }

    static final class AssertThatStreamContainsAnyElementsOf<S, T extends S, U extends T> {
        AssertThatStreamContainsAnyElementsOf() {
        }

        IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {
            return (IterableAssert)Assertions.assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);
        }

        AbstractCollectionAssert<?, Collection<? extends T>, T, ObjectAssert<T>> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Collection<T>> collector) {
            return (AbstractCollectionAssert)Assertions.assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);
        }

        ListAssert<T> before3(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {
            return (ListAssert)Assertions.assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);
        }

        ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {
            return (ListAssert)Assertions.assertThat(stream).containsAnyElementsOf(iterable);
        }
    }

    static final class AssertThatMapContainsEntry<K, V> {
        AssertThatMapContainsEntry() {
        }

        ObjectAssert<V> before(Map<K, V> map, K key, V value) {
            return (ObjectAssert)Assertions.assertThat(map.get(key)).isEqualTo(value);
        }

        MapAssert<K, V> after(Map<K, V> map, K key, V value) {
            return (MapAssert)Assertions.assertThat(map).containsEntry(key, value);
        }
    }

    static final class AssertThatMultisetsAreEqual<S, T extends S> {
        AssertThatMultisetsAreEqual() {
        }

        AbstractCollectionAssert<?, ?, S, ?> before(Multiset<S> multiset1, Iterable<T> multiset2) {
            return (AbstractCollectionAssert)Assertions.assertThat(multiset1).isEqualTo(multiset2);
        }

        AbstractCollectionAssert<?, ?, S, ?> after(Multiset<S> multiset1, Iterable<T> multiset2) {
            return (AbstractCollectionAssert)Assertions.assertThat(multiset1).containsExactlyInAnyOrderElementsOf(multiset2);
        }
    }

    static final class AssertThatSetsAreEqual<S, T extends S> {
        AssertThatSetsAreEqual() {
        }

        AbstractCollectionAssert<?, ?, S, ?> before(Set<S> set1, Iterable<T> set2) {
            return (AbstractCollectionAssert)Refaster.anyOf((Object[])new AbstractCollectionAssert[]{(AbstractCollectionAssert)Assertions.assertThat(set1).isEqualTo(set2), (AbstractCollectionAssert)Assertions.assertThat(set1).containsExactlyInAnyOrderElementsOf(set2)});
        }

        AbstractCollectionAssert<?, ?, S, ?> after(Set<S> set1, Iterable<T> set2) {
            return (AbstractCollectionAssert)Assertions.assertThat(set1).hasSameElementsAs(set2);
        }
    }

    static final class AssertThatListsAreEqual<S, T extends S> {
        AssertThatListsAreEqual() {
        }

        ListAssert<S> before(List<S> list1, Iterable<T> list2) {
            return Assertions.assertThat(list1).isEqualTo(list2);
        }

        ListAssert<S> after(List<S> list1, Iterable<T> list2) {
            return (ListAssert)Assertions.assertThat(list1).containsExactlyElementsOf(list2);
        }
    }

    static final class AssertThatSetContainsExactlyOneElement<S, T extends S> {
        AssertThatSetContainsExactlyOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(Set<S> set, T element) {
            return Assertions.assertThat(set).containsOnly(new Object[]{element});
        }

        ObjectEnumerableAssert<?, S> after(Set<S> set, T element) {
            return Assertions.assertThat(set).containsExactly(new Object[]{element});
        }
    }

    static final class ObjectEnumerableContainsExactlyOneElement<S, T extends S> {
        ObjectEnumerableContainsExactlyOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.containsExactlyInAnyOrder(new Object[]{element});
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.containsExactly(new Object[]{element});
        }
    }

    static final class ObjectEnumerableDoesNotContainOneElement<S, T extends S> {
        ObjectEnumerableDoesNotContainOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.doesNotContainSequence(new Object[]{element});
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.doesNotContain(new Object[]{element});
        }
    }

    static final class ObjectEnumerableContainsOneElement<S, T extends S> {
        ObjectEnumerableContainsOneElement() {
        }

        ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return (ObjectEnumerableAssert)Refaster.anyOf((Object[])new ObjectEnumerableAssert[]{iterAssert.containsAnyOf(new Object[]{element}), iterAssert.containsSequence(new Object[]{element}), iterAssert.containsSubsequence(new Object[]{element})});
        }

        ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {
            return iterAssert.contains(new Object[]{element});
        }
    }

    static final class AssertThatOptionalLong {
        AssertThatOptionalLong() {
        }

        AbstractLongAssert<?> before(OptionalLong optional, long expected) {
            return Assertions.assertThat((long)optional.getAsLong()).isEqualTo(expected);
        }

        OptionalLongAssert after(OptionalLong optional, long expected) {
            return (OptionalLongAssert)Assertions.assertThat((OptionalLong)optional).hasValue(expected);
        }
    }

    static final class AssertThatOptionalInt {
        AssertThatOptionalInt() {
        }

        AbstractIntegerAssert<?> before(OptionalInt optional, int expected) {
            return Assertions.assertThat((int)optional.getAsInt()).isEqualTo(expected);
        }

        OptionalIntAssert after(OptionalInt optional, int expected) {
            return (OptionalIntAssert)Assertions.assertThat((OptionalInt)optional).hasValue(expected);
        }
    }

    static final class AssertThatOptionalDouble {
        AssertThatOptionalDouble() {
        }

        AbstractDoubleAssert<?> before(OptionalDouble optional, double expected) {
            return Assertions.assertThat((double)optional.getAsDouble()).isEqualTo(expected);
        }

        OptionalDoubleAssert after(OptionalDouble optional, double expected) {
            return (OptionalDoubleAssert)Assertions.assertThat((OptionalDouble)optional).hasValue(expected);
        }
    }
}

