/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractIterableSizeAssert;
import org.assertj.core.api.Assert;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.api.ObjectEnumerableAssert;

final class AssertJEnumerableRules {
    private AssertJEnumerableRules() {
    }

    static final class EnumerableAssertHasSameSizeAs<S, E> {
        EnumerableAssertHasSameSizeAs() {
        }

        EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Iterable<E> iterable) {
            return enumAssert.hasSize(Iterables.size(iterable));
        }

        EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Collection<E> iterable) {
            return enumAssert.hasSize(iterable.size());
        }

        EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, E[] iterable) {
            return enumAssert.hasSize(iterable.length);
        }

        EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, CharSequence iterable) {
            return enumAssert.hasSize(iterable.length());
        }

        EnumerableAssert<?, S> after(EnumerableAssert<?, S> enumAssert, Iterable<E> iterable) {
            return enumAssert.hasSameSizeAs(iterable);
        }
    }

    static final class EnumerableAssertHasSizeBetween<E> {
        EnumerableAssertHasSizeBetween() {
        }

        AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int lower, int upper) {
            return ((AbstractIterableSizeAssert)enumAssert.size().isBetween(Integer.valueOf(lower), Integer.valueOf(upper))).returnToIterable();
        }

        AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int lower, int upper) {
            return (AbstractIterableSizeAssert)enumAssert.size().isBetween(Integer.valueOf(lower), Integer.valueOf(upper));
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int lower, int upper) {
            return enumAssert.hasSizeBetween(lower, upper);
        }
    }

    static final class EnumerableAssertHasSizeGreaterThanOrEqualTo<E> {
        EnumerableAssertHasSizeGreaterThanOrEqualTo() {
        }

        AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return ((AbstractIterableSizeAssert)enumAssert.size().isGreaterThanOrEqualTo(size)).returnToIterable();
        }

        AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return (AbstractIterableSizeAssert)enumAssert.size().isGreaterThanOrEqualTo(size);
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {
            return enumAssert.hasSizeGreaterThanOrEqualTo(size);
        }
    }

    static final class EnumerableAssertHasSizeGreaterThan<E> {
        EnumerableAssertHasSizeGreaterThan() {
        }

        AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return ((AbstractIterableSizeAssert)enumAssert.size().isGreaterThan(size)).returnToIterable();
        }

        AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return (AbstractIterableSizeAssert)enumAssert.size().isGreaterThan(size);
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {
            return enumAssert.hasSizeGreaterThan(size);
        }
    }

    static final class EnumerableAssertHasSizeLessThanOrEqualTo<E> {
        EnumerableAssertHasSizeLessThanOrEqualTo() {
        }

        AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return ((AbstractIterableSizeAssert)enumAssert.size().isLessThanOrEqualTo(size)).returnToIterable();
        }

        AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return (AbstractIterableSizeAssert)enumAssert.size().isLessThanOrEqualTo(size);
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {
            return enumAssert.hasSizeLessThanOrEqualTo(size);
        }
    }

    static final class EnumerableAssertHasSizeLessThan<E> {
        EnumerableAssertHasSizeLessThan() {
        }

        AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return ((AbstractIterableSizeAssert)enumAssert.size().isLessThan(size)).returnToIterable();
        }

        AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return (AbstractIterableSizeAssert)enumAssert.size().isLessThan(size);
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {
            return enumAssert.hasSizeLessThan(size);
        }
    }

    static final class EnumerableAssertHasSize<E> {
        EnumerableAssertHasSize() {
        }

        AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return ((AbstractIterableSizeAssert)enumAssert.size().isEqualTo(size)).returnToIterable();
        }

        AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {
            return (AbstractIterableSizeAssert)enumAssert.size().isEqualTo(size);
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {
            return enumAssert.hasSize(size);
        }
    }

    static final class EnumerableAssertIsNotEmpty<E> {
        EnumerableAssertIsNotEmpty() {
        }

        EnumerableAssert<?, E> before(EnumerableAssert<?, E> enumAssert) {
            return (EnumerableAssert)Refaster.anyOf((Object[])new EnumerableAssert[]{enumAssert.hasSizeGreaterThan(0), enumAssert.hasSizeGreaterThanOrEqualTo(1)});
        }

        AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert) {
            return (AbstractIterableAssert)Refaster.anyOf((Object[])new AbstractIterableAssert[]{((AbstractIterableSizeAssert)enumAssert.size().isNotEqualTo(0)).returnToIterable(), ((AbstractIterableSizeAssert)enumAssert.size().isPositive()).returnToIterable()});
        }

        AbstractIntegerAssert<?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIterableSizeAssert[]{(AbstractIterableSizeAssert)enumAssert.size().isNotEqualTo(0), (AbstractIterableSizeAssert)enumAssert.size().isPositive()});
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert) {
            return enumAssert.isNotEmpty();
        }
    }

    static final class AssertAndEnumerableAssertIsEmpty<E, A extends Assert<?, ? extends Iterable<? extends E>> & EnumerableAssert<?, E>> {
        AssertAndEnumerableAssertIsEmpty() {
        }

        void before(A enumAssert, Iterable<?> emptyIterable) {
            enumAssert.isEqualTo(emptyIterable);
        }

        void after(A enumAssert) {
            ((EnumerableAssert)enumAssert).isEmpty();
        }
    }

    static final class EnumerableAssertIsEmpty<E> {
        EnumerableAssertIsEmpty() {
        }

        void before(EnumerableAssert<?, E> enumAssert, Iterable<?> emptyIterable) {
            Refaster.anyOf((Object[])new EnumerableAssert[]{enumAssert.hasSize(0), enumAssert.hasSizeLessThanOrEqualTo(0), enumAssert.hasSizeLessThan(1), enumAssert.hasSameSizeAs(emptyIterable)});
        }

        void before(ObjectEnumerableAssert<?, E> enumAssert, Iterable<? extends E> emptyIterable) {
            Refaster.anyOf((Object[])new ObjectEnumerableAssert[]{enumAssert.containsExactlyElementsOf(emptyIterable), enumAssert.containsExactlyInAnyOrderElementsOf(emptyIterable), enumAssert.hasSameElementsAs(emptyIterable), enumAssert.isSubsetOf(emptyIterable), enumAssert.containsExactly(new Object[0]), enumAssert.containsExactlyInAnyOrder(new Object[0]), enumAssert.containsOnly(new Object[0]), enumAssert.isSubsetOf(new Object[0])});
        }

        void before(AbstractIterableAssert<?, ?, E, ?> enumAssert) {
            enumAssert.size().isNotPositive();
        }

        void after(EnumerableAssert<?, E> enumAssert) {
            enumAssert.isEmpty();
        }
    }
}

