/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;
import java.util.Objects;
import java.util.Optional;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Prefer `.hasValue(value)` and `.containsSame(value)` over more verbose alternatives", link="https://error-prone.picnic.tech/bugpatterns/AssertJOptionalAssertion", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class AssertJOptionalAssertion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final ImmutableMap<String, String> REPLACEMENT_METHODS = ImmutableMap.of((Object)"isEqualTo", (Object)"hasValue", (Object)"isSameAs", (Object)"containsSame");
    private static final Matcher<MethodInvocationTree> ASSERTION = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.Assert").namedAnyOf((Iterable)REPLACEMENT_METHODS.keySet()), Matchers.argumentCount((int)1)});
    private static final Matcher<ExpressionTree> OPTIONAL_UNWRAP = Matchers.instanceMethod().onExactClass(Optional.class.getCanonicalName()).namedAnyOf(new String[]{"get", "orElseThrow"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ASSERTION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return AssertJOptionalAssertion.extractOptionalUnwrap(tree, state).map(optionalUnwrap -> this.describeMatch(tree, (Fix)AssertJOptionalAssertion.suggestFix(tree, optionalUnwrap, state))).orElse(Description.NO_MATCH);
    }

    private static Optional<MethodInvocationTree> extractOptionalUnwrap(MethodInvocationTree tree, VisitorState state) {
        MethodInvocationTree subject;
        MethodInvocationTree receiver;
        ExpressionTree expressionTree = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!(expressionTree instanceof MethodInvocationTree) || (receiver = (MethodInvocationTree)expressionTree).getArguments().size() != 1 || !ASTHelpers.getSymbol((MethodInvocationTree)receiver).isStatic()) {
            return Optional.empty();
        }
        Object object = Iterables.getOnlyElement(receiver.getArguments());
        if (!(object instanceof MethodInvocationTree) || !OPTIONAL_UNWRAP.matches((Tree)(subject = (MethodInvocationTree)object), state)) {
            return Optional.empty();
        }
        return Optional.of(subject);
    }

    private static SuggestedFix suggestFix(MethodInvocationTree assertion, MethodInvocationTree optionalUnwrap, VisitorState state) {
        ExpressionTree optional = Objects.requireNonNull(ASTHelpers.getReceiver((ExpressionTree)optionalUnwrap), "Method invocation must have receiver");
        return SuggestedFixes.renameMethodInvocation((MethodInvocationTree)assertion, (String)AssertJOptionalAssertion.getReplacementMethod(assertion), (VisitorState)state).toBuilder().replace((Tree)optionalUnwrap, SourceCode.treeToString((Tree)optional, (VisitorState)state)).build();
    }

    private static String getReplacementMethod(MethodInvocationTree tree) {
        return Objects.requireNonNull((String)REPLACEMENT_METHODS.get((Object)((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString()), "Unexpected method name");
    }
}

